#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Mail;

use strict;
use warnings;

use Lib::String;

# コンストラクタ
sub new {
    my $self = {};

    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();

    $self->{sendmail_path} = $conf->get_sendmail_path();
    $self->{from} = $conf->get_admin_address();

    bless($self);
    return $self;
}

# 送信元を設定
sub set_from {
    my $self = shift;
    $self->{from} = shift;
}

# メールを送信する
sub send {
    my $self = shift;
    my ($subject, $body, @addrlist) = @_;
    my $from = $self->{from};
    my $sendmail_path = $self->{sendmail_path};

    # subjectをMIME-Base64形式に変換
    my $string = Lib::String->new();
    $subject = $string->encode_mime($subject);

    foreach my $mailaddr (@addrlist) {

        # メッセージの作成
        my $msg = <<"END_MESSAGE";
From: $from
To: $mailaddr
Subject: $subject
Mime-Version: 1.0
Content-Type: text/plain; charset=iso-2022-jp
Content-Transfer-Encoding: 7bit

$body
END_MESSAGE

        # 文字コードをJISに変換
        $msg = $string->convert($msg, 'utf8', 'jis');

        # メールを送信する
        open my $mailh, "| $sendmail_path -t -oi $mailaddr";
        print {$mailh} $msg;
        close $mailh;
    }
}

1;
# End of Mail.pm
