/*
 * Decompiled with CFR 0.152.
 */
package com.muimi.webwiz;

import com.muimi.webwiz.WebLibDesc;
import com.muimi.webwiz.WebResourceDesc;
import com.muimi.webwiz.WebtoolsPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class WebWizBuilder {
    private IContainer webFolder;
    private WebResourceDesc webDesc;
    private boolean classPathAdd;
    private boolean sourceAttach;

    public void build() {
        if (this.webFolder == null) {
            throw new IllegalStateException("Web Foler is null");
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    WebWizBuilder.this.build_internal(monitor);
                }
                catch (Exception e) {
                    WebtoolsPlugin.logError("fail to resource operation", e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(new Shell()).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ignore) {
            ignore.printStackTrace();
        }
    }

    private void build_internal(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("import resources", 10);
        monitor.worked(1);
        this.importResources();
        monitor.worked(7);
        this.webFolder.refreshLocal(2, null);
        monitor.worked(1);
        if (this.classPathAdd) {
            this.addClassPathEntry();
        }
        monitor.done();
    }

    private void importResources() throws Exception {
        String buildFileLoc = WebtoolsPlugin.getDefault().getResourcePath("script/copy.xml");
        String fromDirLoc = WebtoolsPlugin.getDefault().getResourcePath(this.asImportResourcePath());
        Properties prop = new Properties();
        String toDirLoc = this.webFolder.getLocation().toString();
        prop.setProperty("todir", toDirLoc);
        prop.setProperty("fromdir", fromDirLoc);
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(buildFileLoc);
        runner.addUserProperties((Map)prop);
        runner.run();
    }

    private void addClassPathEntry() throws CoreException {
        IProject project = this.webFolder.getProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        project.getDescription();
        IClasspathEntry[] rawEntries = jProject.getRawClasspath();
        int i = 0;
        while (i < rawEntries.length) {
            entries.add(rawEntries[i]);
            ++i;
        }
        IResource[] jars = this.webFolder.getFolder((IPath)new Path("WEB-INF/lib")).members();
        int i2 = 0;
        while (i2 < jars.length) {
            IResource jar = jars[i2];
            IPath jarPath = jar.getFullPath();
            if (!this.containEntry(entries, jarPath)) {
                IPath srcPath = null;
                WebLibDesc libDesc = (WebLibDesc)this.webDesc.getLibMap().get(jar.getName());
                if (libDesc != null) {
                    srcPath = libDesc.getSourcePath();
                    URL javadocUrl = libDesc.getJavaDocURL();
                    if (javadocUrl != null) {
                        JavaUI.setLibraryJavadocLocation((IPath)jarPath, (URL)javadocUrl);
                    }
                }
                entries.add(JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null));
            }
            ++i2;
        }
        jProject.setRawClasspath(entries.toArray(new IClasspathEntry[0]), (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean containEntry(List entries, IPath path) {
        int i = 0;
        while (i < entries.size()) {
            IClasspathEntry entry = (IClasspathEntry)entries.get(i);
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String asImportResourcePath() {
        return "resource/" + this.webDesc.getPath() + "/web";
    }

    public boolean isClassPathAdd() {
        return this.classPathAdd;
    }

    public void setClassPathAdd(boolean classPathAdd) {
        this.classPathAdd = classPathAdd;
    }

    public WebResourceDesc getDesc() {
        return this.webDesc;
    }

    public void setDesc(WebResourceDesc desc) {
        this.webDesc = desc;
    }

    public boolean isSourceAttach() {
        return this.sourceAttach;
    }

    public void setSourceAttach(boolean sourceAttach) {
        this.sourceAttach = sourceAttach;
    }

    public IContainer getWebFolder() {
        return this.webFolder;
    }

    public void setWebFolder(IContainer webFolder) {
        this.webFolder = webFolder;
    }
}

