/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.FindCondition;
import jp.ac.osaka_u.sanken.sparql.HttpAuthenticator;
import jp.ac.osaka_u.sanken.sparql.QueryThread;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultListener;
import jp.ac.osaka_u.sanken.sparql.SparqlResultSet;
import jp.ac.osaka_u.sanken.sparql.TargetPredicate;
import jp.ac.osaka_u.sanken.sparql.ThreadedSparqlAccessor;

public abstract class SparqlWebAccessorBase
implements ThreadedSparqlAccessor {
    protected EndpointSettings setting;
    private SparqlQueryListener queryListener;

    public SparqlWebAccessorBase(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        this.queryListener = queryListener;
        this.setting = endpoint;
    }

    public SparqlWebAccessorBase(EndpointSettings endpoint) {
        this(endpoint, null);
    }

    public EndpointSettings getSetting() {
        return this.setting;
    }

    protected QueryExecution makeQuery(String queryString) {
        System.out.println("query:[" + queryString + "]");
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.getSetting().getEndpoint(), (Query)query);
        return qe;
    }

    @Override
    public boolean executeQuery(String queryString, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(queryString, resultListener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(SparqlWebAccessorBase.this.executeQuery(this.getQueryString())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> executeQuery(String queryString) throws Exception {
        if (this.getSetting().isEditable()) {
            HttpAuthenticator http_authenticator = new HttpAuthenticator(this.getSetting().getUser(), this.getSetting().getPass());
            Authenticator.setDefault(http_authenticator);
        }
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        try {
            System.out.println("query:" + queryString);
            if (this.queryListener != null) {
                this.queryListener.sparqlExecuted(queryString);
            }
            ResultSet results = null;
            try {
                results = this.customQuery(queryString);
                List keys = results.getResultVars();
                while (results.hasNext()) {
                    QuerySolution result = results.next();
                    HashMap<String, RDFNode> map = new HashMap<String, RDFNode>();
                    for (String key : keys) {
                        RDFNode node = result.get(key);
                        map.put(key, node);
                    }
                    ret.add(map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    protected abstract ResultSet customQuery(String var1) throws Exception;

    @Override
    public SparqlResultSet findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList) throws Exception {
        String query;
        word = word.replace(" ", "%20");
        if (!fullMatch) {
            if (type == 1) {
                query = "select distinct ?s where {\n?s <http://www.w3.org/2000/01/rdf-schema#label> ?o \nFILTER(regex(str(?s), \"" + word + "\", \"m\"))\n" + "}";
            } else if (type == 2) {
                query = "select distinct ?s where {\n?s ?p ?o \nFILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}";
            } else if (type == 3) {
                query = "select distinct ?s where {\n";
                query = String.valueOf(query) + this.getPropertySparql(propList);
                query = String.valueOf(query) + "FILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}";
            } else {
                query = "select distinct ?s where {\n";
                query = String.valueOf(query) + this.getPropertySparql(propList);
                query = String.valueOf(query) + "FILTER(regex(str(?o), \"" + word + "\", \"m\"))\n" + "}";
            }
        } else if (type == 2) {
            query = "select distinct ?s where \n{{?s ?p \"" + word + "\"} UNION \n" + "{?s ?p \"" + word + "\"@en} UNION \n" + "{?s ?p \"" + word + "\"@ja} ";
            String[] namespaces = this.setting.getNamespaceList();
            if (namespaces != null && namespaces.length > 0) {
                query = String.valueOf(query) + "UNION \n";
            }
            int i = 0;
            while (i < namespaces.length) {
                String ns = namespaces[i];
                query = String.valueOf(query) + "{?s ?p <" + ns + "/" + word + ">} ";
                query = i != namespaces.length - 1 ? String.valueOf(query) + "UNION \n" : String.valueOf(query) + "\n";
                ++i;
            }
            if (word.startsWith("http")) {
                query = String.valueOf(query) + "UNION \n";
                query = String.valueOf(query) + "{?s ?p <" + word + ">} ";
            }
            query = String.valueOf(query) + "}";
        } else if (type == 3) {
            query = "select distinct ?s where \n{";
            query = String.valueOf(query) + this.getPropertySparql(propList, word);
            query = String.valueOf(query) + "}";
        } else {
            if (type == 1) {
                String[] namespaces = this.setting.getNamespaceList();
                ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
                int i = 0;
                while (i < namespaces.length) {
                    String ns = namespaces[i];
                    String query2 = "select ?o where {\n<" + ns + "/" + word + "> ?p ?o \n";
                    List<Map<String, RDFNode>> temp = this.executeQuery(query2 = String.valueOf(query2) + "}");
                    if (temp != null && temp.size() > 0) {
                        HashMap<String, ResourceImpl> node = new HashMap<String, ResourceImpl>();
                        node.put("s", new ResourceImpl(String.valueOf(ns) + "/" + word));
                        ret.add(node);
                    }
                    ++i;
                }
                return new SparqlResultSet(ret, false);
            }
            query = "select distinct ?s where {\n";
            query = String.valueOf(query) + this.getPropertySparql(propList, word);
            query = String.valueOf(query) + "}";
        }
        if (limit != null && limit > 0) {
            query = String.valueOf(query) + "\n " + this.getQueryLimit(limit + 1);
        }
        if (offset != null && offset > 0) {
            query = String.valueOf(query) + "\n " + this.getQueryOffset(offset);
        }
        List<Map<String, RDFNode>> result = this.executeQuery(query);
        SparqlResultSet ret = new SparqlResultSet(result);
        if (limit != null && result != null && result.size() > limit) {
            result = result.subList(0, limit);
            ret.setDefaultResult(result);
            ret.setHasNext(true);
        }
        return ret;
    }

    @Override
    public String getQuery(List<FindCondition> conditions, List<TargetPredicate> predicates, String head, Integer limit, Integer offset) {
        return this.getQuery(this.getFindQuery(conditions), predicates, head, limit, offset);
    }

    private String getQuery(String conditions, List<TargetPredicate> predicates, String head, Integer limit, Integer offset) {
        String query = "prefix solr:<http://franz.com/ns/allegrograph/4.5/solr/>\nprefix dbp:<http://ja.dbpedia.org/property/>\nprefix rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nprefix foaf: <http://xmlns.com/foaf/0.1/>\n\nselect distinct ?s ";
        for (TargetPredicate preds : predicates) {
            query = String.valueOf(query) + "?" + preds.valiable + " ";
        }
        query = String.valueOf(query) + "{\n";
        if (head != null) {
            query = String.valueOf(query) + head;
        }
        query = String.valueOf(query) + conditions;
        for (TargetPredicate preds : predicates) {
            query = String.valueOf(query) + "OPTIONAL {?s " + preds.predicate + " ?" + preds.valiable + ". }\n";
        }
        query = String.valueOf(query) + "}\n";
        if (limit != null && limit > 0) {
            query = String.valueOf(query) + "\n " + this.getQueryLimit(limit + 1);
        }
        if (offset != null && offset > 0) {
            query = String.valueOf(query) + "\n " + this.getQueryOffset(offset);
        }
        return query;
    }

    @Override
    public SparqlResultSet find(String query, Integer limit) throws Exception {
        List<Map<String, RDFNode>> result = this.executeQuery(query);
        SparqlResultSet ret = new SparqlResultSet(result);
        if (limit != null && result != null && result.size() > limit) {
            result = result.subList(0, limit);
            ret.setDefaultResult(result);
            ret.setHasNext(true);
        }
        return ret;
    }

    @Override
    public SparqlResultSet find(List<FindCondition> conditions, List<TargetPredicate> predicates, String head, Integer limit, Integer offset) throws Exception {
        return this.find(this.getQuery(conditions, predicates, head, limit, offset), limit);
    }

    private String getFindQuery(List<FindCondition> conditions) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (FindCondition condition : conditions) {
            int findType = condition.matchType;
            if (condition.andOr != null) {
                sb.append(this.getPartQuery(condition.andOr.equals("and")));
            }
            sb.append(this.getPartQuery(condition.word, condition.predicate, index++, findType));
        }
        return sb.toString();
    }

    private String getPartQuery(String word, String type, int count, int findType) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        if (type.equals("subject")) {
            if (findType == 1) {
                sb.append("{\n");
                sb.append("  ?s ?p ?o.\n");
                sb.append("FILTER regex (str(?s), \"" + word + "\")\n");
                sb.append("}\n");
            } else if (word.startsWith("<")) {
                String subject = word.replace("<", "").replace(">", "");
                sb.append("{\n");
                sb.append("  <" + subject + "> ?p ?o.\n");
                sb.append("  ?s ?p ?o.\n");
                sb.append("FILTER regex (str(?s), \"^" + subject + "$\")\n");
                sb.append("}\n");
            } else {
                String[] namespaces = this.setting.getNamespaceList();
                int i = 0;
                while (i < namespaces.length) {
                    String ns = namespaces[i];
                    String subject = String.valueOf(ns) + "/" + word;
                    sb.append("{\n");
                    sb.append("  <" + subject + "> ?p ?o.\n");
                    sb.append("  ?s ?p ?o.\n");
                    sb.append("FILTER regex (str(?s), \"^" + subject + "$\")\n");
                    if (i == namespaces.length - 1) {
                        sb.append("}\n");
                    } else {
                        sb.append("} union\n");
                    }
                    ++i;
                }
            }
        } else if (findType == 1) {
            if (word.startsWith("<")) {
                sb.append("{  ?s " + type + " " + word + "}\n");
            } else {
                sb.append("{\n");
                sb.append("    {?s " + type + " ?o" + count + ".}\n");
                sb.append("}\n");
                sb.append("  FILTER regex(str(?o" + count + "), \"" + word + "\")\n");
            }
        } else if (word.startsWith("<")) {
            sb.append("{  ?s " + type + " " + word + "}\n");
        } else if (word.isEmpty()) {
            sb.append("{  ?s " + type + " ?o" + count + "}\n");
        } else {
            String[] namespaces = this.setting.getNamespaceList();
            sb.append("{  ?s " + type + " \"" + word + "\"} union\n");
            sb.append("{  ?s " + type + " \"" + word + "\"@en} union\n");
            sb.append("{  ?s " + type + " \"" + word + "\"@ja}");
            if (namespaces.length != 0) {
                sb.append(" union");
            }
            sb.append("\n");
            int i = 0;
            while (i < namespaces.length) {
                String ns = namespaces[i];
                String sep = "/";
                if (ns.endsWith("/") || ns.endsWith("#") || ns.endsWith(":")) {
                    sep = "";
                }
                String object = String.valueOf(ns) + sep + word;
                sb.append("{  ?s " + type + " <" + object + ">}");
                if (i == namespaces.length - 1) {
                    sb.append("\n");
                } else {
                    sb.append(" union\n");
                }
                ++i;
            }
            try {
                Double.parseDouble(word);
                sb.append("union {\n");
                sb.append("{  ?s " + type + " ?o" + count + "}\n");
                sb.append("FILTER (?o" + count + " = " + word + ")\n");
                sb.append("}\n");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String getPartQuery(boolean isAnd) {
        if (isAnd) {
            return "";
        }
        return "union ";
    }

    private String getPropertySparql(String[] propList) {
        StringBuilder sb = new StringBuilder();
        if (propList == null) {
            propList = new String[]{"http://www.w3.org/2000/01/rdf-schema#label"};
        }
        if (propList.length == 1) {
            sb.append("?s <");
            sb.append(propList[0]);
            sb.append("> ?o \n");
        } else {
            sb.append("{\n");
            int i = 0;
            while (i < propList.length) {
                sb.append("{?s <");
                sb.append(propList[i]);
                sb.append("> ?o ");
                if (i == propList.length - 1) {
                    sb.append("}\n");
                } else {
                    sb.append("} UNION \n");
                }
                ++i;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private String getPropertySparql(String[] propList, String word) {
        StringBuilder sb = new StringBuilder();
        if (propList == null) {
            propList = new String[]{"http://www.w3.org/2000/01/rdf-schema#label"};
        }
        sb.append("{\n");
        int i = 0;
        while (i < propList.length) {
            sb.append("{?s <" + propList[i] + "> \"" + word + "\"} UNION \n");
            sb.append("{?s <" + propList[i] + "> \"" + word + "\"@en} UNION \n");
            sb.append("{?s <" + propList[i] + "> \"" + word + "\"@ja");
            if (i == propList.length - 1) {
                sb.append("}\n");
            } else {
                sb.append("} UNION \n");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList, SparqlResultListener resultListener) {
        QueryThread thread = new QueryThread(word, new Object[]{new Boolean(fullMatch), limit, offset, new Integer(type), propList}, resultListener){

            @Override
            public void run() {
                try {
                    Boolean fullMatch = (Boolean)((Object[])this.getOption())[0];
                    Integer limit = (Integer)((Object[])this.getOption())[1];
                    Integer offset = (Integer)((Object[])this.getOption())[2];
                    Integer type = (Integer)((Object[])this.getOption())[3];
                    String[] propList = (String[])((Object[])this.getOption())[4];
                    this.getSparqlResultListener().resultReceived(SparqlWebAccessorBase.this.findSubject(this.getQueryString(), fullMatch, limit, offset, type, propList));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.setUncaughtExceptionHandler(resultListener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> findTripleFromSubject(String subject) throws Exception {
        subject = subject.replace(" ", "%20");
        String query = "select ?p ?o where {\n<" + subject + "> ?p ?o\n" + "}";
        return this.executeQuery(query);
    }

    @Override
    public boolean findTripleFromSubject(String subject, SparqlResultListener listener) {
        QueryThread thread = new QueryThread(subject, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(SparqlWebAccessorBase.this.findTripleFromSubject(this.getQueryString())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
        return true;
    }

    @Override
    public List<Map<String, RDFNode>> findPropertyList() throws Exception {
        ArrayList<Map<String, RDFNode>> ret = new ArrayList<Map<String, RDFNode>>();
        HashMap<String, RDFNode> result = new HashMap<String, RDFNode>();
        ret.add(result);
        String query = "select ?s {\n?s ?p ?o\n}" + this.getQueryLimit(10);
        List<Map<String, RDFNode>> subjects = this.executeQuery(query);
        for (Map<String, RDFNode> subjectMap : subjects) {
            RDFNode subject = subjectMap.get("s");
            query = "select distinct ?p where {\n<" + subject + "> ?p ?o\n" + "}";
            List<Map<String, RDFNode>> properties = this.executeQuery(query);
            for (Map<String, RDFNode> propertyMap : properties) {
                RDFNode property = propertyMap.get("p");
                result.put(property.toString(), property);
                System.out.println("p[" + property.toString() + "]");
            }
        }
        return ret;
    }

    protected abstract String getQueryLimit(int var1);

    protected abstract String getQueryOffset(int var1);

    protected abstract String getParamLimit(int var1);

    @Override
    public boolean findPropertyList(SparqlResultListener listener) {
        QueryThread thread = new QueryThread(null, listener){

            @Override
            public void run() {
                try {
                    this.getSparqlResultListener().resultReceived(new SparqlResultSet(SparqlWebAccessorBase.this.findPropertyList()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.setUncaughtExceptionHandler(listener);
        thread.start();
        return true;
    }

    protected InputStream getStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = br.readLine();
        while (line != null) {
            line = this.escape(line);
            bw.write(String.valueOf(line) + "\n");
            line = br.readLine();
        }
        br.close();
        bw.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    protected String getStreamContents(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = br.readLine();
        while (line != null) {
            line = this.escape(line);
            bw.write(String.valueOf(line) + "\n");
            line = br.readLine();
        }
        br.close();
        bw.close();
        return new String(baos.toByteArray(), "UTF-8");
    }

    protected InputStream getContentsStream(String str) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        bw.write(str);
        bw.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    private String escape(String line) {
        line = line.replaceAll("\"literal-typed\"", "\"literal\"");
        return line;
    }

    public static void main(String[] args) {
        try {
            URL url = new URL("http://www.wikipediaontology.org/query/?q=" + URLEncoder.encode("select * {?s ?p ?o}", "UTF-8") + "&type=xml&LIMIT=100");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "test");
            conn.setRequestProperty("Accept-Language", "ja");
            conn.setRequestProperty("Referer", "http://www.wikipediaontology.org/query/");
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

