/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.sanken.sparql;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import jp.ac.osaka_u.sanken.sparql.CustomSparqlAccessor;
import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.sparql.SparqlQueryListener;

public class LodacAccessor
extends CustomSparqlAccessor {
    public LodacAccessor(EndpointSettings endpoint) {
        super(endpoint);
    }

    public LodacAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener) {
        super(endpoint, queryListener);
    }

    @Override
    protected ResultSet customQuery(String query) throws Exception {
        URL url = new URL(this.setting.getEndpoint());
        String param = "query=" + URLEncoder.encode(query, this.setting.getEncoding()) + "&format=json";
        System.out.println("param:" + param);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept-Language", "ja");
        conn.setRequestProperty("Referer", this.setting.getEndpoint());
        conn.setDoOutput(true);
        OutputStream os = conn.getOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.print(param);
        ps.close();
        ResultSet ret = null;
        ret = ResultSetFactory.fromJSON((InputStream)conn.getInputStream());
        conn.disconnect();
        return ret;
    }

    @Override
    protected String getQueryLimit(int limit) {
        return "";
    }

    @Override
    protected String getQueryOffset(int offset) {
        return "";
    }

    @Override
    protected String getParamLimit(int limit) {
        return "&LIMIT=" + (limit + 1);
    }
}

