/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;

public class TransformReorder
extends TransformCopy {
    private ReorderTransformation reorder;

    public TransformReorder() {
        this(ReorderLib.fixed());
    }

    public TransformReorder(ReorderTransformation reorder) {
        if (reorder == null) {
            throw new IllegalArgumentException("reorder cannot be null");
        }
        this.reorder = reorder;
    }

    @Override
    public Op transform(OpBGP opBGP) {
        BasicPattern pattern = opBGP.getPattern();
        BasicPattern pattern2 = this.reorder.reorder(pattern);
        return new OpBGP(pattern2);
    }

    @Override
    public Op transform(OpQuadPattern opQuadPattern) {
        BasicPattern pattern = opQuadPattern.getBasicPattern();
        BasicPattern pattern2 = this.reorder.reorder(pattern);
        return new OpQuadPattern(opQuadPattern.getGraphNode(), pattern2);
    }
}

