/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.arg;

import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentTypeRegistry;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;

public class ArgumentsParser {
    protected static Logger logger = Logger.getLogger(ArgumentsParser.class);
    protected Object bean;
    protected BeanDesc beanDesc;

    public ArgumentsParser(Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.bean = bean;
        this.beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
    }

    public void parse(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDesc propertyDesc;
            String arg = stringArray[n2];
            int pos = arg.indexOf("=");
            if (pos < 0) {
                throw new IllegalArgumentException(arg);
            }
            String key = arg.substring(0, pos);
            String value = arg.substring(pos + 1, arg.length());
            if (this.beanDesc.hasPropertyDesc(key) && (propertyDesc = this.beanDesc.getPropertyDesc(key)).hasWriteMethod()) {
                ArgumentType argumentType = ArgumentTypeRegistry.getArgumentType(propertyDesc);
                if (argumentType == null) {
                    logger.log("WS2JDBCGEN0001", new Object[]{this.bean.getClass().getName(), propertyDesc.getPropertyName()});
                } else {
                    Object propertyValue = argumentType.toObject(value);
                    propertyDesc.setValue(this.bean, propertyValue);
                }
            }
            ++n2;
        }
    }
}

