/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueLabelUtil {
    public static String findLabel(List<Map<String, Object>> valueLabelList, Object value) {
        if (valueLabelList == null) {
            String msg = "The arguement[valueLabelList] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (valueLabelList.isEmpty()) {
            String msg = "The arguement[valueLabelList] should not be empty.";
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The arguement[value] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        for (Map<String, Object> elementMap : valueLabelList) {
            Object currentValue = elementMap.get("value");
            if (!value.equals(currentValue)) continue;
            return (String)elementMap.get("label");
        }
        String msg = "Not found label by the value: value=" + value + " valueLabelList=" + valueLabelList;
        throw new IllegalStateException(msg);
    }

    public static Map<Object, String> createValueLabelMap(List<Map<String, Object>> valueLabelList) {
        LinkedHashMap<Object, String> resultMap = new LinkedHashMap<Object, String>();
        for (Map<String, Object> elementMap : valueLabelList) {
            Object currentValue = elementMap.get("value");
            String currentLabel = (String)elementMap.get("label");
            resultMap.put(currentValue, currentLabel);
        }
        return resultMap;
    }

    public static Map<String, Object> createLabelValueMap(List<Map<String, Object>> valueLabelList) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (Map<String, Object> elementMap : valueLabelList) {
            Object currentValue = elementMap.get("value");
            String currentLabel = (String)elementMap.get("label");
            resultMap.put(currentLabel, currentValue);
        }
        return resultMap;
    }
}

