/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.InternalMapContext;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalRowCreator
extends RowCreatorImpl {
    private static final Log _log = LogFactory.getLog(InternalRowCreator.class);
    protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";
    protected DBMeta _dbmeta;

    protected InternalRowCreator() {
    }

    public static InternalRowCreator createInternalRowCreator(Class<?> beanClass) {
        InternalRowCreator rowCreator = new InternalRowCreator();
        if (beanClass != null) {
            rowCreator.setDBMeta(InternalRowCreator.findDBMetaByClass(beanClass));
        }
        return rowCreator;
    }

    public Object createRow(ResultSet rs, Map propertyCache, Class beanClass) throws SQLException {
        Object row;
        DBMeta dbmeta;
        Set columnNameSet = propertyCache.keySet();
        String columnName2 = null;
        PropertyType pt = null;
        String propertyName = null;
        if (this._dbmeta != null) {
            dbmeta = this._dbmeta;
            row = dbmeta.newEntity();
        } else {
            row = this.newBean(beanClass);
            dbmeta = InternalRowCreator.findDBMeta(row);
        }
        try {
            if (dbmeta != null) {
                for (String columnName2 : columnNameSet) {
                    pt = (PropertyType)propertyCache.get(columnName2);
                    propertyName = pt.getPropertyName();
                    if (dbmeta.hasEntityPropertySetupper(propertyName)) {
                        ValueType valueType = pt.getValueType();
                        Object value = valueType.getValue(rs, columnName2);
                        dbmeta.setupEntityProperty(propertyName, row, value);
                        continue;
                    }
                    this.registerValue(rs, row, pt, columnName2);
                }
            } else {
                for (String columnName2 : columnNameSet) {
                    pt = (PropertyType)propertyCache.get(columnName2);
                    propertyName = pt.getPropertyName();
                    this.registerValue(rs, row, pt, columnName2);
                }
            }
            return row;
        }
        catch (ClassCastException e) {
            if (_log.isWarnEnabled()) {
                String msg = String.valueOf(ClassCastException.class.getSimpleName()) + " occurred while ResultSet Handling:";
                _log.warn((Object)(String.valueOf(msg) + " target=" + beanClass.getSimpleName() + "." + propertyName + " dbmeta"));
            }
            this.throwNonsenseClassCastException(row, dbmeta, e);
            return null;
        }
        catch (SQLException e) {
            if (_log.isWarnEnabled()) {
                String msg = String.valueOf(SQLException.class.getSimpleName()) + " occurred while ResultSet Handling:";
                _log.warn((Object)(String.valueOf(msg) + " target=" + beanClass.getSimpleName() + "." + propertyName));
            }
            throw e;
        }
    }

    protected void throwNonsenseClassCastException(Object entity, DBMeta dbmeta, ClassCastException e) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Nonsense ClassCastException occured!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "This exception may be from ClassLoader Headache about HotDeploy." + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please add the ignore-package setting to convention.dicon like as follows:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    <initMethod name=\u201daddIgnorePackageName\u201d>" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        <arg>\u201dcom.example.xxx.dbflute\u201d</arg>" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    </initMethod>" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Exception Message]" + this.getLineSeparator() + e.getMessage() + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Target Entity]" + this.getLineSeparator() + entity + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Target Entity Class Loader]" + this.getLineSeparator() + entity.getClass().getClassLoader() + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Target DBMeta]" + this.getLineSeparator() + dbmeta + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Target DBMeta Class Loader]" + this.getLineSeparator() + dbmeta.getClass().getClassLoader() + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new NonsenseClassCastException(msg, e);
    }

    public static DBMeta findDBMeta(Object row) {
        return DBMetaCacheHandler.findDBMeta(row);
    }

    public static DBMeta findDBMeta(Class<?> rowType, String tableName) {
        return DBMetaCacheHandler.findDBMeta(rowType, tableName);
    }

    protected static DBMeta findDBMetaByClass(Class<?> beanClass) {
        Object instance = InternalRowCreator.newInstance(beanClass);
        if (!(instance instanceof Entity)) {
            return null;
        }
        return ((Entity)instance).getDBMeta();
    }

    protected static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    public void setDBMeta(DBMeta dbmeta) {
        this._dbmeta = dbmeta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DBMetaCacheHandler {
        protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";

        protected DBMetaCacheHandler() {
        }

        public static DBMeta findDBMeta(Object row) {
            if (!(row instanceof Entity)) {
                return null;
            }
            Entity entity = (Entity)row;
            DBMeta dbmeta = DBMetaCacheHandler.findCachedDBMeta(entity.getClass());
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = entity.getDBMeta();
            DBMetaCacheHandler.cacheDBMeta(entity, dbmeta);
            return dbmeta;
        }

        public static DBMeta findDBMeta(Class<?> rowType, String tableName) {
            DBMeta dbmeta = DBMetaCacheHandler.findCachedDBMeta(rowType);
            if (dbmeta != null) {
                return dbmeta;
            }
            try {
                dbmeta = DBMetaInstanceHandler.findDBMeta(tableName);
            }
            catch (DBMetaInstanceHandler.DBMetaNotFoundException ignored) {
                return null;
            }
            DBMetaCacheHandler.cacheDBMeta(rowType, dbmeta);
            return dbmeta;
        }

        protected static DBMeta findCachedDBMeta(Class<?> rowType) {
            Map<Class<?>, DBMeta> dbmetaCache = DBMetaCacheHandler.findDBMetaCache();
            if (dbmetaCache == null) {
                dbmetaCache = new HashMap();
                InternalMapContext.setObject("df:DBMetaCache", dbmetaCache);
            }
            return dbmetaCache.get(rowType);
        }

        protected static void cacheDBMeta(Entity entity, DBMeta dbmeta) {
            DBMetaCacheHandler.cacheDBMeta(entity.getClass(), dbmeta);
        }

        protected static void cacheDBMeta(Class<?> type, DBMeta dbmeta) {
            Map<Class<?>, DBMeta> dbmetaCache = DBMetaCacheHandler.findDBMetaCache();
            dbmetaCache.put(type, dbmeta);
        }

        protected static Map<Class<?>, DBMeta> findDBMetaCache() {
            return (Map)InternalMapContext.getObject("df:DBMetaCache");
        }
    }

    public static class NonsenseClassCastException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NonsenseClassCastException(String msg, ClassCastException e) {
            super(msg, e);
        }
    }
}

