/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalRowCreator;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.impl.RelationRowCreationResource;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalRelationRowCreator
extends RelationRowCreatorImpl {
    protected Object createRelationRow(RelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    protected void setupRelationKeyValue(RelationRowCreationResource res) {
        RelationPropertyType rpt = res.getRelationPropertyType();
        BeanMetaData bmd = rpt.getBeanMetaData();
        DBMeta dbmeta = this.findDBMeta(bmd.getBeanClass(), bmd.getTableName());
        int i = 0;
        while (i < rpt.getKeySize()) {
            String columnName = String.valueOf(rpt.getMyKey(i)) + res.getBaseSuffix();
            if (res.containsColumnName(columnName)) {
                Object value;
                if (!res.hasRowInstance()) {
                    Object row = dbmeta != null ? dbmeta.newEntity() : this.newRelationRow(rpt);
                    res.setRow(row);
                }
                if (res.containsRelKeyValueIfExists(columnName) && (value = res.extractRelKeyValue(columnName)) != null) {
                    String yourKey = rpt.getYourKey(i);
                    PropertyType pt = bmd.getPropertyTypeByColumnName(yourKey);
                    PropertyDesc pd = pt.getPropertyDesc();
                    pd.setValue(res.getRow(), value);
                }
            }
            ++i;
        }
    }

    protected Object createRelationRowInstance(DBMeta dbmeta) {
        if (dbmeta != null) {
            return dbmeta.newEntity();
        }
        return null;
    }

    protected DBMeta findDBMeta(Class<?> rowType, String tableName) {
        return InternalRowCreator.findDBMeta(rowType, tableName);
    }

    protected void setupRelationAllValue(RelationRowCreationResource res) throws SQLException {
        Map propertyCacheElement = res.extractPropertyCacheElement();
        Set columnNameCacheElementKeySet = propertyCacheElement.keySet();
        for (String columnName : columnNameCacheElementKeySet) {
            PropertyType pt = (PropertyType)propertyCacheElement.get(columnName);
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.hasNextRelationProperty() && (this.hasConditionBean(res) || res.hasNextRelationLevel())) {
            this.setupNextRelationRow(res);
        }
    }

    protected void registerRelationValue(RelationRowCreationResource res, String columnName) throws SQLException {
        PropertyType pt = res.getCurrentPropertyType();
        Object value = null;
        if (res.containsRelKeyValueIfExists(columnName)) {
            value = res.extractRelKeyValue(columnName);
        } else {
            ValueType valueType = pt.getValueType();
            value = valueType.getValue(res.getResultSet(), columnName);
        }
        if (value != null) {
            res.incrementValidValueCount();
            DBMeta dbmeta = this.findDBMeta(res.getRow());
            String propertyName = pt.getPropertyName();
            if (dbmeta != null && dbmeta.hasEntityPropertySetupper(propertyName)) {
                dbmeta.setupEntityProperty(propertyName, res.getRow(), value);
            } else {
                PropertyDesc pd = pt.getPropertyDesc();
                pd.setValue(res.getRow(), value);
            }
        }
    }

    protected DBMeta findDBMeta(Object row) {
        return InternalRowCreator.findDBMeta(row);
    }

    protected void setupPropertyCache(RelationRowCreationResource res) throws SQLException {
        res.initializePropertyCacheElement();
        if (this.hasConditionBean(res) && !this.hasSelectedForeignInfo(res)) {
            return;
        }
        BeanMetaData nextBmd = res.getRelationBeanMetaData();
        int i = 0;
        while (i < nextBmd.getPropertyTypeSize()) {
            PropertyType pt = nextBmd.getPropertyType(i);
            res.setCurrentPropertyType(pt);
            if (this.isTargetProperty(res)) {
                this.setupPropertyCacheElement(res);
            }
            ++i;
        }
        if (res.hasNextRelationProperty() && (this.hasConditionBean(res) || res.hasNextRelationLevel())) {
            res.backupRelationPropertyType();
            res.incrementCurrentRelationNestLevel();
            try {
                this.setupNextPropertyCache(res, nextBmd);
            }
            finally {
                res.restoreRelationPropertyType();
                res.decrementCurrentRelationNestLevel();
            }
        }
    }

    protected boolean isTargetProperty(RelationRowCreationResource res) throws SQLException {
        PropertyType pt = res.getCurrentPropertyType();
        if (!pt.getPropertyDesc().hasWriteMethod()) {
            return false;
        }
        return !List.class.isAssignableFrom(pt.getPropertyDesc().getPropertyType());
    }

    protected boolean isCreateDeadLink() {
        return false;
    }

    protected int getLimitRelationNestLevel() {
        return 2;
    }

    protected RelationRowCreationResource createResourceForRow(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues, Map relationPropertyCache) throws SQLException {
        RelationRowCreationResourceExtension res = new RelationRowCreationResourceExtension();
        res.setResultSet(rs);
        res.setRelationPropertyType(rpt);
        res.setColumnNames(columnNames);
        res.setRelKeyValues(relKeyValues);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix("");
        res.setRelationNoSuffix(this.buildRelationNoSuffix(rpt));
        res.setLimitRelationNestLevel(this.getLimitRelationNestLevel());
        res.setCurrentRelationNestLevel(1);
        res.setCreateDeadLink(this.isCreateDeadLink());
        return res;
    }

    protected RelationRowCreationResource createResourceForPropertyCache(RelationPropertyType rpt, Set columnNames, Map relationPropertyCache, String baseSuffix, String relationNoSuffix, int limitRelationNestLevel) throws SQLException {
        RelationRowCreationResourceExtension res = new RelationRowCreationResourceExtension();
        res.setRelationPropertyType(rpt);
        res.setColumnNames(columnNames);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix(baseSuffix);
        res.setRelationNoSuffix(relationNoSuffix);
        res.setLimitRelationNestLevel(limitRelationNestLevel);
        res.setCurrentRelationNestLevel(1);
        return res;
    }

    protected boolean isConditionBeanSelectedRelation(RelationRowCreationResource res) {
        ConditionBean cb;
        return this.hasConditionBean(res) && (cb = ConditionBeanContext.getConditionBeanOnThread()).getSqlClause().hasSelectedForeignInfo(res.getRelationNoSuffix());
    }

    protected boolean hasConditionBean(RelationRowCreationResource res) {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected boolean hasSelectedForeignInfo(RelationRowCreationResource res) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().hasSelectedForeignInfo(res.getRelationNoSuffix());
    }

    protected static class RelationRowCreationResourceExtension
    extends RelationRowCreationResource {
        protected Stack<RelationPropertyType> backupRelationPropertyType = new Stack();
        protected Stack<String> backupBaseSuffix = new Stack();
        protected Stack<String> backupRelationSuffix = new Stack();

        protected RelationRowCreationResourceExtension() {
        }

        public void backupRelationPropertyType() {
            this.backupRelationPropertyType.push(this.getRelationPropertyType());
        }

        public void restoreRelationPropertyType() {
            this.setRelationPropertyType(this.backupRelationPropertyType.pop());
        }

        public void backupSuffixAndPrepare(String baseSuffix, String additionalRelationNoSuffix) {
            this.backupBaseSuffixExtension();
            this.backupRelationNoSuffixExtension();
            this.setBaseSuffix(baseSuffix);
            this.addRelationNoSuffix(additionalRelationNoSuffix);
        }

        public void restoreSuffix() {
            this.restoreBaseSuffixExtension();
            this.restoreRelationNoSuffixExtension();
        }

        protected void backupBaseSuffixExtension() {
            this.backupBaseSuffix.push(this.getBaseSuffix());
        }

        protected void restoreBaseSuffixExtension() {
            this.setBaseSuffix(this.backupBaseSuffix.pop());
        }

        protected void backupRelationNoSuffixExtension() {
            this.backupRelationSuffix.push(this.getRelationNoSuffix());
        }

        protected void restoreRelationNoSuffixExtension() {
            this.setRelationNoSuffix(this.backupRelationSuffix.pop());
        }
    }
}

