/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import org.seasar.extension.jdbc.ValueType;

public class InternalBindVariableUtil {
    private static final String NULL = "null";
    protected static final Class<?>[] TOTEXT_ARGUMENT_TYPES = new Class[]{Object.class};
    protected static final Method TOTEXT_METHOD;

    static {
        Method method = null;
        try {
            method = ValueType.class.getMethod("toText", TOTEXT_ARGUMENT_TYPES);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        TOTEXT_METHOD = method;
    }

    private InternalBindVariableUtil() {
    }

    public static String getCompleteSql(String sql, Object[] args) {
        if (args == null || args.length == 0) {
            return sql;
        }
        return InternalBindVariableUtil.getCompleteSql(sql, args, new ValueType[args.length]);
    }

    public static String getCompleteSql(String sql, Object[] args, ValueType[] valueTypes) {
        if (args == null || args.length == 0) {
            return sql;
        }
        StringBuffer buf = new StringBuffer(sql.length() + args.length * 15);
        int pos = 0;
        int pos2 = 0;
        int pos3 = 0;
        int pos4 = 0;
        int pos5 = 0;
        int pos6 = 0;
        int index = 0;
        while (true) {
            pos = sql.indexOf(63, pos2);
            pos3 = sql.indexOf(39, pos2);
            pos4 = sql.indexOf(39, pos3 + 1);
            pos5 = sql.indexOf("/*", pos2);
            pos6 = sql.indexOf("*/", pos5 + 1);
            if (pos <= 0) break;
            if (pos3 >= 0 && pos3 < pos && pos < pos4) {
                buf.append(sql.substring(pos2, pos4 + 1));
                pos2 = pos4 + 1;
                continue;
            }
            if (pos5 >= 0 && pos5 < pos && pos < pos6) {
                buf.append(sql.substring(pos2, pos6 + 1));
                pos2 = pos6 + 1;
                continue;
            }
            if (args.length <= index) {
                String msg = "The size of bind arguments is illegal:";
                msg = String.valueOf(msg) + " size=" + args.length + " sql=" + sql;
                throw new IllegalStateException(msg);
            }
            buf.append(sql.substring(pos2, pos));
            buf.append(InternalBindVariableUtil.getBindVariableText(args[index], valueTypes[index]));
            pos2 = pos + 1;
            ++index;
        }
        buf.append(sql.substring(pos2));
        return buf.toString();
    }

    public static String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return InternalBindVariableUtil.quote(bindVariable.toString());
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Time) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            return InternalBindVariableUtil.quote(sdf.format((java.util.Date)bindVariable));
        }
        if (bindVariable instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat(InternalBindVariableUtil.getLogTimestampFormat());
            return InternalBindVariableUtil.quote(sdf.format((java.util.Date)bindVariable));
        }
        if (bindVariable instanceof java.util.Date) {
            SimpleDateFormat sdf = new SimpleDateFormat(InternalBindVariableUtil.getLogDateFormat());
            return InternalBindVariableUtil.quote(sdf.format((java.util.Date)bindVariable));
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return NULL;
        }
        return InternalBindVariableUtil.quote(bindVariable.toString());
    }

    protected static String getLogDateFormat() {
        String logDateFormat = DBFluteConfig.getInstance().getLogDateFormat();
        return logDateFormat != null ? logDateFormat : "yyyy-MM-dd";
    }

    protected static String getLogTimestampFormat() {
        String logTimestampFormat = DBFluteConfig.getInstance().getLogTimestampFormat();
        return logTimestampFormat != null ? logTimestampFormat : "yyyy-MM-dd HH:mm:ss";
    }

    public static String getBindVariableText(Object bindVariable, ValueType valueType) {
        if (valueType != null && TOTEXT_METHOD != null) {
            try {
                return (String)TOTEXT_METHOD.invoke((Object)valueType, bindVariable);
            }
            catch (IllegalArgumentException e) {
                String msg = "ValueType.toText() threw the IllegalArgumentException:";
                msg = String.valueOf(msg) + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = "ValueType.toText() threw the IllegalAccessException:";
                msg = String.valueOf(msg) + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                String msg = "ValueType.toText() threw the exception:";
                msg = String.valueOf(msg) + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e.getTargetException());
            }
        }
        return InternalBindVariableUtil.getBindVariableText(bindVariable);
    }

    public static String nullText() {
        return NULL;
    }

    public static String toText(Number value) {
        if (value == null) {
            return NULL;
        }
        return value.toString();
    }

    public static String toText(Boolean value) {
        if (value == null) {
            return NULL;
        }
        return InternalBindVariableUtil.quote(value.toString());
    }

    public static String toText(String value) {
        if (value == null) {
            return NULL;
        }
        return InternalBindVariableUtil.quote(value);
    }

    public static String toText(Date value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder buf = new StringBuilder();
        InternalBindVariableUtil.addDate(buf, calendar);
        return InternalBindVariableUtil.quote(buf.toString());
    }

    public static String toText(Time value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder buf = new StringBuilder();
        InternalBindVariableUtil.addTime(buf, calendar);
        InternalBindVariableUtil.addTimeDecimalPart(buf, calendar.get(14));
        return InternalBindVariableUtil.quote(buf.toString());
    }

    public static String toText(Timestamp value) {
        if (value == null) {
            return NULL;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        StringBuilder buf = new StringBuilder(30);
        InternalBindVariableUtil.addDate(buf, calendar);
        InternalBindVariableUtil.addTime(buf, calendar);
        InternalBindVariableUtil.addTimeDecimalPart(buf, value.getNanos());
        return InternalBindVariableUtil.quote(buf.toString());
    }

    public static String toText(byte[] value) {
        if (value == null) {
            return NULL;
        }
        return InternalBindVariableUtil.quote(String.valueOf(value.toString()) + "(byteLength=" + Integer.toString(value.length) + ")");
    }

    public static String toText(Object value) {
        if (value == null) {
            return NULL;
        }
        return InternalBindVariableUtil.quote(value.toString());
    }

    protected static void addDate(StringBuilder buf, Calendar calendar) {
        int year = calendar.get(1);
        buf.append(year);
        buf.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buf.append('0');
        }
        buf.append(month);
        buf.append('-');
        int date = calendar.get(5);
        if (date < 10) {
            buf.append('0');
        }
        buf.append(date);
    }

    protected static void addTime(StringBuilder buf, Calendar calendar) {
        int hour;
        if (buf.length() > 0) {
            buf.append(' ');
        }
        if ((hour = calendar.get(11)) < 10) {
            buf.append('0');
        }
        buf.append(hour);
        buf.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            buf.append('0');
        }
        buf.append(minute);
        buf.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            buf.append('0');
        }
        buf.append(second);
    }

    protected static void addTimeDecimalPart(StringBuilder buf, int decimalPart) {
        if (decimalPart == 0) {
            return;
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(decimalPart);
    }

    protected static String quote(String text) {
        return "'" + text + "'";
    }
}

