/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicSelectHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureMetaData;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureParameterType;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.util.CaseInsensitiveMap;

public class InternalProcedureHandler
extends InternalBasicSelectHandler {
    private InternalProcedureMetaData procedureMetaData;

    public InternalProcedureHandler(DataSource dataSource, String sql, ResultSetHandler resultSetHandler, StatementFactory statementFactory, InternalProcedureMetaData procedureMetaData) {
        super(dataSource, sql, resultSetHandler, statementFactory);
        this.procedureMetaData = procedureMetaData;
    }

    public Object execute(Connection connection, Object[] args, Class[] argTypes) {
        Object dto = this.getArgumentDto(args);
        this.logSql(args, argTypes);
        CallableStatement cs = null;
        try {
            ResultSet resultSet;
            cs = this.prepareCallableStatement(connection);
            this.bindArgs(cs, dto);
            Object returnValue = null;
            if (cs.execute() && (resultSet = cs.getResultSet()) != null) {
                ResultSetHandler handler = this.createReturnResultSetHandler(resultSet);
                try {
                    returnValue = handler.handle(resultSet);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            Object object = this.handleOutParameters(cs, dto, returnValue);
            return object;
        }
        catch (SQLException e) {
            this.handleSQLException(e, cs);
            return null;
        }
        finally {
            this.close(cs);
        }
    }

    protected ResultSetHandler createReturnResultSetHandler(ResultSet resultSet) {
        return new InternalMapListResultSetHandler();
    }

    protected String getCompleteSql(Object[] args) {
        String sql = this.getSql();
        Object dto = this.getArgumentDto(args);
        if (args == null || dto == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        for (InternalProcedureParameterType ppt : this.procedureMetaData.parameterTypes()) {
            pos2 = sql.indexOf(63, pos);
            if (pos2 < 0) break;
            sb.append(sql.substring(pos, pos2));
            pos = pos2 + 1;
            if (ppt.isInType()) {
                sb.append(this.getBindVariableText(ppt.getValue(dto)));
                continue;
            }
            sb.append(sql.substring(pos2, pos));
        }
        sb.append(sql.substring(pos));
        return sb.toString();
    }

    protected CallableStatement prepareCallableStatement(Connection connection) {
        if (this.getSql() == null) {
            throw new IllegalStateException("The SQL should not be null!");
        }
        return this.getStatementFactory().createCallableStatement(connection, this.getSql());
    }

    protected void bindArgs(CallableStatement cs, Object dto) throws SQLException {
        if (dto == null) {
            return;
        }
        int i = 0;
        for (InternalProcedureParameterType ppt : this.procedureMetaData.parameterTypes()) {
            ValueType valueType = ppt.getValueType();
            if (ppt.isOutType()) {
                valueType.registerOutParameter(cs, i + 1);
            }
            if (ppt.isInType()) {
                Object value = ppt.getValue(dto);
                valueType.bindValue((PreparedStatement)cs, i + 1, value);
            }
            ++i;
        }
    }

    protected Object handleResultSet(CallableStatement cs) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.getResultSet(cs);
            Object object = this.getResultSetHandler().handle(rs);
            return object;
        }
        finally {
            this.close(rs);
        }
    }

    protected ResultSet getResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
            return null;
        }
    }

    protected Object handleOutParameters(CallableStatement cs, Object dto, Object returnValue) throws SQLException {
        if (dto == null) {
            return null;
        }
        int i = 0;
        for (InternalProcedureParameterType ppt : this.procedureMetaData.parameterTypes()) {
            ValueType valueType = ppt.getValueType();
            if (ppt.isOutType()) {
                Object value = valueType.getValue(cs, i + 1);
                if (value instanceof ResultSet) {
                    ResultSet resultSet = (ResultSet)value;
                    ResultSetHandler handler = this.createOutParameterResultSetHandler(ppt, resultSet);
                    try {
                        value = handler.handle(resultSet);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                ppt.setValue(dto, value);
            } else if (ppt.isReturnType()) {
                ppt.setValue(dto, returnValue);
            }
            ++i;
        }
        return dto;
    }

    protected Object getArgumentDto(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            if (args[0] == null) {
                throw new IllegalArgumentException("args[0] should not be null!");
            }
            return args[0];
        }
        throw new IllegalArgumentException("args");
    }

    protected ResultSetHandler createOutParameterResultSetHandler(InternalProcedureParameterType ppt, ResultSet resultSet) {
        return new InternalMapListResultSetHandler();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class InternalAbstractMapResultSetHandler
    implements ResultSetHandler {
        protected InternalAbstractMapResultSetHandler() {
        }

        protected Map<String, Object> createRow(ResultSet rs, PropertyType[] propertyTypes) throws SQLException {
            CaseInsensitiveMap row = new CaseInsensitiveMap();
            int i = 0;
            while (i < propertyTypes.length) {
                Object value = propertyTypes[i].getValueType().getValue(rs, i + 1);
                row.put(propertyTypes[i].getPropertyName(), value);
                ++i;
            }
            return row;
        }

        protected PropertyType[] createPropertyTypes(ResultSetMetaData rsmd) throws SQLException {
            int count = rsmd.getColumnCount();
            PropertyType[] propertyTypes = new PropertyType[count];
            int i = 0;
            while (i < count) {
                String propertyName = rsmd.getColumnLabel(i + 1);
                ValueType valueType = ValueTypes.getValueType((int)rsmd.getColumnType(i + 1));
                propertyTypes[i] = new PropertyTypeImpl(propertyName, valueType);
                ++i;
            }
            return propertyTypes;
        }
    }

    protected static class InternalMapListResultSetHandler
    extends InternalAbstractMapResultSetHandler {
        protected InternalMapListResultSetHandler() {
        }

        public Object handle(ResultSet resultSet) throws SQLException {
            PropertyType[] propertyTypes = this.createPropertyTypes(resultSet.getMetaData());
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (resultSet.next()) {
                list.add(this.createRow(resultSet, propertyTypes));
            }
            return list;
        }
    }
}

