/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalAbstractAutoHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dao.BeanMetaData;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalAbstractBatchAutoHandler
extends InternalAbstractAutoHandler {
    private static final Log _log = LogFactory.getLog(InternalAbstractBatchAutoHandler.class);

    public InternalAbstractBatchAutoHandler(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, PropertyType[] propertyTypes) {
        super(dataSource, statementFactory, beanMetaData, propertyTypes);
    }

    public int[] execute(List<?> list, Class<?>[] argTypes) {
        return this.execute(list);
    }

    public int[] execute(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        if (list.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skip executeBatch() bacause of the empty list.");
            }
            return new int[0];
        }
        Connection connection = this.getConnection();
        try {
            int[] nArray;
            PreparedStatement ps = this.prepareStatement(connection);
            try {
                for (Object bean : list) {
                    this.prepareBatchElement(ps, bean);
                }
                nArray = this.executeBatch(ps, list);
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
            this.close(ps);
            return nArray;
        }
        finally {
            this.close(connection);
        }
    }

    @Override
    public int execute(Object[] args) {
        List list = null;
        if (args[0] instanceof Object[]) {
            list = Arrays.asList((Object[])args[0]);
        } else if (args[0] instanceof List) {
            list = (List)args[0];
        }
        if (list == null) {
            throw new IllegalArgumentException("args[0]");
        }
        int[] ret = this.execute(list);
        int updatedRow = 0;
        int i = 0;
        while (i < ret.length) {
            if (ret[i] > 0) {
                updatedRow += ret[i];
            }
            ++i;
        }
        return updatedRow;
    }

    public int[] executeBatch(Object[] args) {
        List list = null;
        if (args[0] instanceof Object[]) {
            list = Arrays.asList((Object[])args[0]);
        } else if (args[0] instanceof List) {
            list = (List)args[0];
        }
        if (list == null) {
            throw new IllegalArgumentException("args[0]");
        }
        return this.execute(list);
    }

    protected void prepareBatchElement(PreparedStatement ps, Object bean) {
        this.setupBindVariables(bean);
        this.logSql(this.getBindVariables(), this.getArgTypes(this.getBindVariables()));
        this.bindArgs(ps, this.getBindVariables(), this.getBindVariableValueTypes());
        this.addBatch(ps);
    }

    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
        try {
            return ps.executeBatch();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps, true);
            return null;
        }
    }

    protected void addBatch(PreparedStatement ps) {
        try {
            ps.addBatch();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
        }
    }
}

