/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalCommandContextHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlparser.InternalCommandContextCreator;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlparser.InternalSqlParser;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.SqlCommand;
import org.seasar.extension.jdbc.StatementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUpdateQueryAutoDynamicCommand
implements SqlCommand {
    protected DataSource dataSource;
    protected StatementFactory statementFactory;

    public InternalUpdateQueryAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        this.dataSource = dataSource;
        this.statementFactory = statementFactory;
    }

    public Object execute(Object[] args) {
        ConditionBean cb = this.extractConditionBeanWithCheck(args);
        Entity entity = this.extractEntityWithCheck(args);
        String[] argNames = new String[]{"dto", "entity"};
        Class[] argTypes = new Class[]{cb.getClass(), entity.getClass()};
        String twoWaySql = this.buildQueryUpdateTwoWaySql(cb, entity);
        if (twoWaySql == null) {
            return 0;
        }
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, args);
        InternalCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setLoggingMessageSqlArgs(context.getBindVariables());
        int rows = handler.execute(args);
        return new Integer(rows);
    }

    protected ConditionBean extractConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object fisrtArg = args[0];
        if (!(fisrtArg instanceof ConditionBean)) {
            String msg = "The type of first argument should be " + ConditionBean.class + "! But:";
            msg = String.valueOf(msg) + " type=" + fisrtArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)fisrtArg;
    }

    protected Entity extractEntityWithCheck(Object[] args) {
        this.assertArgument(args);
        Object secondArg = args[1];
        if (!(secondArg instanceof Entity)) {
            String msg = "The type of second argument should be " + Entity.class + "! But:";
            msg = String.valueOf(msg) + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (Entity)secondArg;
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument! But:";
            msg = String.valueOf(msg) + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected InternalCommandContextHandler createCommandContextHandler(CommandContext context) {
        return new InternalCommandContextHandler(this.dataSource, this.statementFactory, context);
    }

    protected String buildQueryUpdateTwoWaySql(ConditionBean cb, Entity entity) {
        LinkedHashMap<String, String> columnParameterMap = new LinkedHashMap<String, String>();
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(entity.getTableDbName());
        Set<String> modifiedPropertyNames = entity.getModifiedPropertyNames();
        if (modifiedPropertyNames.isEmpty()) {
            return null;
        }
        String currentPropertyName = null;
        try {
            ColumnInfo columnInfo;
            Iterator<String> iterator = modifiedPropertyNames.iterator();
            while (iterator.hasNext()) {
                String propertyName;
                currentPropertyName = propertyName = iterator.next();
                ColumnInfo columnInfo2 = dbmeta.findColumnInfo(propertyName);
                String columnName = columnInfo2.getColumnDbName();
                Method getter = columnInfo2.findGetter();
                Object value = getter.invoke((Object)entity, null);
                if (value != null) {
                    columnParameterMap.put(columnName, "/*entity." + propertyName + "*/null");
                    continue;
                }
                columnParameterMap.put(columnName, "null");
            }
            if (dbmeta.hasVersionNo()) {
                columnInfo = dbmeta.getVersionNoColumnInfo();
                String columnName = columnInfo.getColumnDbName();
                columnParameterMap.put(columnName, String.valueOf(columnName) + " + 1");
            }
            if (dbmeta.hasUpdateDate()) {
                columnInfo = dbmeta.getUpdateDateColumnInfo();
                Method setter = columnInfo.findSetter();
                if (Timestamp.class.isAssignableFrom(columnInfo.getPropertyType())) {
                    setter.invoke((Object)entity, new Timestamp(System.currentTimeMillis()));
                } else {
                    setter.invoke((Object)entity, new Date());
                }
                String columnName = columnInfo.getColumnDbName();
                columnParameterMap.put(columnName, "/*entity." + columnInfo.getPropertyName() + "*/null");
            }
        }
        catch (Exception e) {
            this.throwQueryUpdateFailureException(cb, entity, currentPropertyName, e);
        }
        return cb.getSqlClause().getClauseQueryUpdate(columnParameterMap);
    }

    protected void throwQueryUpdateFailureException(ConditionBean cb, Entity entity, String propertyName, Exception e) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "queryUpdate() failed to execute!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the parameter comment logic." + this.getLineSeparator();
        msg = String.valueOf(msg) + "It may exist the parameter comment that DOESN'T have an end comment." + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    before (x) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Doubtful Property Name]" + this.getLineSeparator() + propertyName + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[ConditionBean]" + this.getLineSeparator() + cb + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Entity]" + this.getLineSeparator() + entity + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Exception Message]" + this.getLineSeparator() + e.getMessage() + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new QueryUpdateFailureException(msg, e);
    }

    protected CommandContext createCommandContext(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        InternalSqlParser parser = new InternalSqlParser(twoWaySql);
        Node node = parser.parse();
        InternalCommandContextCreator creator = new InternalCommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        return context;
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    public static class QueryUpdateFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public QueryUpdateFailureException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

