/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.rshandler.InternalAbstractBeanMetaDataResultSetHandler;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.RelationKey;
import org.seasar.dao.impl.RelationRowCache;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;

public class InternalBeanListMetaDataResultSetHandler
extends InternalAbstractBeanMetaDataResultSetHandler {
    public InternalBeanListMetaDataResultSetHandler(BeanMetaData beanMetaData, RowCreator rowCreator, RelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    public Object handle(ResultSet rs) throws SQLException {
        Set columnNames = null;
        Map propertyCache = null;
        Map relationPropertyCache = null;
        RelationRowCache relRowCache = null;
        ArrayList<Object> list = new ArrayList<Object>();
        int relSize = this.getBeanMetaData().getRelationPropertyTypeSize();
        boolean hasCB = this.hasConditionBean();
        boolean emptyRelation = this.isSelectedForeignInfoEmpty();
        boolean hasOSC = this.hasOutsideSqlContext();
        boolean specifiedOutsideSql = this.isSpecifiedOutsideSql();
        boolean skipRelationLoop = hasCB && emptyRelation || hasOSC && specifiedOutsideSql;
        while (rs.next()) {
            if (columnNames == null) {
                columnNames = this.createColumnNames(rs.getMetaData());
            }
            if (propertyCache == null) {
                propertyCache = this.createPropertyCache(columnNames);
            }
            Object row = this.createRow(rs, propertyCache);
            if (skipRelationLoop) {
                this.postCreateRow(row);
                list.add(row);
                continue;
            }
            if (relationPropertyCache == null) {
                relationPropertyCache = this.createRelationPropertyCache(columnNames);
            }
            if (relRowCache == null) {
                relRowCache = new RelationRowCache(relSize);
            }
            int i = 0;
            while (i < relSize) {
                RelationPropertyType rpt = this.getBeanMetaData().getRelationPropertyType(i);
                if (rpt != null && (!hasCB || this.hasSelectedForeignInfo(this.buildRelationNoSuffix(rpt)))) {
                    HashMap relKeyValues = new HashMap();
                    RelationKey relKey = this.createRelationKey(rs, rpt, columnNames, relKeyValues);
                    Object relationRow = null;
                    if (relKey != null && (relationRow = relRowCache.getRelationRow(i, relKey)) == null && (relationRow = this.createRelationRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache)) != null) {
                        relRowCache.addRelationRow(i, relKey, relationRow);
                        this.postCreateRow(relationRow);
                    }
                    if (relationRow != null) {
                        PropertyDesc pd = rpt.getPropertyDesc();
                        pd.setValue(row, relationRow);
                    }
                }
                ++i;
            }
            this.postCreateRow(row);
            list.add(row);
        }
        return list;
    }

    protected RelationKey createRelationKey(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues) throws SQLException {
        ArrayList<Object> keyList = new ArrayList<Object>();
        BeanMetaData bmd = rpt.getBeanMetaData();
        int i = 0;
        while (i < rpt.getKeySize()) {
            ValueType valueType;
            PropertyType pt;
            String columnName = rpt.getMyKey(i);
            if (columnNames.contains(columnName)) {
                pt = this.getBeanMetaData().getPropertyTypeByColumnName(columnName);
                valueType = pt.getValueType();
            } else {
                pt = bmd.getPropertyTypeByColumnName(rpt.getYourKey(i));
                columnName = String.valueOf(pt.getColumnName()) + this.buildRelationNoSuffix(rpt);
                if (columnNames.contains(columnName)) {
                    valueType = pt.getValueType();
                } else {
                    return null;
                }
            }
            Object value = valueType.getValue(rs, columnName);
            if (value == null) {
                return null;
            }
            relKeyValues.put(columnName, value);
            keyList.add(value);
            ++i;
        }
        if (keyList.size() > 0) {
            Object[] keys = keyList.toArray();
            return new RelationKey(keys);
        }
        return null;
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected boolean isSelectedForeignInfoEmpty() {
        if (!this.hasConditionBean()) {
            return true;
        }
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().isSelectedForeignInfoEmpty();
    }

    protected boolean hasSelectedForeignInfo(String relationNoSuffix) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().hasSelectedForeignInfo(relationNoSuffix);
    }

    protected String buildRelationNoSuffix(RelationPropertyType rpt) {
        return "_" + rpt.getRelationNo();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected boolean isSpecifiedOutsideSql() {
        if (!this.hasOutsideSqlContext()) {
            return false;
        }
        OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
        return context.isSpecifiedOutsideSql();
    }
}

