/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.Dbms;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.AbstractPropertyTypeFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;

public class S2DaoPropertyTypeFactoryBuilderExtension
implements PropertyTypeFactoryBuilder {
    protected ValueTypeFactory valueTypeFactory;
    protected ColumnNaming columnNaming;

    public PropertyTypeFactory build(Class beanClass, BeanAnnotationReader beanAnnotationReader) {
        return new FastPropertyTypeFactoryExtension(beanClass, beanAnnotationReader, this.valueTypeFactory, this.columnNaming);
    }

    public PropertyTypeFactory build(Class beanClass, BeanAnnotationReader beanAnnotationReader, Dbms dbms, DatabaseMetaData databaseMetaData) {
        return new FastPropertyTypeFactoryExtension(beanClass, beanAnnotationReader, this.valueTypeFactory, this.columnNaming, dbms);
    }

    public ValueTypeFactory getValueTypeFactory() {
        return this.valueTypeFactory;
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    public ColumnNaming getColumnNaming() {
        return this.columnNaming;
    }

    public void setColumnNaming(ColumnNaming columnNaming) {
        this.columnNaming = columnNaming;
    }

    protected static class FastPropertyTypeFactoryExtension
    extends AbstractPropertyTypeFactory {
        protected DBMeta _dbmeta;
        protected String[] _noPersisteneProps;

        public FastPropertyTypeFactoryExtension(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming) {
            super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming);
            this.initializeResources();
        }

        public FastPropertyTypeFactoryExtension(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming, Dbms dbms) {
            super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming, dbms);
            this.initializeResources();
        }

        protected void initializeResources() {
            if (this.isEntity()) {
                this._dbmeta = this.findDBMeta();
            }
            this._noPersisteneProps = this.beanAnnotationReader.getNoPersisteneProps();
        }

        protected boolean isEntity() {
            return Entity.class.isAssignableFrom(this.beanClass);
        }

        protected boolean hasDBMeta() {
            return this._dbmeta != null;
        }

        protected DBMeta findDBMeta() {
            try {
                Entity entity = (Entity)this.beanClass.newInstance();
                return entity.getDBMeta();
            }
            catch (Exception e) {
                String msg = "beanClass.newInstance() threw the exception: beanClass=" + this.beanClass;
                throw new RuntimeException(msg, e);
            }
        }

        public PropertyType[] createBeanPropertyTypes(String tableName) {
            ArrayList<PropertyType> list = new ArrayList<PropertyType>();
            BeanDesc beanDesc = this.getBeanDesc();
            int i = 0;
            while (i < beanDesc.getPropertyDescSize()) {
                PropertyDesc pd = beanDesc.getPropertyDesc(i);
                if (pd.hasWriteMethod() && !this.isRelation(pd)) {
                    PropertyType pt = this.createPropertyType(pd);
                    pt.setPrimaryKey(this.isPrimaryKey(pd));
                    pt.setPersistent(this.isPersistent(pt));
                    list.add(pt);
                }
                ++i;
            }
            return list.toArray(new PropertyType[list.size()]);
        }

        protected boolean isRelation(PropertyDesc propertyDesc) {
            String propertyName = propertyDesc.getPropertyName();
            if (this.hasDBMeta() && (this._dbmeta.hasForeign(propertyName) || this._dbmeta.hasReferrer(propertyName))) {
                return true;
            }
            return this.hasRelationNoAnnotation(propertyDesc);
        }

        protected boolean hasRelationNoAnnotation(PropertyDesc propertyDesc) {
            return this.beanAnnotationReader.hasRelationNo(propertyDesc);
        }

        protected boolean isPrimaryKey(PropertyDesc propertyDesc) {
            String propertyName = propertyDesc.getPropertyName();
            if (this.hasDBMeta() && this._dbmeta.hasPrimaryKey() && this._dbmeta.hasColumn(propertyName) && this._dbmeta.findColumnInfo(propertyName).isPrimary()) {
                return true;
            }
            return this.hasIdAnnotation(propertyDesc);
        }

        protected boolean hasIdAnnotation(PropertyDesc propertyDesc) {
            Dbms dbms = this.getDbms();
            return this.beanAnnotationReader.getId(propertyDesc, dbms) != null;
        }

        protected boolean isPersistent(PropertyType propertyType) {
            String propertyName = propertyType.getPropertyName();
            PropertyDesc propertyDesc = propertyType.getPropertyDesc();
            return (this.hasDBMeta() && this._dbmeta.hasColumn(propertyName) || this.hasColumnAnnotation(propertyDesc)) && !this.isElementOfNoPersistentProps(propertyDesc);
        }

        protected boolean hasColumnAnnotation(PropertyDesc propertyDesc) {
            return this.beanAnnotationReader.getColumnAnnotation(propertyDesc) != null;
        }

        protected boolean isElementOfNoPersistentProps(PropertyDesc propertyDesc) {
            String propertyName = propertyDesc.getPropertyName();
            String[] props = this._noPersisteneProps;
            if (props != null && props.length >= 0) {
                int i = 0;
                while (i < props.length) {
                    if (props[i].equals(propertyName)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

