/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.impl;

import jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.InvokeNameExtractingResource;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.InvokeNameExtractor;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.InvokeNameResult;

public class InvokeNameExtractorImpl
implements InvokeNameExtractor {
    protected StackTraceElement[] _stackTrace;

    public InvokeNameResult extractInvokeName(InvokeNameExtractingResource resource) {
        if (this._stackTrace == null) {
            String msg = "The attribute 'stackTrace' should not be null: resource=" + resource;
            throw new IllegalStateException(msg);
        }
        String targetSimpleClassName = null;
        String targetMethodName = null;
        int lineNumber = 0;
        int foundIndex = -1;
        int foundFirstIndex = -1;
        boolean onTarget = false;
        int i = resource.getStartIndex();
        while (i < this._stackTrace.length) {
            StackTraceElement element = this._stackTrace[i];
            if (i > resource.getStartIndex() + resource.getLoopSize()) break;
            String className = element.getClassName();
            if (className.startsWith("sun.") || className.startsWith("java.")) {
                if (onTarget) {
                    break;
                }
            } else {
                String methodName = element.getMethodName();
                if (resource.isTargetElement(className, methodName)) {
                    if (!methodName.equals("invoke")) {
                        targetSimpleClassName = className.substring(className.lastIndexOf(".") + 1);
                        targetMethodName = methodName;
                        if (resource.isUseAdditionalInfo()) {
                            lineNumber = element.getLineNumber();
                        }
                        foundIndex = i;
                        if (foundFirstIndex == -1) {
                            foundFirstIndex = i;
                        }
                        onTarget = true;
                    }
                } else if (onTarget) break;
            }
            ++i;
        }
        InvokeNameResult result = new InvokeNameResult();
        if (targetSimpleClassName == null) {
            result.beEmptyResult();
            return result;
        }
        String filteredClassName = resource.filterSimpleClassName(targetSimpleClassName);
        result.setSimpleClassName(resource.filterSimpleClassName(targetSimpleClassName));
        result.setMethodName(targetMethodName);
        if (lineNumber > 0) {
            result.setInvokeName(String.valueOf(filteredClassName) + "." + targetMethodName + "():" + lineNumber + " --> ");
        } else {
            result.setInvokeName(String.valueOf(filteredClassName) + "." + targetMethodName + "() --> ");
        }
        result.setFoundIndex(foundIndex);
        result.setFoundFirstIndex(foundFirstIndex);
        return result;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this._stackTrace = stackTrace;
    }
}

