/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.RelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferrerInfo
implements RelationInfo {
    protected String referrerPropertyName;
    protected DBMeta localDBMeta;
    protected DBMeta referrerDBMeta;
    protected Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap;
    protected Map<ColumnInfo, ColumnInfo> referrerLocalColumnInfoMap;
    protected boolean oneToOne;

    public ColumnInfo findLocalByReferrer(String referrerColumnDbName) {
        ColumnInfo keyColumnInfo = new ColumnInfo(this.referrerDBMeta, referrerColumnDbName);
        ColumnInfo resultColumnInfo = this.referrerLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by referrerColumnDbName in referrerLocalColumnInfoMap:";
            msg = String.valueOf(msg) + " referrerColumnDbName=" + referrerColumnDbName + " referrerLocalColumnInfoMap=" + this.referrerLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public ColumnInfo findReferrerByLocal(String localColumnDbName) {
        ColumnInfo keyColumnInfo = new ColumnInfo(this.localDBMeta, localColumnDbName);
        ColumnInfo resultColumnInfo = this.localReferrerColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by localColumnDbName in localReferrerColumnInfoMap:";
            msg = String.valueOf(msg) + " localColumnDbName=" + localColumnDbName + " localReferrerColumnInfoMap=" + this.localReferrerColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public String buildInitCapPropertyName() {
        return this.initCap(this.referrerPropertyName);
    }

    public Method findSetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{List.class});
    }

    public Method findGetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getReferrerPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getReferrerDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalReferrerColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return true;
    }

    public String getReferrerPropertyName() {
        return this.referrerPropertyName;
    }

    public void setReferrerPropertyName(String referrerPropertyName) {
        this.referrerPropertyName = referrerPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this.localDBMeta;
    }

    public void setLocalDBMeta(DBMeta localDBMeta) {
        this.localDBMeta = localDBMeta;
    }

    public DBMeta getReferrerDBMeta() {
        return this.referrerDBMeta;
    }

    public void setReferrerDBMeta(DBMeta referrerDBMeta) {
        this.referrerDBMeta = referrerDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalReferrerColumnInfoMap() {
        return this.localReferrerColumnInfoMap;
    }

    public void setLocalReferrerColumnInfoMap(Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap) {
        this.localReferrerColumnInfoMap = localReferrerColumnInfoMap;
        Set<ColumnInfo> keySet = localReferrerColumnInfoMap.keySet();
        this.referrerLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localReferrerColumnInfoMap.get(key);
            this.referrerLocalColumnInfoMap.put(value, key);
        }
    }

    public Map<ColumnInfo, ColumnInfo> getReferrerLocalColumnInfoMap() {
        return this.referrerLocalColumnInfoMap;
    }

    @Override
    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    protected String initCap(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    protected Method findMethod(Class clazz, String methodName, Class[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }
}

