/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.ckey;

import java.util.List;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ckey.ConditionKey;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.ConditionOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.InScopeOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.cvalue.ConditionValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionKeyInScope
extends ConditionKey {
    private static final Log _log = LogFactory.getLog(ConditionKeyInScope.class);

    protected ConditionKeyInScope() {
        this._conditionKey = "inScope";
        this._operand = "in";
    }

    @Override
    public boolean isValidRegistration(ConditionValue conditionValue, Object value, String callerName) {
        if (value == null) {
            return false;
        }
        if (value instanceof List && ((List)value).isEmpty()) {
            return false;
        }
        if (value instanceof List && conditionValue.hasInScope()) {
            if (conditionValue.equalInScope((List)value)) {
                _log.debug((Object)("The value has already registered at " + callerName + ": value=" + value));
                return false;
            }
            conditionValue.overrideInScope((List)value);
            return false;
        }
        return true;
    }

    @Override
    protected void doAddWhereClause(List<String> conditionList, String columnName, ConditionValue value) {
        if (value.getInScope() == null) {
            return;
        }
        conditionList.add(this.buildBindClause(columnName, value.getInScopeLocation(), "('a1', 'a2')"));
    }

    @Override
    protected void doAddWhereClause(List<String> conditionList, String columnName, ConditionValue value, ConditionOption option) {
        if (option == null) {
            String msg = "The argument[option] should not be null: columnName=" + columnName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (!(option instanceof InScopeOption)) {
            String msg = "The argument[option] should be InScopeOption: columnName=" + columnName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        conditionList.add(this.buildBindClause(columnName, value.getInScopeLocation(), "('a1', 'a2')"));
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location) {
        conditionValue.setInScope((List)value).setInScopeLocation(location);
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location, ConditionOption option) {
        conditionValue.setInScope((List)value, (InScopeOption)option).setInScopeLocation(location);
    }
}

