/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.common.config.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import jp.sourceforge.ea2ddl.common.config.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigImpl
implements Config {
    private static final Log _log = LogFactory.getLog(ConfigImpl.class);
    private Properties _prop = new Properties();

    public void load(String configPath) {
        InputStream in = null;
        try {
            in = new URL(configPath).openStream();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException e) {
            _log.warn((Object)"Failed to read resource:", (Throwable)e);
        }
        if (in == null) {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(configPath);
        }
        if (in != null) {
            try {
                this._prop.load(in);
                _log.debug((Object)"config initialized.");
            }
            catch (IOException e) {
                _log.warn((Object)("Failed to read resource:" + e));
            }
        }
    }

    public String getProperty(String key) {
        return this._prop.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this._prop.getProperty(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return "true".equalsIgnoreCase(this.getProperty(key, "false"));
    }
}

