/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.util.List;
import org.seasar.extension.dataset.DataSet;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.unit.DataAccessor;
import org.seasar.framework.unit.ExpectedDataReader;
import org.seasar.framework.unit.TestContext;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class ExpectedDataReaderImpl
implements ExpectedDataReader {
    protected static final Logger logger = Logger.getLogger(ExpectedDataReaderImpl.class);
    protected final List<String> expectedDataXlsPaths = CollectionsUtil.newArrayList();
    protected DataAccessor dataAccessor;

    @Binding(bindingType=BindingType.MUST)
    public void setDataAccessor(DataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public void addExpectedDataXlsPath(String path) {
        this.expectedDataXlsPaths.add(path);
    }

    public DataSet read(TestContext testContext) {
        String dirPath = testContext.getTestClassPackagePath();
        boolean trimString = testContext.isTrimString();
        for (String path : this.expectedDataXlsPaths) {
            if (ResourceUtil.isExist((String)path)) {
                return this.readXls(path, trimString);
            }
            String newPath = dirPath + "/" + path;
            if (!ResourceUtil.isExist((String)newPath)) continue;
            return this.readXls(newPath, trimString);
        }
        return null;
    }

    protected DataSet readXls(String path, boolean trimString) {
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0104", new Object[]{path});
        }
        return this.dataAccessor.readXls(path, trimString);
    }
}

