/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.SqlFileBatchUpdate;
import org.seasar.extension.jdbc.exception.SEntityExistsException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.parameter.LobParameter;
import org.seasar.extension.jdbc.parameter.Parameter;
import org.seasar.extension.jdbc.parameter.TemporalParameter;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.sql.Node;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.cache.NodeCache;
import org.seasar.extension.sql.context.SqlContextImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileBatchUpdateImpl<T>
extends AbstractQuery<SqlFileBatchUpdate<T>>
implements SqlFileBatchUpdate<T> {
    protected String path;
    protected List<T> parameterList;
    protected int batchSize;
    protected Node node;
    protected SqlContext sqlContext;

    public SqlFileBatchUpdateImpl(JdbcManagerImplementor jdbcManager, String path, List<T> parameterList) {
        super(jdbcManager);
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.parameterList = parameterList;
    }

    @Override
    public SqlFileBatchUpdate<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public int[] execute() {
        this.prepare("execute");
        try {
            return this.executeInternal();
        }
        catch (RuntimeException e) {
            if (this.getJdbcManager().getDialect().isUniqueConstraintViolation(e)) {
                throw new SEntityExistsException(this.executedSql, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeInternal() {
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            PreparedStatement ps = null;
            int batchSize = this.batchSize > 0 ? this.batchSize : this.jdbcManager.getDialect().getDefaultBatchSize();
            int size = this.parameterList.size();
            int[] updateRows = new int[size];
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                T parameter = this.parameterList.get(i);
                this.prepareParameter(parameter);
                if (ps == null) {
                    this.prepareSql();
                    ps = this.getPreparedStatement(jdbcContext);
                }
                this.logSql();
                this.prepareInParams(ps);
                PreparedStatementUtil.addBatch((PreparedStatement)ps);
                this.resetParams();
                if (i != size - 1 && (batchSize <= 0 || (i + 1) % batchSize != 0)) continue;
                int[] rows = PreparedStatementUtil.executeBatch((PreparedStatement)ps);
                System.arraycopy(rows, 0, updateRows, pos, rows.length);
                pos = i + 1;
            }
            int[] nArray = updateRows;
            return nArray;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    protected PreparedStatement getPreparedStatement(JdbcContext jdbcContext) {
        PreparedStatement ps = jdbcContext.getPreparedStatement(this.executedSql);
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        return ps;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareNode();
    }

    protected void prepareNode() throws ResourceNotFoundRuntimeException {
        this.node = NodeCache.getNode(this.path, this.jdbcManager.getDialect().getName());
        if (this.node == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new ResourceNotFoundRuntimeException(this.path);
        }
    }

    protected void prepareParameter(T parameter) {
        this.sqlContext = new SqlContextImpl();
        if (parameter != null) {
            Class<?> clazz = parameter.getClass();
            if (ValueTypes.isSimpleType(clazz) || TemporalParameter.class == clazz || LobParameter.class == clazz) {
                this.sqlContext.addArg("$1", parameter, clazz);
            } else {
                BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
                for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                    PropertyDesc pd = beanDesc.getPropertyDesc(i);
                    if (!pd.isReadable()) continue;
                    Object value = Parameter.wrapIfNecessary(pd, pd.getValue(parameter));
                    this.sqlContext.addArg(pd.getPropertyName(), value, pd.getPropertyType());
                }
            }
        }
        this.node.accept(this.sqlContext);
        Object[] vars = this.sqlContext.getBindVariables();
        Class[] types = this.sqlContext.getBindVariableTypes();
        int size = vars.length;
        for (int i = 0; i < size; ++i) {
            this.addParam(vars[i], types[i]);
        }
    }

    protected void prepareSql() {
        this.executedSql = this.sqlContext.getSql();
    }
}

