/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.ColumnMeta;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.IdGenerator;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.RelationshipType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.exception.IdentityGeneratorNotSupportedRuntimeException;
import org.seasar.extension.jdbc.exception.SequenceGeneratorNotSupportedRuntimeException;
import org.seasar.framework.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMeta {
    protected String name;
    protected Class<?> propertyClass;
    protected Field field;
    protected ColumnMeta columnMeta;
    protected ValueType valueType;
    protected boolean id;
    protected GenerationType generationType;
    protected IdGenerator identityIdGenerator;
    protected IdGenerator sequenceIdGenerator;
    protected IdGenerator tableIdGenerator;
    protected TemporalType temporalType;
    protected EnumType enumType;
    protected boolean version;
    protected boolean trnsient;
    protected boolean lob;
    protected List<JoinColumnMeta> joinColumnMetaList = new ArrayList<JoinColumnMeta>();
    protected RelationshipType relationshipType;
    protected String mappedBy;
    protected Class<?> relationshipClass;
    protected ArrayMap additionalInfoMap = new ArrayMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
        this.propertyClass = field.getType();
    }

    public ColumnMeta getColumnMeta() {
        return this.columnMeta;
    }

    public void setColumnMeta(ColumnMeta columnMeta) {
        this.columnMeta = columnMeta;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public GenerationType getGenerationType() {
        return this.generationType;
    }

    public void setGenerationType(GenerationType generationType) {
        this.generationType = generationType;
    }

    public boolean hasIdGenerator() {
        return this.generationType != null;
    }

    public IdGenerator getIdGenerator(EntityMeta entityMeta, DbmsDialect dialect) {
        switch (this.generationType == GenerationType.AUTO ? dialect.getDefaultGenerationType() : this.generationType) {
            case IDENTITY: {
                if (!dialect.supportsIdentity()) {
                    throw new IdentityGeneratorNotSupportedRuntimeException(entityMeta.getName(), this.getName(), dialect.getName());
                }
                return this.identityIdGenerator;
            }
            case SEQUENCE: {
                if (!dialect.supportsSequence()) {
                    throw new SequenceGeneratorNotSupportedRuntimeException(entityMeta.getName(), this.getName(), dialect.getName());
                }
                return this.sequenceIdGenerator;
            }
            case TABLE: {
                return this.tableIdGenerator;
            }
        }
        return null;
    }

    public void setIdentityIdGenerator(IdGenerator idGenerator) {
        this.identityIdGenerator = idGenerator;
    }

    public void setSequenceIdGenerator(IdGenerator idGenerator) {
        this.sequenceIdGenerator = idGenerator;
    }

    public void setTableIdGenerator(IdGenerator idGenerator) {
        this.tableIdGenerator = idGenerator;
    }

    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    public void setTemporalType(TemporalType temporalType) {
        this.temporalType = temporalType;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    public void setEnumType(EnumType enumType) {
        this.enumType = enumType;
    }

    public boolean isTransient() {
        return this.trnsient;
    }

    public void setTransient(boolean tran) {
        this.trnsient = tran;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isLob() {
        return this.lob;
    }

    public void setLob(boolean lob) {
        this.lob = lob;
    }

    public List<JoinColumnMeta> getJoinColumnMetaList() {
        return this.joinColumnMetaList;
    }

    public void addJoinColumnMeta(JoinColumnMeta joinColumnMeta) {
        this.joinColumnMetaList.add(joinColumnMeta);
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public boolean isRelationship() {
        return this.relationshipType != null;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public Class<?> getRelationshipClass() {
        return this.relationshipClass;
    }

    public void setRelationshipClass(Class<?> relationshipClass) {
        this.relationshipClass = relationshipClass;
    }

    public Object getAdditionalInfo(String name) {
        return this.additionalInfoMap.get((Object)name);
    }

    public Object getAdditionalInfo(int index) {
        return this.additionalInfoMap.get(index);
    }

    public int getAdditionalInfoSize() {
        return this.additionalInfoMap.size();
    }

    public void addAdditionalInfo(String name, Object additionalInfo) {
        this.additionalInfoMap.put((Object)name, additionalInfo);
    }
}

