/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.TableMeta;
import org.seasar.extension.jdbc.exception.ColumnDuplicatedRuntimeException;
import org.seasar.extension.jdbc.exception.EntityColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.PropertyDuplicatedRuntimeException;
import org.seasar.extension.jdbc.exception.PropertyNotFoundRuntimeException;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMeta {
    protected String name;
    protected Class<?> entityClass;
    protected TableMeta tableMeta;
    protected CaseInsensitiveMap propertyMetaMap = new CaseInsensitiveMap();
    protected ArrayMap additionalInfoMap = new ArrayMap();
    protected List<PropertyMeta> idPropertyMetaList = new ArrayList<PropertyMeta>();
    protected PropertyMeta versionPropertyMeta;
    protected CaseInsensitiveMap mappedByPropertyMetaMap = new CaseInsensitiveMap();
    protected CaseInsensitiveMap columnPropertyMetaMap = new CaseInsensitiveMap();
    protected volatile boolean relationshipResolved = false;

    public EntityMeta() {
    }

    public EntityMeta(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public void setTableMeta(TableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public PropertyMeta getPropertyMeta(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyMeta meta = (PropertyMeta)this.propertyMetaMap.get((Object)propertyName);
        if (meta == null) {
            throw new PropertyNotFoundRuntimeException(this.name, propertyName);
        }
        return meta;
    }

    public PropertyMeta getColumnPropertyMeta(String columnName) throws EntityColumnNotFoundRuntimeException {
        PropertyMeta meta = (PropertyMeta)this.columnPropertyMetaMap.get((Object)columnName);
        if (meta == null) {
            throw new EntityColumnNotFoundRuntimeException(this.name, columnName);
        }
        return meta;
    }

    public boolean hasPropertyMeta(String propertyName) {
        return this.propertyMetaMap.containsKey(propertyName);
    }

    public boolean hasColumnPropertyMeta(String columnName) {
        return this.columnPropertyMetaMap.containsKey(columnName);
    }

    public int getPropertyMetaSize() {
        return this.propertyMetaMap.size();
    }

    public int getColumnPropertyMetaSize() {
        return this.columnPropertyMetaMap.size();
    }

    public PropertyMeta getPropertyMeta(int index) {
        return (PropertyMeta)this.propertyMetaMap.get(index);
    }

    public Iterable<PropertyMeta> getAllPropertyMeta() {
        return new Iterable<PropertyMeta>(){

            @Override
            public Iterator<PropertyMeta> iterator() {
                return new Iterator<PropertyMeta>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < EntityMeta.this.propertyMetaMap.size();
                    }

                    @Override
                    public PropertyMeta next() {
                        return (PropertyMeta)PropertyMeta.class.cast(EntityMeta.this.propertyMetaMap.get(this.i++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public PropertyMeta getColumnPropertyMeta(int index) {
        return (PropertyMeta)this.columnPropertyMetaMap.get(index);
    }

    public Iterable<PropertyMeta> getAllColumnPropertyMeta() {
        return new Iterable<PropertyMeta>(){

            @Override
            public Iterator<PropertyMeta> iterator() {
                return new Iterator<PropertyMeta>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < EntityMeta.this.columnPropertyMetaMap.size();
                    }

                    @Override
                    public PropertyMeta next() {
                        return (PropertyMeta)PropertyMeta.class.cast(EntityMeta.this.columnPropertyMetaMap.get(this.i++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<PropertyMeta> getIdPropertyMetaList() {
        return this.idPropertyMetaList;
    }

    public boolean hasVersionPropertyMeta() {
        return this.versionPropertyMeta != null;
    }

    public PropertyMeta getVersionPropertyMeta() {
        return this.versionPropertyMeta;
    }

    public PropertyMeta getMappedByPropertyMeta(String mappedBy, Class<?> relationshipClass) {
        Map m = (Map)this.mappedByPropertyMetaMap.get((Object)mappedBy);
        if (m == null) {
            return null;
        }
        return (PropertyMeta)m.get(relationshipClass.getName());
    }

    public void addPropertyMeta(PropertyMeta propertyMeta) {
        String columnName;
        PropertyMeta pm2;
        if (this.propertyMetaMap.put((Object)propertyMeta.getName(), (Object)propertyMeta) != null) {
            throw new PropertyDuplicatedRuntimeException(this.name, propertyMeta.getName());
        }
        if (propertyMeta.isId()) {
            this.idPropertyMetaList.add(propertyMeta);
        }
        if (propertyMeta.isVersion()) {
            this.versionPropertyMeta = propertyMeta;
        }
        if (propertyMeta.getMappedBy() != null) {
            CaseInsensitiveMap m = (CaseInsensitiveMap)this.mappedByPropertyMetaMap.get((Object)propertyMeta.getMappedBy());
            if (m == null) {
                m = new CaseInsensitiveMap();
                this.mappedByPropertyMetaMap.put((Object)propertyMeta.getMappedBy(), (Object)m);
            }
            m.put((Object)propertyMeta.getRelationshipClass().getName(), (Object)propertyMeta);
        }
        if (propertyMeta.getColumnMeta() != null && (pm2 = (PropertyMeta)this.columnPropertyMetaMap.put((Object)(columnName = propertyMeta.getColumnMeta().getName()), (Object)propertyMeta)) != null) {
            throw new ColumnDuplicatedRuntimeException(this.name, pm2.getName(), propertyMeta.getName(), columnName);
        }
    }

    public boolean isRelationshipResolved() {
        return this.relationshipResolved;
    }

    public void setRelationshipResolved(boolean relationshipResolved) {
        this.relationshipResolved = relationshipResolved;
    }

    public Object getAdditionalInfo(String name) {
        return this.additionalInfoMap.get((Object)name);
    }

    public int getAdditionalInfoSize() {
        return this.additionalInfoMap.size();
    }

    public Object getAdditionalInfo(int index) {
        return this.additionalInfoMap.get(index);
    }

    public void addAdditionalInfo(String name, Object additionalInfo) {
        this.additionalInfoMap.put((Object)name, additionalInfo);
    }
}

