/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.cooldeploy;

import java.util.HashSet;
import java.util.Set;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.S2ContainerUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourcesUtil;

public class CoolComponentAutoRegister
implements ClassTraversal.ClassHandler {
    public static final String INIT_METHOD = "registerAll";
    public static final String container_BINDING = "bindingType=must";
    private S2Container container;
    private ComponentCreator[] creators;
    private NamingConvention namingConvention;
    protected Set registerdClasses = new HashSet();

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public ComponentCreator[] getCreators() {
        return this.creators;
    }

    public void setCreators(ComponentCreator[] creators) {
        this.creators = creators;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll() {
        try {
            String[] rootPackageNames = this.namingConvention.getRootPackageNames();
            if (rootPackageNames != null) {
                for (int i = 0; i < rootPackageNames.length; ++i) {
                    ResourcesUtil.Resources[] resourcesArray = ResourcesUtil.getResourcesTypes(rootPackageNames[i]);
                    for (int j = 0; j < resourcesArray.length; ++j) {
                        ResourcesUtil.Resources resources = resourcesArray[j];
                        try {
                            resources.forEach(this);
                            continue;
                        }
                        finally {
                            resources.close();
                        }
                    }
                }
            }
        }
        finally {
            this.registerdClasses.clear();
        }
    }

    public void processClass(String packageName, String shortClassName) {
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = ClassUtil.concatName(packageName, shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        Class clazz = ClassUtil.forName(className);
        if (this.namingConvention.isSkipClass(clazz)) {
            return;
        }
        if (this.container.getRoot().hasComponentDef(clazz)) {
            return;
        }
        ComponentDef cd = this.createComponentDef(clazz);
        if (cd == null) {
            return;
        }
        if (this.registerdClasses.contains(cd.getComponentClass())) {
            return;
        }
        this.container.getRoot().register(cd);
        this.registerdClasses.add(cd.getComponentClass());
        S2ContainerUtil.putRegisterLog(cd);
    }

    protected ComponentDef createComponentDef(Class componentClass) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentClass);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }
}

