/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.annotation.tiger.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.CheckSingleRowUpdate;
import org.seasar.dao.annotation.tiger.NoPersistentProperty;
import org.seasar.dao.annotation.tiger.PersistentProperty;
import org.seasar.dao.annotation.tiger.Procedure;
import org.seasar.dao.annotation.tiger.ProcedureCall;
import org.seasar.dao.annotation.tiger.Query;
import org.seasar.dao.annotation.tiger.S2Dao;
import org.seasar.dao.annotation.tiger.Sql;
import org.seasar.dao.annotation.tiger.SqlFile;
import org.seasar.dao.annotation.tiger.Sqls;
import org.seasar.dao.annotation.tiger.util.AnnotationUtil;
import org.seasar.dao.impl.FieldDaoAnnotationReader;
import org.seasar.dao.util.ImplementInterfaceWalker;
import org.seasar.framework.beans.BeanDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoAnnotationReaderImpl
extends FieldDaoAnnotationReader {
    private Class<?> daoClass_;

    public DaoAnnotationReaderImpl(BeanDesc daoBeanDesc) {
        super(daoBeanDesc);
        this.daoClass_ = daoBeanDesc.getBeanClass();
    }

    public String getQuery(Method method) {
        Query query = method.getAnnotation(Query.class);
        return query != null ? query.value() : super.getQuery(method);
    }

    public String getStoredProcedureName(Method method) {
        Procedure procedure = method.getAnnotation(Procedure.class);
        return procedure != null ? procedure.value() : super.getStoredProcedureName(method);
    }

    public String getProcedureCallName(Method method) {
        ProcedureCall procedureCall = method.getAnnotation(ProcedureCall.class);
        return procedureCall != null ? procedureCall.value() : super.getProcedureCallName(method);
    }

    public String[] getArgNames(Method method) {
        Arguments arg = method.getAnnotation(Arguments.class);
        return arg != null ? arg.value() : super.getArgNames(method);
    }

    public Class<?> getBeanClass() {
        Class ret = this.getBeanClass0(this.daoClass_);
        return ret != null ? ret : super.getBeanClass();
    }

    public Class<?> getBeanClass(Method method) {
        Type ret;
        Type type = method.getGenericReturnType();
        if (DaoAnnotationReaderImpl.isTypeOf(type, List.class) && (ret = DaoAnnotationReaderImpl.getElementTypeOfList(type)) != null) {
            return DaoAnnotationReaderImpl.getRawClass(ret);
        }
        return super.getBeanClass(method);
    }

    protected static Type getElementTypeOfList(Type type) {
        if (!DaoAnnotationReaderImpl.isTypeOf(type, List.class)) {
            return null;
        }
        return DaoAnnotationReaderImpl.getGenericParameter(type, 0);
    }

    protected static boolean isTypeOf(Type type, Class<?> clazz) {
        if (Class.class.isInstance(type)) {
            return clazz.isAssignableFrom((Class)Class.class.cast(type));
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return DaoAnnotationReaderImpl.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    protected static Type[] getGenericParameter(Type type) {
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
    }

    protected static Type getGenericParameter(Type type, int index) {
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        Type[] genericParameter = DaoAnnotationReaderImpl.getGenericParameter(type);
        if (genericParameter == null) {
            return null;
        }
        return genericParameter[index];
    }

    protected static Class<?> getRawClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return DaoAnnotationReaderImpl.getRawClass(parameterizedType.getRawType());
        }
        return null;
    }

    private static Class getBeanClassFromDao(Class daoClass) {
        if (daoClass.isAnnotationPresent(S2Dao.class)) {
            S2Dao s2dao = daoClass.getAnnotation(S2Dao.class);
            return s2dao.bean();
        }
        return null;
    }

    private Class<?> getBeanClass0(Class<?> daoClass) {
        Class beanClass = DaoAnnotationReaderImpl.getBeanClassFromDao(daoClass);
        if (beanClass != null) {
            return beanClass;
        }
        HandlerImpl handlerImpl = new HandlerImpl();
        ImplementInterfaceWalker.walk(daoClass, (ImplementInterfaceWalker.Handler)handlerImpl);
        return handlerImpl.foundBeanClass;
    }

    public String[] getNoPersistentProps(Method method) {
        NoPersistentProperty npp = method.getAnnotation(NoPersistentProperty.class);
        return npp != null ? npp.value() : super.getNoPersistentProps(method);
    }

    public String[] getPersistentProps(Method method) {
        PersistentProperty pp = method.getAnnotation(PersistentProperty.class);
        return pp != null ? pp.value() : super.getPersistentProps(method);
    }

    public String getSQL(Method method, String suffix) {
        Sql sql = this.getSqls(method, suffix);
        if (sql == null) {
            sql = method.getAnnotation(Sql.class);
            if (sql == null) {
                return super.getSQL(method, suffix);
            }
            if (("_" + sql.dbms()).equals(suffix) || sql.dbms().equals("")) {
                return sql != null ? sql.value() : null;
            }
            return null;
        }
        return sql != null ? sql.value() : null;
    }

    protected Sql getSqls(Method method, String dbmsSuffix) {
        Sqls sqls = method.getAnnotation(Sqls.class);
        if (sqls == null || sqls.value().length == 0) {
            return null;
        }
        Sql defaultSql = null;
        for (int i = 0; i < sqls.value().length; ++i) {
            Sql sql = sqls.value()[i];
            if (dbmsSuffix.equals("_" + sql.dbms())) {
                return sql;
            }
            if (!"".equals(sql.dbms())) continue;
            defaultSql = sql;
        }
        return defaultSql;
    }

    public boolean isSqlFile(Method method) {
        SqlFile sqlFile = method.getAnnotation(SqlFile.class);
        if (sqlFile != null) {
            return true;
        }
        return super.isSqlFile(method);
    }

    public String getSqlFilePath(Method method) {
        SqlFile sqlFile = method.getAnnotation(SqlFile.class);
        if (sqlFile != null) {
            String path = sqlFile.value();
            if (path == null) {
                path = "";
            }
            return path;
        }
        return super.getSqlFilePath(method);
    }

    public boolean isCheckSingleRowUpdate() {
        CheckSingleRowUpdate checkSingleRowUpdate = AnnotationUtil.getAnnotation(this.daoClass_, CheckSingleRowUpdate.class);
        if (checkSingleRowUpdate != null) {
            return checkSingleRowUpdate.value();
        }
        return super.isCheckSingleRowUpdate();
    }

    public boolean isCheckSingleRowUpdate(Method method) {
        CheckSingleRowUpdate checkSingleRowUpdate = method.getAnnotation(CheckSingleRowUpdate.class);
        if (checkSingleRowUpdate != null) {
            return checkSingleRowUpdate.value();
        }
        return super.isCheckSingleRowUpdate(method);
    }

    private static class HandlerImpl
    implements ImplementInterfaceWalker.Handler {
        Class<?> foundBeanClass;

        private HandlerImpl() {
        }

        public ImplementInterfaceWalker.Status accept(Class ifs) {
            Class beanClass = DaoAnnotationReaderImpl.getBeanClassFromDao(ifs);
            if (beanClass != null) {
                this.foundBeanClass = beanClass;
                return ImplementInterfaceWalker.BREAK;
            }
            return ImplementInterfaceWalker.CONTINUE;
        }
    }
}

