/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.NoUpdatePropertyTypeRuntimeException;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.dao.impl.UpdateAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;

public class UpdateAutoDynamicCommand
extends AbstractSqlCommand {
    private BeanMetaData beanMetaData;
    private String[] propertyNames;
    private boolean checkSingleRowUpdate = true;

    public UpdateAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    public Object execute(Object[] args) {
        Object bean = args[0];
        BeanMetaData bmd = this.getBeanMetaData();
        PropertyType[] propertyTypes = this.createUpdatePropertyTypes(bmd, bean, this.getPropertyNames());
        UpdateAutoHandler handler = new UpdateAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        this.injectDaoClass(handler);
        handler.setSql(this.createUpdateSql(bmd, propertyTypes));
        int i = handler.execute(args);
        if (this.isCheckSingleRowUpdate() && i < 1) {
            throw this.createNotSingleRowUpdatedRuntimeException(args[0], i);
        }
        return new Integer(i);
    }

    protected NotSingleRowUpdatedRuntimeException createNotSingleRowUpdatedRuntimeException(Object bean, int rows) {
        return new NotSingleRowUpdatedRuntimeException(bean, rows);
    }

    protected PropertyType[] createUpdatePropertyTypes(BeanMetaData bmd, Object bean, String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            PropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() || !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName) && pt.getPropertyDesc().getValue(bean) == null) continue;
            types.add(pt);
        }
        if (types.isEmpty()) {
            throw new NoUpdatePropertyTypeRuntimeException();
        }
        PropertyType[] propertyTypes = types.toArray(new PropertyType[types.size()]);
        return propertyTypes;
    }

    protected String createUpdateSql(BeanMetaData bmd, PropertyType[] propertyTypes) {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append("UPDATE ");
        buf.append(bmd.getTableName());
        buf.append(" SET ");
        for (i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            String columnName = pt.getColumnName();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(columnName);
            buf.append(" = ?");
        }
        buf.append(" WHERE ");
        for (i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            buf.append(bmd.getPrimaryKey(i));
            buf.append(" = ? AND ");
        }
        buf.setLength(buf.length() - 5);
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
        return buf.toString();
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(BeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public boolean isCheckSingleRowUpdate() {
        return this.checkSingleRowUpdate;
    }

    public void setCheckSingleRowUpdate(boolean resultCheck) {
        this.checkSingleRowUpdate = resultCheck;
    }
}

