/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.AbstractBeanMetaDataResultSetHandler;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.log.Logger;

public class BeanMetaDataResultSetHandler
extends AbstractBeanMetaDataResultSetHandler {
    private static final Logger logger = Logger.getLogger((Class)BeanMetaDataResultSetHandler.class);

    public BeanMetaDataResultSetHandler(BeanMetaData beanMetaData, RowCreator rowCreator, RelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    public Object handle(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            Set columnNames = this.createColumnNames(resultSet.getMetaData());
            Map propertyCache = this.createPropertyCache(columnNames);
            Map relationPropertyCache = this.createRelationPropertyCache(columnNames);
            Object row = this.createRow(resultSet, propertyCache);
            for (int i = 0; i < this.getBeanMetaData().getRelationPropertyTypeSize(); ++i) {
                Object relationRow;
                RelationPropertyType rpt = this.getBeanMetaData().getRelationPropertyType(i);
                if (rpt == null || (relationRow = this.createRelationRow(resultSet, rpt, columnNames, null, relationPropertyCache)) == null) continue;
                PropertyDesc pd = rpt.getPropertyDesc();
                pd.setValue(row, relationRow);
                this.postCreateRow(relationRow);
            }
            this.postCreateRow(row);
            if (resultSet.next()) {
                logger.log("WDAO0003", null);
            }
            return row;
        }
        return null;
    }
}

