/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.handler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.dao.handler.ProcedureHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.ResultSetUtil;

public abstract class AbstractBasicProcedureHandler
implements ProcedureHandler {
    protected boolean initialised = false;
    protected DataSource dataSource;
    protected String procedureName;
    protected String sql;
    protected Integer[] columnInOutTypes;
    protected Integer[] columnTypes;
    protected String[] columnNames;
    protected StatementFactory statementFactory = BasicStatementFactory.INSTANCE;
    protected Dbms dbms;
    protected int inParameterSize;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected Connection getConnection() {
        if (this.dataSource == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return DataSourceUtil.getConnection((DataSource)this.dataSource);
    }

    protected CallableStatement prepareCallableStatement(Connection connection) {
        if (this.sql == null) {
            throw new EmptyRuntimeException("sql");
        }
        return this.statementFactory.createCallableStatement(connection, this.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object[] args) throws SQLRuntimeException {
        Connection connection = this.getConnection();
        try {
            Object object = this.execute(connection, args);
            return object;
        }
        finally {
            ConnectionUtil.close((Connection)connection);
        }
    }

    protected int initTypes() {
        StringBuffer buff = new StringBuffer();
        buff.append("{ call ");
        buff.append(this.getProcedureName());
        buff.append("(");
        ArrayList<Object> columnNames = new ArrayList<Object>();
        ArrayList<Integer> dataType = new ArrayList<Integer>();
        ArrayList<Integer> inOutTypes = new ArrayList<Integer>();
        ResultSet rs = null;
        int outparameterNum = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData dmd = ConnectionUtil.getMetaData((Connection)connection);
            ProcedureMetaData pmd = this.getProcedureMetaData(this.getDataSource(), this.getProcedureName());
            rs = dmd.getProcedureColumns(pmd.getProcedureCat(), pmd.getProcedureSchem(), pmd.getProcedureName(), null);
            boolean commaRequired = false;
            while (rs.next()) {
                columnNames.add(rs.getObject(4));
                int columnType = rs.getInt(5);
                if (this.isInputColum(columnType)) {
                    ++this.inParameterSize;
                }
                inOutTypes.add(new Integer(columnType));
                dataType.add(new Integer(rs.getInt(6)));
                if (columnType == 1) {
                    if (commaRequired) {
                        buff.append(",");
                    }
                    buff.append("?");
                    commaRequired = true;
                    continue;
                }
                if (columnType == 3) continue;
                if (columnType == 5) {
                    buff.setLength(0);
                    buff.append("{? = call ");
                    buff.append(this.getProcedureName());
                    buff.append("(");
                    continue;
                }
                if (columnType == 4 || columnType == 2) {
                    if (commaRequired) {
                        buff.append(",");
                    }
                    buff.append("?");
                    commaRequired = true;
                    ++outparameterNum;
                    continue;
                }
                throw new SRuntimeException("EDAO0010", new Object[]{this.getProcedureName()});
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLRuntimeException(e);
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                ConnectionUtil.close((Connection)connection);
                throw throwable;
            }
        }
        ResultSetUtil.close((ResultSet)rs);
        ConnectionUtil.close((Connection)connection);
        buff.append(")}");
        this.sql = buff.toString();
        this.columnNames = columnNames.toArray(new String[columnNames.size()]);
        this.columnTypes = dataType.toArray(new Integer[dataType.size()]);
        this.columnInOutTypes = inOutTypes.toArray(new Integer[inOutTypes.size()]);
        return outparameterNum;
    }

    public abstract void initialize();

    protected abstract Object execute(Connection var1, Object[] var2);

    protected void bindArgs(CallableStatement ps, Object[] args) throws SQLException {
        if (args == null) {
            return;
        }
        int argPos = 0;
        for (int i = 0; i < this.columnTypes.length; ++i) {
            if (this.isOutputColum(this.columnInOutTypes[i])) {
                ps.registerOutParameter(i + 1, (int)this.columnTypes[i]);
            }
            if (!this.isInputColum(this.columnInOutTypes[i])) continue;
            ps.setObject(i + 1, args[argPos++], (int)this.columnTypes[i]);
        }
    }

    protected boolean isInputColum(int columnInOutType) {
        return columnInOutType == 1 || columnInOutType == 2;
    }

    protected boolean isOutputColum(int columnInOutType) {
        return columnInOutType == 5 || columnInOutType == 4 || columnInOutType == 2;
    }

    protected String getCompleteSql(Object[] args) {
        if (args == null || args.length == 0) {
            return this.sql;
        }
        StringBuffer buf = new StringBuffer(200);
        int pos = 0;
        int pos2 = 0;
        int index = 0;
        while ((pos = this.sql.indexOf(63, pos2)) > 0) {
            buf.append(this.sql.substring(pos2, pos));
            buf.append(this.getBindVariableText(args[index++]));
            pos2 = pos + 1;
        }
        buf.append(this.sql.substring(pos2));
        return buf.toString();
    }

    protected String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return "'" + bindVariable + "'";
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return "null";
        }
        return "'" + bindVariable.toString() + "'";
    }

    protected ValueType getValueType(Class clazz) {
        return ValueTypes.getValueType((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    ProcedureMetaData getProcedureMetaData(DataSource dataSource, String procedureName) {
        Connection con = DataSourceUtil.getConnection((DataSource)dataSource);
        ResultSet rs = null;
        DatabaseMetaData dmd = ConnectionUtil.getMetaData((Connection)con);
        rs = this.getDbms().getProcedures(dmd, DatabaseMetaDataUtil.convertIdentifier((DatabaseMetaData)dmd, (String)procedureName));
        if (rs == null || !rs.next()) {
            rs.close();
            rs = this.getDbms().getProcedures(dmd, procedureName);
            if (rs == null || !rs.next()) {
                throw new SRuntimeException("EDAO0012", new Object[]{procedureName});
            }
        }
        ProcedureMetaData procedureMetaData = new ProcedureMetaData();
        procedureMetaData.setProcedureCat(rs.getString(1));
        procedureMetaData.setProcedureSchem(rs.getString(2));
        procedureMetaData.setProcedureName(rs.getString(3));
        procedureMetaData.setProcedureType(rs.getShort(8));
        if (rs.next()) {
            throw new SRuntimeException("EDAO0013", new Object[]{procedureName});
        }
        ProcedureMetaData procedureMetaData2 = procedureMetaData;
        Object var9_9 = null;
        try {
            ResultSetUtil.close((ResultSet)rs);
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
        return procedureMetaData2;
        catch (SQLException e) {
            try {
                throw new SQLRuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    ResultSetUtil.close(rs);
                }
                finally {
                    ConnectionUtil.close((Connection)con);
                }
                throw throwable;
            }
        }
    }

    public Dbms getDbms() {
        return this.dbms;
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    static class ProcedureMetaData {
        private String procedureCat;
        private String procedureSchem;
        private String procedureName;
        private short procedureType;

        ProcedureMetaData() {
        }

        public String getProcedureCat() {
            return this.procedureCat;
        }

        public void setProcedureCat(String procedureCat) {
            this.procedureCat = procedureCat;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public void setProcedureName(String procedureName) {
            this.procedureName = procedureName;
        }

        public String getProcedureSchem() {
            return this.procedureSchem;
        }

        public void setProcedureSchem(String procedureSchem) {
            this.procedureSchem = procedureSchem;
        }

        public short getProcedureType() {
            return this.procedureType;
        }

        public void setProcedureType(short procedureType) {
            this.procedureType = procedureType;
        }
    }
}

