/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.extension.dxo.util.Expression;
import org.seasar.framework.util.OgnlUtil;

public class OgnlExpression
implements Expression {
    protected static final String MAP_PREFIX = "#@java.util.LinkedHashMap@{";
    protected static final String MAP_SUFFIX = "}";
    protected Object parsedExpression;

    public OgnlExpression(String source) {
        this.parsedExpression = OgnlUtil.parseExpression((String)(MAP_PREFIX + source + MAP_SUFFIX));
    }

    public Map evaluate(Object source) {
        Map map = (Map)OgnlUtil.getValue((Object)this.parsedExpression, (Object)source);
        LinkedHashMap result = new LinkedHashMap(map.size());
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof Character) {
                result.put(new String(new char[]{((Character)key).charValue()}), value);
                continue;
            }
            result.put((String)key, value);
        }
        return result;
    }
}

