/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.builder.impl;

import [Ljava.util.Map;;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.seasar.extension.dxo.builder.impl.AbstractDxoCommandBuilder;
import org.seasar.extension.dxo.command.DxoCommand;
import org.seasar.extension.dxo.command.impl.BeanToMapDxoCommand;
import org.seasar.extension.dxo.util.DxoUtil;

public class BeanToMapDxoCommandBuilder
extends AbstractDxoCommandBuilder {
    protected Class[] ACCEPTABLE_DEST_CLASSES = new Class[]{Map.class, Map;.class, List.class};

    public DxoCommand createDxoCommand(Class dxoClass, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            return null;
        }
        Class<?> sourceType = parameterTypes[0];
        Class<?> destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        String expression = this.getAnnotationReader().getConversionRule(dxoClass, method);
        if (destType.isArray()) {
            Class<?> elementType;
            if (!Map.class.isAssignableFrom(elementType = destType.getComponentType())) {
                return null;
            }
            if (!sourceType.isArray() && !List.class.isAssignableFrom(sourceType)) {
                return null;
            }
        } else if (List.class.isAssignableFrom(destType)) {
            Class elementType = DxoUtil.getElementTypeOfList(method);
            if (elementType == null || !Map.class.isAssignableFrom(elementType)) {
                return null;
            }
            if (!sourceType.isArray() && !List.class.isAssignableFrom(sourceType)) {
                return null;
            }
        } else if (Map.class.isAssignableFrom(destType)) {
            if (sourceType.isArray() || List.class.isAssignableFrom(sourceType)) {
                return null;
            }
        } else {
            return null;
        }
        return new BeanToMapDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), expression);
    }
}

