/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.impl.DBXAResourceImpl;

public class XAConnectionImpl
implements XAConnection {
    private Connection connection;
    private XAResource xaResource;
    private List listeners = new ArrayList();

    public XAConnectionImpl(Connection connection) {
        this.connection = connection;
        this.xaResource = new DBXAResourceImpl(connection);
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
        this.connection = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }
}

