/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.model.MissingFeature;
import org.eclipse.update.operations.OperationsManager;

public class FeatureStatusPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    public FeatureStatusPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        try {
            String reason;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 20;
            composite.setLayout((Layout)layout);
            Text message = new Text(composite, 66);
            message.setEditable(false);
            GridData gd = new GridData();
            gd.widthHint = 350;
            message.setLayoutData((Object)gd);
            ConfiguredFeatureAdapter adapter = (ConfiguredFeatureAdapter)this.getElement();
            IFeature feature = adapter.getFeature(null);
            if (OperationsManager.findPendingOperation((IFeature)feature) != null) {
                message.setText(UpdateUIMessages.FeatureStatusPropertyPage_pendingChanges);
                return composite;
            }
            IStatus status = this.getStatus(feature);
            int severity = status.getSeverity();
            if (severity == 4 && this.getStatusCode(feature, status) == 0) {
                severity = 0;
                message.setText(UpdateUIMessages.FeatureStatusPropertyPage_goodConfiguration);
            } else {
                message.setText(status.getMessage());
            }
            if (severity != 0 && status.isMultiStatus() && (reason = this.getReason(status)).length() > 0) {
                Composite comp = new Composite(composite, 0);
                comp.setLayout((Layout)new GridLayout());
                gd = new GridData(1808);
                comp.setLayoutData((Object)gd);
                Label label = new Label(comp, 0);
                label.setText(UpdateUIMessages.FeatureStatusPropertyPage_reason);
                Text text = new Text(comp, 2626);
                text.setEditable(false);
                text.setText(reason);
                gd.widthHint = 350;
                text.setLayoutData((Object)gd);
            }
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getReason(IStatus status) {
        IStatus[] children = status.getChildren();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < children.length) {
            String message = children[i].getMessage();
            if (message != null && message.length() > 0) {
                buffer.append(String.valueOf(message) + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            ++i;
        }
        return buffer.toString();
    }

    private IStatus getStatus(IFeature feature) throws CoreException {
        if (feature instanceof MissingFeature) {
            int severity;
            String message = "";
            if (((MissingFeature)feature).isOptional()) {
                severity = 0;
                message = UpdateUIMessages.FeatureStatusPropertyPage_missingOptional;
            } else {
                severity = 4;
                message = UpdateUIMessages.FeatureStatusPropertyPage_missing;
            }
            return new Status(severity, "org.eclipse.update.ui", 0, message, null);
        }
        return SiteManager.getLocalSite().getFeatureStatus(feature);
    }

    private int getStatusCode(IFeature feature, IStatus status) {
        int code = status.getCode();
        if (code == 2 && status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (child.isMultiStatus() || child.getCode() != -1) {
                    return code;
                }
                ++i;
            }
            if (UpdateUtils.hasObsoletePatches((IFeature)feature)) {
                return 0;
            }
        }
        return code;
    }
}

