/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.mdocument;

import com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class DomImpl_internal {
    private static DocumentBuilderFactory dbf;
    private static DocumentBuilder db;

    static {
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
        }
        catch (Exception exception) {
            dbf = null;
            db = null;
        }
    }

    public static long createID() {
        long id = System.currentTimeMillis();
        while (id == System.currentTimeMillis()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        return id;
    }

    protected static String makeElementName(String name, String pref) {
        return String.valueOf(pref != null && pref.length() > 0 ? String.valueOf(pref) + ":" : "") + name;
    }

    public static Document createDocument(String topname) {
        if (topname == null || topname.length() == 0 || db == null) {
            return null;
        }
        try {
            Document doc = db.newDocument();
            doc.appendChild(doc.createElement(topname));
            String id = String.valueOf(DomImpl_internal.createID());
            doc.getDocumentElement().setAttribute("id", id);
            doc.getDocumentElement().setAttribute("create", id);
            doc.getDocumentElement().setAttribute("lastmod", id);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document createDocument(InputStream is) {
        try {
            Document doc = db.parse(is);
            String id = String.valueOf(DomImpl_internal.createID());
            doc.getDocumentElement().setAttribute("id", id);
            doc.getDocumentElement().setAttribute("create", id);
            doc.getDocumentElement().setAttribute("lastmod", id);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Document cloneDocument(Document doc) {
        try {
            Document newdoc = db.newDocument();
            Node newnode = newdoc.importNode(doc.getDocumentElement(), true);
            newdoc.appendChild(newnode);
            String id = String.valueOf(DomImpl_internal.createID());
            doc.getDocumentElement().setAttribute("id", id);
            doc.getDocumentElement().setAttribute("create", id);
            doc.getDocumentElement().setAttribute("lastmod", id);
            return newdoc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Document copy(Document doc) {
        try {
            Document newdoc = db.newDocument();
            Node newnode = newdoc.importNode(doc.getDocumentElement(), true);
            newdoc.appendChild(newnode);
            return newdoc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static long getID(Document doc) {
        String id = doc.getDocumentElement().getAttribute("id");
        return Long.parseLong(id);
    }

    protected static void setID(Document doc, long nid) {
        doc.getDocumentElement().setAttribute("id", String.valueOf(nid));
    }

    protected static String getVersion(Document doc) {
        return doc.getDocumentElement().getAttribute("version");
    }

    protected static void setVersion(Document doc, String version) {
        doc.getDocumentElement().setAttribute("version", version);
    }

    protected static long getCreatedTime(Document doc) {
        return DomImpl_internal.getID(doc);
    }

    protected static void setLastModifiedTime(Document doc, long modtime) {
        doc.getDocumentElement().setAttribute("lastmod", String.valueOf(modtime));
    }

    protected static long getLastModifiedTime(Document doc) {
        String modtime = doc.getDocumentElement().getAttribute("lastmod");
        if (modtime == "") {
            return DomImpl_internal.getID(doc);
        }
        return Long.parseLong(modtime);
    }

    protected static ArrayList<Element> getElements(Document doc, String name, String pref) {
        return DomImpl_internal.getElements(doc.getDocumentElement(), name, pref);
    }

    protected static ArrayList<Element> getElements(Element parent, String name, String pref) {
        String elemname = DomImpl_internal.makeElementName(name, pref);
        NodeList nl = parent.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().compareToIgnoreCase(elemname) == 0) {
                list.add((Element)n);
            }
            ++i;
        }
        return list;
    }

    protected static ArrayList<Element> getElements(Element parent, String name) {
        return DomImpl_internal.getElements(parent, name, null);
    }

    protected static ArrayList<Element> getElements(Document doc, String name) {
        return DomImpl_internal.getElements(doc.getDocumentElement(), name, null);
    }

    protected static ArrayList<Element> getAllElements(Document doc, String name) {
        Element top = doc.getDocumentElement();
        NodeList nl = top.getElementsByTagName(name);
        ArrayList<Element> elems = new ArrayList<Element>();
        int i = 0;
        while (i < nl.getLength()) {
            elems.add((Element)nl.item(i));
            ++i;
        }
        return elems;
    }

    protected static Element getRootElement(Document doc) {
        return doc.getDocumentElement();
    }

    public static String getElementText(Element elem) {
        String str = "";
        if (elem == null) {
            return str;
        }
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 3) {
                str = String.valueOf(str) + n.getNodeValue();
            }
            ++i;
        }
        return str;
    }

    public static void setElementText(Element elem, String text) {
        elem.normalize();
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 3) {
                elem.removeChild(n);
            }
            ++i;
        }
        Document doc = elem.getOwnerDocument();
        elem.appendChild(doc.createTextNode(text));
    }

    protected static void setAttribute(Element elem, String attr, String val) {
        elem.setAttribute(attr, val);
    }

    protected static String getAttribute(Element elem, String attr) {
        return elem.getAttribute(attr);
    }

    protected static Element createElement(Document doc, String name, String pref) {
        String elemname = DomImpl_internal.makeElementName(name, pref);
        return doc.createElement(elemname);
    }

    protected static Element createElement(Element elem, String name, String pref) {
        return DomImpl_internal.createElement(elem.getOwnerDocument(), name, pref);
    }

    public static Element appendElement(Document doc, String name, String pref) {
        return DomImpl_internal.appendElement(doc.getDocumentElement(), name, pref);
    }

    protected static Element appendElement(Element elem, String name) {
        return DomImpl_internal.appendElement(elem, name, null);
    }

    public static Element appendElement(Element elem, String name, String pref) {
        String elemname = DomImpl_internal.makeElementName(name, pref);
        Element e = elem.getOwnerDocument().createElement(elemname);
        elem.appendChild(e);
        return e;
    }

    protected static void removeElement(Document doc, Element elem) {
        try {
            doc.getDocumentElement().removeChild(elem);
        }
        catch (Exception exception) {
            return;
        }
    }

    protected static void removeElements(Document doc, String name, String pref) {
        DomImpl_internal.removeElements(doc.getDocumentElement(), name, pref);
    }

    protected static void removeElements(Element elem, String name, String pref) {
        ArrayList<Element> elems = DomImpl_internal.getElements(elem, name, pref);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            e.getParentNode().removeChild(e);
            ++i;
        }
    }

    public static void removeAllChildren(Element parent) {
        NodeList nl = parent.getChildNodes();
        int len = nl.getLength();
        int i = 0;
        while (i < len) {
            Node n = nl.item(0);
            if (n.getNodeType() != 2) {
                parent.removeChild(n);
            }
            ++i;
        }
    }

    private static boolean equals(Node node1, Node node2) {
        int sz2;
        node1.normalize();
        node2.normalize();
        if (node1.getNodeType() != node2.getNodeType() || node1.getNodeName().compareTo(node2.getNodeName()) != 0) {
            return false;
        }
        if (node1.getNodeType() == 3) {
            return node1.getNodeValue().compareTo(node2.getNodeValue()) == 0;
        }
        NodeList nl1 = node1.getChildNodes();
        NodeList nl2 = node2.getChildNodes();
        int sz1 = nl1.getLength();
        if (sz1 != (sz2 = nl2.getLength())) {
            return false;
        }
        int i = 0;
        while (i < sz1) {
            if (!DomImpl_internal.equals(nl1.item(i), nl2.item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean equals(Document doc1, Document doc2) {
        return DomImpl_internal.equals(doc1.getDocumentElement(), doc2.getDocumentElement());
    }

    protected static boolean equalsByID(Document doc1, Document doc2) {
        return DomImpl_internal.getID(doc1) == DomImpl_internal.getID(doc2);
    }

    private static int getTextLength(Element elem) {
        elem.normalize();
        int len = DomImpl_internal.getElementText(elem).length();
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1) {
                len += DomImpl_internal.getTextLength((Element)nl.item(i));
            }
            ++i;
        }
        return len;
    }

    protected static int getTextLength(Document doc) {
        return DomImpl_internal.getTextLength(doc.getDocumentElement());
    }

    protected static String getAllText(Element elem) {
        String str = "";
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            short type = nl.item(i).getNodeType();
            if (type == 1) {
                if (str.length() > 0) {
                    str = String.valueOf(str) + " ";
                }
                str = String.valueOf(str) + DomImpl_internal.getAllText((Element)nl.item(i));
            } else if (type == 3) {
                str = String.valueOf(str) + ((Text)nl.item(i)).getNodeValue();
            }
            ++i;
        }
        return str;
    }

    protected static String getAllText(Document doc) {
        return DomImpl_internal.getAllText(doc.getDocumentElement());
    }

    protected static void copyDocumentContents(Document srcdoc, Document dstdoc) {
        if (srcdoc.equals(dstdoc)) {
            return;
        }
        Node ielem = dstdoc.importNode(srcdoc.getDocumentElement(), true);
        if (dstdoc.getDocumentElement() != null) {
            dstdoc.replaceChild(dstdoc.getDocumentElement(), ielem);
        } else {
            dstdoc.appendChild(ielem);
        }
    }

    protected static Document findDocument(ArrayList<Document> docs, Document doc) {
        int idx = DomImpl_internal.findDocumentIndex(docs, doc);
        if (idx == -1) {
            return null;
        }
        return docs.get(idx);
    }

    protected static int findDocumentIndex(ArrayList<Document> docs, Document doc) {
        long fid = DomImpl_internal.getID(doc);
        int i = 0;
        while (i < docs.size()) {
            long id = DomImpl_internal.getID(docs.get(i));
            if (fid == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static boolean saveDocument(Document doc, String file) {
        DOMImplementationImpl dimpl = new DOMImplementationImpl();
        LSOutput lsout = dimpl.createLSOutput();
        LSSerializer lsser = dimpl.createLSSerializer();
        try {
            FileOutputStream out = new FileOutputStream(file);
            lsout.setEncoding("UTF-8");
            lsout.setByteStream(out);
            lsser.write(doc, lsout);
            out.flush();
            out.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static Document loadDocument(String file) {
        DOMImplementationImpl dimpl = new DOMImplementationImpl();
        try {
            FileInputStream fin = new FileInputStream(file);
            LSInput lsin = dimpl.createLSInput();
            lsin.setByteStream(fin);
            LSParser parser = dimpl.createLSParser((short)1, null);
            return parser.parse(lsin);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

