/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIScrollBarTrackInfo;
import org.eclipse.swt.internal.carbon.HIThemeTrackDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.ScrollBarTrackInfo;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    HIScrollBarTrackInfo getArrowsInfo() {
        int upArrowState = this.state[1];
        int downArrowState = this.state[2];
        int upTrackState = this.state[3];
        int downTrackState = this.state[4];
        int thumbState = this.state[5];
        int state = 0;
        if ((upArrowState & 8) != 0) {
            state |= 1;
        }
        if ((downArrowState & 8) != 0) {
            state |= 0x40;
        }
        if ((upTrackState & 8) != 0) {
            state |= 2;
        }
        if ((downTrackState & 8) != 0) {
            state |= 0x20;
        }
        if ((thumbState & 8) != 0) {
            state |= 8;
        }
        int enableState = 3;
        if ((this.state[0] & 0x10) != 0) {
            enableState = 0;
        }
        if ((this.state[0] & 0x20) != 0) {
            enableState = 1;
        }
        HIScrollBarTrackInfo scrollInfo = new HIScrollBarTrackInfo();
        scrollInfo.pressState = (byte)state;
        scrollInfo.enableState = (byte)enableState;
        scrollInfo.viewsize = this.thumb;
        return scrollInfo;
    }

    HIThemeTrackDrawInfo getInfo() {
        int upArrowState = this.state[1];
        int downArrowState = this.state[2];
        int upTrackState = this.state[3];
        int downTrackState = this.state[4];
        int thumbState = this.state[5];
        HIThemeTrackDrawInfo info = new HIThemeTrackDrawInfo();
        info.min = this.minimum;
        info.max = Math.max(this.minimum, this.maximum - this.thumb);
        info.value = this.selection;
        info.kind = 0;
        info.attributes = (short)4;
        if ((this.style & 0x100) != 0) {
            info.attributes = (short)(info.attributes | 1);
        }
        info.enableState = (byte)3;
        if ((this.state[0] & 0x10) != 0) {
            info.enableState = 0;
        }
        if ((this.state[0] & 0x20) != 0) {
            info.enableState = 1;
        }
        info.scrollbar = new ScrollBarTrackInfo();
        int state = 0;
        if ((upArrowState & 8) != 0) {
            state |= 1;
        }
        if ((downArrowState & 8) != 0) {
            state |= 0x40;
        }
        if ((upTrackState & 8) != 0) {
            state |= 2;
        }
        if ((downTrackState & 8) != 0) {
            state |= 0x20;
        }
        if ((thumbState & 8) != 0) {
            state |= 8;
        }
        info.scrollbar.pressState = (byte)state;
        info.scrollbar.viewsize = this.thumb;
        return info;
    }

    Rectangle getBounds(int part, Rectangle bounds) {
        HIThemeTrackDrawInfo info = this.getInfo();
        info.bounds_x = bounds.x;
        info.bounds_y = bounds.y;
        info.bounds_width = bounds.width;
        info.bounds_height = bounds.height;
        CGRect rect = new CGRect();
        short partCode = 0;
        switch (part) {
            case 1: {
                partCode = 20;
                break;
            }
            case 2: {
                partCode = 21;
                break;
            }
            case 3: {
                partCode = 22;
                break;
            }
            case 5: {
                partCode = 129;
                break;
            }
            case 4: {
                partCode = 23;
            }
        }
        OS.HIThemeGetTrackPartBounds(info, partCode, rect);
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    int getSelection(Point position, Rectangle bounds) {
        HIThemeTrackDrawInfo info = this.getInfo();
        info.bounds_x = bounds.x;
        info.bounds_y = bounds.y;
        info.bounds_width = bounds.width;
        info.bounds_height = bounds.height;
        CGPoint pt = new CGPoint();
        pt.x = position.x;
        pt.y = position.y;
        float[] relativePosition = new float[1];
        OS.HIThemeGetTrackThumbPositionFromOffset(info, pt, relativePosition);
        int[] selection = new int[1];
        OS.HIThemeGetTrackLiveValue(info, relativePosition[0], selection);
        return selection[0];
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeTrackDrawInfo info = this.getInfo();
        info.bounds_x = bounds.x;
        info.bounds_y = bounds.y;
        info.bounds_width = bounds.width;
        info.bounds_height = bounds.height;
        OS.HIThemeDrawTrack(info, null, gc.handle, 0);
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        CGPoint pt = new CGPoint();
        pt.x = position.x;
        pt.y = position.y;
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        short[] part = new short[1];
        HIScrollBarTrackInfo scrollInfo = this.getArrowsInfo();
        OS.HIThemeHitTestScrollBarArrows(rect, scrollInfo, (this.style & 0x100) != 0, pt, null, part);
        switch (part[0]) {
            case 20: {
                return 1;
            }
            case 21: {
                return 2;
            }
        }
        HIThemeTrackDrawInfo info = this.getInfo();
        info.bounds_x = bounds.x;
        info.bounds_y = bounds.y;
        info.bounds_width = bounds.width;
        info.bounds_height = bounds.height;
        if (OS.HIThemeHitTestTrack(info, pt, part)) {
            switch (part[0]) {
                case 22: {
                    return 3;
                }
                case 23: {
                    return 4;
                }
                case 129: {
                    return 5;
                }
            }
        }
        return -1;
    }
}

