/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;

public final class Cursor
extends Resource {
    public int handle;
    static boolean initialized;

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int style) {
        super(device);
        switch (style) {
            case 21: {
                this.handle = 10;
                break;
            }
            case 0: {
                this.handle = 0;
                break;
            }
            case 1: {
                this.handle = 14;
                break;
            }
            case 2: {
                this.handle = 5;
                break;
            }
            case 3: {
                this.handle = 0;
                break;
            }
            case 4: {
                this.handle = 5;
                break;
            }
            case 5: {
                this.handle = 5;
                break;
            }
            case 6: {
                this.handle = 5;
                break;
            }
            case 7: {
                this.handle = 21;
                break;
            }
            case 8: {
                this.handle = 5;
                break;
            }
            case 9: {
                this.handle = 17;
                break;
            }
            case 10: {
                this.handle = 19;
                break;
            }
            case 11: {
                this.handle = 20;
                break;
            }
            case 12: {
                this.handle = 16;
                break;
            }
            case 13: {
                this.handle = 15;
                break;
            }
            case 14: {
                this.handle = 5;
                break;
            }
            case 15: {
                this.handle = 5;
                break;
            }
            case 16: {
                this.handle = 5;
                break;
            }
            case 17: {
                this.handle = 5;
                break;
            }
            case 18: {
                this.handle = 5;
                break;
            }
            case 19: {
                this.handle = 4;
                break;
            }
            case 20: {
                this.handle = 18;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        if (OS.VERSION >= 4160) {
            byte[] data = new byte[source.width * source.height * 4];
            int y = 0;
            while (y < source.height) {
                int offset = y * source.width * 4;
                int x = 0;
                while (x < source.width) {
                    int pixel = source.getPixel(x, y);
                    int maskPixel = mask.getPixel(x, y);
                    if (pixel == 0 && maskPixel == 0) {
                        data[offset] = -1;
                    } else if (pixel == 0 && maskPixel == 1) {
                        data[offset + 3] = -1;
                        data[offset + 2] = -1;
                        data[offset + 1] = -1;
                        data[offset] = -1;
                    } else if (pixel == 1) {
                        // empty if block
                    }
                    offset += 4;
                    ++x;
                }
                ++y;
            }
            this.createNSCursor(hotspotX, hotspotY, data, source.width, source.height);
            return;
        }
        mask = ImageData.convertMask(mask);
        source = ImageData.convertMask(source);
        int width = source.width;
        int height = source.height;
        int minX = 0;
        int minY = 0;
        if (width > 16 || height > 16) {
            minX = width;
            minY = height;
            int maxX = 0;
            int maxY = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if (source.getPixel(x, y) != 1 || mask.getPixel(x, y) != 0) {
                        minX = Math.min(minX, x);
                        minY = Math.min(minY, y);
                        maxX = Math.max(maxX, x);
                        maxY = Math.max(maxY, y);
                    }
                    ++x;
                }
                ++y;
            }
            width = maxX - minX + 1;
            height = maxY - minY + 1;
            if (width > 16 || height > 16) {
                int newWidth = Math.min(width, 16);
                int newHeight = Math.min(height, 16);
                ImageData newSource = new ImageData(newWidth, newHeight, source.depth, source.palette, 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
                ImageData newMask = new ImageData(newWidth, newHeight, mask.depth, mask.palette, 1, null, 0, null, null, -1, -1, mask.type, mask.x, mask.y, mask.disposalMethod, mask.delayTime);
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                ImageData.blit(1, mask.data, mask.depth, mask.bytesPerLine, mask.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newMask.data, newMask.depth, newMask.bytesPerLine, newMask.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                width = newWidth;
                height = newHeight;
                minY = 0;
                minX = 0;
                source = newSource;
                mask = newMask;
            }
        }
        org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
        byte[] srcData = cursor.data;
        byte[] maskData = cursor.mask;
        int y = 0;
        while (y < height) {
            int d = 0;
            int m = 0;
            int x = 0;
            while (x < width) {
                int bit = 1 << width - 1 - x;
                if (source.getPixel(minX + x, minY + y) == 0) {
                    m = (short)(m | bit);
                    if (mask.getPixel(minX + x, minY + y) == 0) {
                        d = (short)(d | bit);
                    }
                } else if (mask.getPixel(minX + x, minY + y) != 0) {
                    d = (short)(d | bit);
                }
                ++x;
            }
            srcData[y * 2] = (byte)(d >> 8);
            srcData[y * 2 + 1] = (byte)(d & 0xFF);
            maskData[y * 2] = (byte)(m >> 8);
            maskData[y * 2 + 1] = (byte)(m & 0xFF);
            ++y;
        }
        cursor.hotSpot_h = (short)Math.max(0, Math.min(15, hotspotX - minX));
        cursor.hotSpot_v = (short)Math.max(0, Math.min(15, hotspotY - minY));
        this.handle = OS.NewPtr(68);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.memmove(this.handle, cursor, 68);
        this.init();
    }

    void createNSCursor(int hotspotX, int hotspotY, byte[] buffer, int width, int height) {
        int nsImageRep;
        int nsImage;
        if (!initialized) {
            initialized = true;
            int window = Cocoa.objc_msgSend(Cocoa.objc_msgSend(Cocoa.C_NSWindow, Cocoa.S_alloc), Cocoa.S_init);
            Cocoa.objc_msgSend(window, Cocoa.S_release);
        }
        if ((nsImage = Cocoa.objc_msgSend(Cocoa.C_NSImage, Cocoa.S_alloc)) == 0) {
            SWT.error(2);
        }
        if ((nsImageRep = Cocoa.objc_msgSend(Cocoa.C_NSBitmapImageRep, Cocoa.S_alloc)) == 0) {
            SWT.error(2);
        }
        this.handle = Cocoa.objc_msgSend(Cocoa.C_NSCursor, Cocoa.S_alloc);
        if (this.handle == 0) {
            SWT.error(2);
        }
        NSSize size = new NSSize();
        size.width = width;
        size.height = height;
        nsImage = Cocoa.objc_msgSend(nsImage, Cocoa.S_initWithSize, size);
        nsImageRep = Cocoa.objc_msgSend(nsImageRep, Cocoa.S_initWithBitmapDataPlanes, null, width, height, 8, 4, 1, 0, Cocoa.NSDeviceRGBColorSpace(), 3, width * 4, 32);
        int bitmapData = Cocoa.objc_msgSend(nsImageRep, Cocoa.S_bitmapData);
        OS.memmove(bitmapData, buffer, buffer.length);
        Cocoa.objc_msgSend(nsImage, Cocoa.S_addRepresentation, nsImageRep);
        NSPoint point = new NSPoint();
        point.x = hotspotX;
        point.y = hotspotY;
        this.handle = Cocoa.objc_msgSend(this.handle, Cocoa.S_initWithImage_hotSpot, nsImage, point);
        Cocoa.objc_msgSend(nsImage, Cocoa.S_release);
        Cocoa.objc_msgSend(nsImageRep, Cocoa.S_release);
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        if (OS.VERSION >= 4160) {
            int i;
            byte[] data = new byte[source.width * source.height * 4];
            PaletteData palette = source.palette;
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, data, 32, source.width * 4, 1, 0, 0, source.width, source.height, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i2 = 0;
                while (i2 < rgbs.length) {
                    RGB rgb = rgbs[i2];
                    if (rgb != null) {
                        srcReds[i2] = (byte)rgb.red;
                        srcGreens[i2] = (byte)rgb.green;
                        srcBlues[i2] = (byte)rgb.blue;
                    }
                    ++i2;
                }
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, data, 32, source.width * 4, 1, 0, 0, source.width, source.height, 0xFF0000, 65280, 255, false, false);
            }
            if (source.maskData != null || source.transparentPixel != -1) {
                ImageData mask = source.getTransparencyMask();
                byte[] maskData = mask.data;
                int maskBpl = mask.bytesPerLine;
                int offset = 0;
                int maskOffset = 0;
                int y = 0;
                while (y < source.height) {
                    int x = 0;
                    while (x < source.width) {
                        data[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                        offset += 4;
                        ++x;
                    }
                    maskOffset += maskBpl;
                    ++y;
                }
            } else if (source.alpha != -1) {
                byte alpha = (byte)source.alpha;
                i = 0;
                while (i < data.length) {
                    data[i] = alpha;
                    i += 4;
                }
            } else if (source.alphaData != null) {
                byte[] alphaData = source.alphaData;
                i = 0;
                while (i < data.length) {
                    data[i] = alphaData[i / 4];
                    i += 4;
                }
            }
            this.createNSCursor(hotspotX, hotspotY, data, source.width, source.height);
        } else {
            ImageData mask = source.getTransparencyMask();
            if (source.depth > 1) {
                byte[] newReds;
                ImageData newSource = new ImageData(source.width, source.height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
                byte[] byArray = new byte[2];
                byArray[1] = -1;
                byte[] newGreens = newReds = byArray;
                byte[] newBlues = newReds;
                PaletteData palette = source.palette;
                if (palette.isDirect) {
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, newReds, newGreens, newBlues, false, false);
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    int length = rgbs.length;
                    byte[] srcReds = new byte[length];
                    byte[] srcGreens = new byte[length];
                    byte[] srcBlues = new byte[length];
                    int i = 0;
                    while (i < rgbs.length) {
                        RGB rgb = rgbs[i];
                        if (rgb != null) {
                            srcReds[i] = (byte)rgb.red;
                            srcGreens[i] = (byte)rgb.green;
                            srcBlues[i] = (byte)rgb.blue;
                        }
                        ++i;
                    }
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, newReds, newGreens, newBlues, false, false);
                }
                source = newSource;
            }
            int width = source.width;
            int height = source.height;
            int minX = 0;
            int minY = 0;
            if (width > 16 || height > 16) {
                minX = width;
                minY = height;
                int maxX = 0;
                int maxY = 0;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        if (source.getPixel(x, y) != 1 || mask.getPixel(x, y) != 0) {
                            minX = Math.min(minX, x);
                            minY = Math.min(minY, y);
                            maxX = Math.max(maxX, x);
                            maxY = Math.max(maxY, y);
                        }
                        ++x;
                    }
                    ++y;
                }
                width = maxX - minX + 1;
                height = maxY - minY + 1;
                if (width > 16 || height > 16) {
                    int newWidth = Math.min(width, 16);
                    int newHeight = Math.min(height, 16);
                    ImageData newSource = new ImageData(newWidth, newHeight, source.depth, source.palette, 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
                    ImageData newMask = new ImageData(newWidth, newHeight, mask.depth, mask.palette, 1, null, 0, null, null, -1, -1, mask.type, mask.x, mask.y, mask.disposalMethod, mask.delayTime);
                    ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                    ImageData.blit(1, mask.data, mask.depth, mask.bytesPerLine, mask.getByteOrder(), minX, minY, width, height, null, null, null, 255, null, 0, minX, minY, newMask.data, newMask.depth, newMask.bytesPerLine, newMask.getByteOrder(), 0, 0, newWidth, newHeight, null, null, null, false, false);
                    width = newWidth;
                    height = newHeight;
                    minY = 0;
                    minX = 0;
                    source = newSource;
                    mask = newMask;
                }
            }
            org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
            byte[] srcData = cursor.data;
            byte[] maskData = cursor.mask;
            int y = 0;
            while (y < height) {
                int d = 0;
                int m = 0;
                int x = 0;
                while (x < width) {
                    int bit = 1 << width - 1 - x;
                    if (source.getPixel(x + minX, y + minY) == 0) {
                        if (mask.getPixel(x + minX, y + minY) != 0) {
                            d = (short)(d | bit);
                            m = (short)(m | bit);
                        }
                    } else if (mask.getPixel(x + minX, y + minY) != 0) {
                        m = (short)(m | bit);
                    }
                    ++x;
                }
                srcData[y * 2] = (byte)(d >> 8);
                srcData[y * 2 + 1] = (byte)(d & 0xFF);
                maskData[y * 2] = (byte)(m >> 8);
                maskData[y * 2 + 1] = (byte)(m & 0xFF);
                ++y;
            }
            cursor.hotSpot_h = (short)Math.max(0, Math.min(15, hotspotX - minX));
            cursor.hotSpot_v = (short)Math.max(0, Math.min(15, hotspotY - minY));
            this.handle = OS.NewPtr(68);
            if (this.handle == 0) {
                SWT.error(2);
            }
            OS.memmove(this.handle, cursor, 68);
        }
        this.init();
    }

    void destroy() {
        switch (this.handle) {
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            default: {
                if (OS.VERSION >= 4160) {
                    Cocoa.objc_msgSend(this.handle, Cocoa.S_release);
                    break;
                }
                OS.DisposePtr(this.handle);
            }
        }
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor carbon_new(Device device, int handle) {
        Cursor cursor = new Cursor(device);
        cursor.handle = handle;
        return cursor;
    }
}

