/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.smart;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CacheDB;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SearchHistory;
import jp.sourceforge.concierge.plugin.ipapers.view.SearchHistoryListener;
import org.eclipse.core.runtime.ListenerList;

public class SearchHistoryList {
    private final List<SearchHistory> historyList = new ArrayList<SearchHistory>();
    private final ListenerList listenerList = new ListenerList();
    private Connection con = null;
    private static final SearchHistoryList singleton = new SearchHistoryList();

    public static SearchHistoryList getInstance() {
        return singleton;
    }

    public List getSearchHistoryList() {
        return this.historyList;
    }

    public SearchHistoryList() {
        String dbdir = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + "ipapers";
        File db = new File(dbdir);
        if (!db.exists()) {
            db.mkdir();
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.con = DriverManager.getConnection("jdbc:hsqldb:file:" + dbdir + System.getProperty("file.separator") + "SearchHistory.db", "sa", "");
            PreparedStatement ps = this.con.prepareStatement("create table history (query varchar(256), searchTime timestamp, type varchar(32));");
            ps.execute();
            ps.close();
            this.con.commit();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IPapersPlugin.log.error((Object)"ERROR: failed to load HSQLDB JDBC driver.");
        }
        catch (SQLException e) {
            e.getSQLState().equals("S0001");
        }
    }

    public void setHistory(String name) {
        this.clear();
        try {
            PreparedStatement selectps = this.con.prepareStatement("SELECT query,searchTime,type FROM history where query=?");
            selectps.setString(1, name);
            ResultSet rs = selectps.executeQuery();
            while (rs.next()) {
                Object[] listeners;
                SearchHistory history = new SearchHistory(rs.getString("query"), rs.getTimestamp("searchTime"), rs.getString("type"));
                this.historyList.add(history);
                Object[] objectArray = listeners = this.listenerList.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((SearchHistoryListener)listener).historyAdded(history);
                    ++n2;
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)("ERROR: failed to select, " + e.getMessage() + "," + e.getSQLState()));
        }
    }

    public void addHistory(SearchHistory history) {
        Object[] listeners;
        this.historyList.add(history);
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SearchHistoryListener)listener).historyAdded(history);
            ++n2;
        }
        if (IPapersPlugin.log.isDebugEnabled()) {
            IPapersPlugin.log.debug((Object)(String.valueOf(history.getQuery()) + ":" + history.getSearchTime()));
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("insert into history (query, searchTime, type) values (?, ?, ?);");
            ps.setString(1, history.getQuery());
            ps.setTimestamp(2, history.getSearchTime());
            ps.setString(3, history.getType());
            ps.execute();
            ps.close();
            this.con.commit();
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)("ERROR: failed to insert history data" + e.getMessage() + e.getSQLState()));
        }
    }

    public void addHistoryListener(SearchHistoryListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeHistoryListener(SearchHistoryListener listener) {
        this.listenerList.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistory(SearchHistory history) {
        if (IPapersPlugin.log.isDebugEnabled()) {
            IPapersPlugin.log.debug((Object)(String.valueOf(history.getQuery()) + ":" + history.getSearchTime()));
        }
        try {
            ArrayList<Paper> papers = CacheDB.getInstance().getPapers(history.getSearchTime());
            for (Paper paper : papers) {
                CacheDB.getInstance().removeInfo(paper.getId(), paper.getIdType());
            }
            PreparedStatement ps = this.con.prepareStatement("delete from history where query=? and searchTime=?;");
            ps.setString(1, history.getQuery());
            ps.setTimestamp(2, history.getSearchTime());
            ps.execute();
            ps.close();
            this.con.commit();
        }
        catch (SQLException e) {
            IPapersPlugin.log.error((Object)("ERROR: failed to remove data" + e.getMessage() + e.getSQLState()));
        }
        ListenerList listenerList = this.listenerList;
        synchronized (listenerList) {
            Object[] listeners;
            Object[] objectArray = listeners = this.listenerList.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((SearchHistoryListener)listener).historyRemove(history);
                ++n2;
            }
            this.listenerList.notifyAll();
            this.historyList.remove(history);
        }
    }

    public void clear() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SearchHistoryListener)listener).historyCleared();
            ++n2;
        }
        this.historyList.clear();
    }
}

