/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.pubmed;

import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperList;
import jp.sourceforge.concierge.plugin.ipapers.search.NoSearchResultsFoundException;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchMethod;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubMedSearch
extends PaperSearchMethod {
    private PubMedCore pubMedCore = new PubMedCore();

    public PubMedSearch() {
        super(PubMedCore.IDTYPE);
    }

    @Override
    public void search(PaperList papers, String query, IProgressMonitor monitor) throws NoSearchResultsFoundException, Exception {
        monitor.beginTask("Searching...", 100);
        if (monitor.isCanceled()) {
            this.pubMedCore.cancel();
        }
        try {
            monitor.subTask(query);
            monitor.worked(1);
            ArrayList<String> results = this.pubMedCore.search(query);
            monitor.worked(10);
            papers.clear();
            int i = 0;
            while (i < results.size()) {
                if (monitor.isCanceled()) {
                    this.pubMedCore.cancel();
                    return;
                }
                try {
                    Paper paper = new Paper(results.get(i), PubMedCore.IDTYPE);
                    monitor.subTask(String.valueOf(i + 1) + "/" + results.size() + ": " + paper.getPaperInfo().getTitle());
                    Timer t = new Timer();
                    t.schedule((TimerTask)new MyTimer(papers, paper), 100L, 200L);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.getStackTrace();
                }
                monitor.worked(90 / results.size());
                ++i;
            }
            monitor.done();
        }
        catch (NoSearchResultsFoundException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (ConnectException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (RemoteException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (CoreException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (Exception e) {
            this.pubMedCore.cancel();
            throw e;
        }
    }

    @Override
    public ArrayList<Paper> search(String query) {
        ArrayList<Paper> papers = new ArrayList<Paper>();
        try {
            ArrayList<String> results = this.pubMedCore.search(query);
            for (String result : results) {
                papers.add(new Paper(result, PubMedCore.IDTYPE));
            }
        }
        catch (NoSearchResultsFoundException noSearchResultsFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return papers;
    }

    class MyTimer
    extends TimerTask {
        private Paper paper = null;
        private PaperList papers = null;
        private int count = 0;

        public MyTimer(PaperList papers, Paper paper) {
            this.paper = paper;
            this.papers = papers;
        }

        public void run() {
            if (2 < this.count) {
                this.cancel();
            } else if (this.paper != null) {
                if (this.paper.getPaperInfoNotDownload() != null) {
                    this.papers.addPaper(this.paper);
                    this.cancel();
                }
            } else {
                this.cancel();
            }
            ++this.count;
        }
    }
}

