/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator.dnd;

import jp.sourceforge.concierge.plugin.TabulatorPlugin;
import jp.sourceforge.concierge.plugin.tabulator.InternalTabulator;
import jp.sourceforge.concierge.util.DataDomTransfer;
import jp.sourceforge.concierge.util.IItemToString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.w3c.dom.Document;

public class DragTableAdapter
extends DragSourceAdapter {
    private Document[] docs = null;
    private InternalTabulator tabulator;

    public DragTableAdapter(InternalTabulator tv) {
        this.tabulator = tv;
    }

    public void dragSetData(DragSourceEvent e) {
        StringBuffer strBuf;
        if (DataDomTransfer.getInstance().isSupportedType(e.dataType)) {
            if (this.docs != null) {
                e.data = this.docs;
            }
        } else if (TextTransfer.getInstance().isSupportedType(e.dataType)) {
            StringBuffer strBuf2 = this.toString(this.docs);
            if (strBuf2.length() > 0) {
                e.data = strBuf2.toString();
            }
        } else if (RTFTransfer.getInstance().isSupportedType(e.dataType) && (strBuf = this.toRTFString(this.docs)).length() > 0) {
            e.data = strBuf.toString();
        }
    }

    public void dragStart(DragSourceEvent e) {
        this.docs = null;
        IStructuredSelection selection = (IStructuredSelection)this.tabulator.getView().getSelection();
        if (selection != null && selection.size() > 0) {
            Object[] obj = selection.toArray();
            this.docs = new Document[obj.length + 1];
            this.docs[0] = this.tabulator.getCurrentTypeDocument();
            int i = 0;
            while (i < obj.length) {
                this.docs[i + 1] = (Document)obj[i];
                ++i;
            }
        }
        e.doit = true;
    }

    public void dragFinished(DragSourceEvent e) {
        this.docs = null;
    }

    public StringBuffer toString(Document[] docs) {
        StringBuffer sb = new StringBuffer();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(String.valueOf(TabulatorPlugin.getDefault().getBundle().getSymbolicName()) + ".dragitem");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("dragitem")) {
                    try {
                        IItemToString extc = (IItemToString)elements[j].createExecutableExtension("class");
                        int k = 1;
                        while (k < docs.length) {
                            String str = extc.toString(docs[k], docs[0]);
                            if (str != null && str.length() > 0) {
                                sb.append(str).append("\n");
                            }
                            ++k;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return sb;
    }

    public StringBuffer toRTFString(Document[] docs) {
        StringBuffer sb = new StringBuffer();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(String.valueOf(TabulatorPlugin.getDefault().getBundle().getSymbolicName()) + ".dragitem");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("dragitem")) {
                    try {
                        IItemToString extc = (IItemToString)elements[j].createExecutableExtension("class");
                        System.out.println(elements[j].getAttribute("id"));
                        int k = 1;
                        while (k < docs.length) {
                            String str = extc.toRTFString(docs[k], docs[0]);
                            if (str != null && str.length() > 0) {
                                sb.append(str).append("\n");
                            }
                            ++k;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return sb;
    }
}

