/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator.actions;

import java.io.File;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.Tabulator;
import jp.sourceforge.concierge.plugin.tabulator.actions.TabulatorAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.w3c.dom.Document;

public class ExportFileAction
extends TabulatorAction {
    public ExportFileAction(Tabulator tv) {
        super(tv);
    }

    public void run() {
        String org;
        TableViewer tableview = this.tabulator.getTabulator().getView();
        IStructuredSelection sel = (IStructuredSelection)tableview.getSelection();
        if (sel.size() != 1) {
            return;
        }
        Document doc = (Document)sel.getFirstElement();
        String path = DataDomImpl.getFilePath((Document)doc);
        String ext = FilenameUtils.getExtension((String)path);
        FileDialog fd = new FileDialog(tableview.getTable().getShell(), 8192);
        if (ext.length() > 0) {
            fd.setFilterExtensions(new String[]{FilenameUtils.getExtension((String)path)});
        }
        if ((org = DataDomImpl.getFileName((Document)doc)).length() == 0) {
            org = FilenameUtils.getName((String)path);
        }
        fd.setFileName(org);
        String exppath = fd.open();
        if (exppath == null) {
            return;
        }
        File srcf = new File(path);
        File dstf = new File(exppath);
        try {
            if (srcf.isDirectory()) {
                FileUtils.copyDirectory((File)srcf, (File)dstf);
            } else {
                FileUtils.copyFile((File)srcf, (File)dstf);
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

