/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.CGSize;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int TAB_COUNT = 32;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_FILL = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, gdkGC);
        this.init();
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC carbon_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int context = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, context);
        return gc;
    }

    public static GC carbon_new(int context, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        gc.init(null, data, context);
        return gc;
    }

    void checkGC(int mask) {
        int colorspace;
        Pattern pattern;
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        if ((state & 1) != 0) {
            pattern = this.data.foregroundPattern;
            if (pattern != null) {
                colorspace = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetStrokeColorSpace(this.handle, colorspace);
                OS.CGColorSpaceRelease(colorspace);
                if (this.data.forePattern == 0) {
                    this.data.forePattern = pattern.createPattern(this.handle);
                }
                OS.CGContextSetStrokePattern(this.handle, this.data.forePattern, this.data.foreground);
            } else {
                OS.CGContextSetStrokeColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetStrokeColor(this.handle, this.data.foreground);
            }
        }
        if ((state & 0x100) != 0) {
            pattern = this.data.foregroundPattern;
            if (pattern != null) {
                colorspace = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetFillColorSpace(this.handle, colorspace);
                OS.CGColorSpaceRelease(colorspace);
                if (this.data.forePattern == 0) {
                    this.data.forePattern = pattern.createPattern(this.handle);
                }
                OS.CGContextSetFillPattern(this.handle, this.data.forePattern, this.data.foreground);
            } else {
                OS.CGContextSetFillColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetFillColor(this.handle, this.data.foreground);
            }
            this.data.state &= 0xFFFFFFFD;
        }
        if ((state & 2) != 0) {
            pattern = this.data.backgroundPattern;
            if (pattern != null) {
                colorspace = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetFillColorSpace(this.handle, colorspace);
                OS.CGColorSpaceRelease(colorspace);
                if (this.data.backPattern == 0) {
                    this.data.backPattern = pattern.createPattern(this.handle);
                }
                OS.CGContextSetFillPattern(this.handle, this.data.backPattern, this.data.background);
            } else {
                OS.CGContextSetFillColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetFillColor(this.handle, this.data.background);
            }
            this.data.state &= 0xFFFFFEFF;
        }
        if ((state & 4) != 0) {
            this.setCGFont();
        }
        if ((state & 0x40) != 0) {
            OS.CGContextSetLineWidth(this.handle, this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    state |= 8;
                }
            }
        }
        if ((state & 8) != 0) {
            float[] dashes = null;
            float width = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                float[] lengths = new float[dashes.length];
                int i = 0;
                while (i < lengths.length) {
                    lengths[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                OS.CGContextSetLineDash(this.handle, this.data.lineDashesOffset, lengths, lengths.length);
            } else {
                OS.CGContextSetLineDash(this.handle, 0.0f, null, 0);
            }
        }
        if ((state & 0x80) != 0) {
            OS.CGContextSetMiterLimit(this.handle, this.data.lineMiterLimit);
        }
        if ((state & 0x20) != 0) {
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 0;
                    break;
                }
                case 2: {
                    joinStyle = 1;
                    break;
                }
                case 3: {
                    joinStyle = 2;
                }
            }
            OS.CGContextSetLineJoin(this.handle, joinStyle);
        }
        if ((state & 0x10) != 0) {
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 2: {
                    capStyle = 1;
                    break;
                }
                case 1: {
                    capStyle = 0;
                    break;
                }
                case 3: {
                    capStyle = 2;
                }
            }
            OS.CGContextSetLineCap(this.handle, capStyle);
        }
        if ((state & 0x200) != 0) {
            float strokeWidth;
            float scaling;
            this.data.drawYOffset = 0.0f;
            this.data.drawXOffset = 0.0f;
            CGSize size = new CGSize();
            size.height = 1.0f;
            size.width = 1.0f;
            if (this.data.transform != null) {
                OS.CGSizeApplyAffineTransform(size, this.data.transform, size);
            }
            if ((scaling = size.width) < 0.0f) {
                scaling = -scaling;
            }
            if ((strokeWidth = this.data.lineWidth * scaling) == 0.0f || (int)strokeWidth % 2 == 1) {
                this.data.drawXOffset = 0.5f / scaling;
            }
            if ((scaling = size.height) < 0.0f) {
                scaling = -scaling;
            }
            if ((strokeWidth = this.data.lineWidth * scaling) == 0.0f || (int)strokeWidth % 2 == 1) {
                this.data.drawYOffset = 0.5f / scaling;
            }
        }
    }

    int convertRgn(int rgn, float[] transform) {
        int newRgn = OS.NewRgn();
        Callback callback = new Callback(this, "convertRgn", 4);
        int proc = callback.getAddress();
        if (proc == 0) {
            SWT.error(3);
        }
        float[] clippingTranform = this.data.clippingTransform;
        this.data.clippingTransform = transform;
        OS.QDRegionToRects(rgn, 5, proc, newRgn);
        this.data.clippingTransform = clippingTranform;
        callback.dispose();
        return newRgn;
    }

    int convertRgn(int message, int rgn, int r, int newRgn) {
        if (message == 2) {
            Rect rect = new Rect();
            OS.memmove(rect, r, 8);
            CGPoint point = new CGPoint();
            int polyRgn = OS.NewRgn();
            OS.OpenRgn();
            point.x = rect.left;
            point.y = rect.top;
            float[] transform = this.data.clippingTransform;
            OS.CGPointApplyAffineTransform(point, transform, point);
            short startX = (short)point.x;
            short startY = (short)point.y;
            OS.MoveTo(startX, startY);
            point.x = rect.right;
            point.y = rect.top;
            OS.CGPointApplyAffineTransform(point, transform, point);
            OS.LineTo((short)Math.round(point.x), (short)point.y);
            point.x = rect.right;
            point.y = rect.bottom;
            OS.CGPointApplyAffineTransform(point, transform, point);
            OS.LineTo((short)Math.round(point.x), (short)Math.round(point.y));
            point.x = rect.left;
            point.y = rect.bottom;
            OS.CGPointApplyAffineTransform(point, transform, point);
            OS.LineTo((short)point.x, (short)Math.round(point.y));
            OS.LineTo(startX, startY);
            OS.CloseRgn(polyRgn);
            OS.UnionRgn(newRgn, polyRgn, newRgn);
            OS.DisposeRgn(polyRgn);
        }
        return 0;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.image != null) {
            this.copyArea(image, x, y, this.data.image.handle);
        } else if (this.data.control != 0) {
            int imageHandle = image.handle;
            int width = OS.CGImageGetWidth(imageHandle);
            int height = OS.CGImageGetHeight(imageHandle);
            int window = OS.GetControlOwner(this.data.control);
            Rect srcRect = new Rect();
            CGPoint pt = new CGPoint();
            int[] contentView = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
            OS.HIViewConvertPoint(pt, this.data.control, contentView[0]);
            x += (int)pt.x;
            y += (int)pt.y;
            Rect inset = this.data.insetRect;
            srcRect.left = (short)(x -= inset.left);
            srcRect.top = (short)(y -= inset.top);
            srcRect.right = (short)(x + width);
            srcRect.bottom = (short)(y + height);
            Rect destRect = new Rect();
            destRect.right = (short)width;
            destRect.bottom = (short)height;
            int bpl = width * 4;
            int[] gWorld = new int[1];
            int port = OS.GetWindowPort(window);
            OS.NewGWorldFromPtr(gWorld, 32, destRect, 0, 0, 0, image.data, bpl);
            OS.CopyBits(OS.GetPortBitMapForCopyBits(port), OS.GetPortBitMapForCopyBits(gWorld[0]), srcRect, destRect, (short)0, 0);
            OS.DisposeGWorld(gWorld[0]);
        } else if (this.data.window != 0) {
            int imageHandle = image.handle;
            CGRect rect = new CGRect();
            rect.x = x;
            rect.y = y;
            rect.width = OS.CGImageGetWidth(imageHandle);
            rect.height = OS.CGImageGetHeight(imageHandle);
            int[] displays = new int[16];
            int[] count = new int[1];
            if (OS.CGGetDisplaysWithRect(rect, displays.length, displays, count) != 0) {
                return;
            }
            int i = 0;
            while (i < count[0]) {
                int display = displays[i];
                OS.CGDisplayBounds(display, rect);
                int address = OS.CGDisplayBaseAddress(display);
                if (address != 0) {
                    int width = OS.CGDisplayPixelsWide(display);
                    int height = OS.CGDisplayPixelsHigh(display);
                    int bpr = OS.CGDisplayBytesPerRow(display);
                    int bpp = OS.CGDisplayBitsPerPixel(display);
                    int bps = OS.CGDisplayBitsPerSample(display);
                    int bitmapInfo = 6;
                    switch (bpp) {
                        case 16: {
                            bitmapInfo |= OS.kCGBitmapByteOrder16Host;
                            break;
                        }
                        case 32: {
                            bitmapInfo |= OS.kCGBitmapByteOrder32Host;
                        }
                    }
                    int srcImage = 0;
                    if (OS.__BIG_ENDIAN__() && OS.VERSION >= 4160) {
                        int context = OS.CGBitmapContextCreate(address, width, height, bps, bpr, this.data.device.colorspace, bitmapInfo);
                        srcImage = OS.CGBitmapContextCreateImage(context);
                        OS.CGContextRelease(context);
                    } else {
                        int provider = OS.CGDataProviderCreateWithData(0, address, bpr * height, 0);
                        srcImage = OS.CGImageCreate(width, height, bps, bpp, bpr, this.data.device.colorspace, bitmapInfo, provider, null, true, 0);
                        OS.CGDataProviderRelease(provider);
                    }
                    this.copyArea(image, x - (int)rect.x, y - (int)rect.y, srcImage);
                    if (srcImage != 0) {
                        OS.CGImageRelease(srcImage);
                    }
                }
                ++i;
            }
        }
    }

    void copyArea(Image image, int x, int y, int srcImage) {
        int alphaInfo;
        int bpr;
        int height;
        if (srcImage == 0) {
            return;
        }
        int imageHandle = image.handle;
        int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
        int width = OS.CGImageGetWidth(imageHandle);
        int context = OS.CGBitmapContextCreate(image.data, width, height = OS.CGImageGetHeight(imageHandle), bpc, bpr = OS.CGImageGetBytesPerRow(imageHandle), this.data.device.colorspace, alphaInfo = OS.CGImageGetAlphaInfo(imageHandle));
        if (context != 0) {
            CGRect rect = new CGRect();
            rect.x = -x;
            rect.y = y;
            rect.width = OS.CGImageGetWidth(srcImage);
            rect.height = OS.CGImageGetHeight(srcImage);
            OS.CGContextTranslateCTM(context, 0.0f, -(rect.height - (float)height));
            OS.CGContextDrawImage(context, rect, srcImage);
            OS.CGContextRelease(context);
        }
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (this.data.image != null) {
            OS.CGContextSaveGState(this.handle);
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            OS.CGContextTranslateCTM(this.handle, 0.0f, -(height + 2 * destY));
            CGRect rect = new CGRect();
            rect.x = destX;
            rect.y = destY;
            rect.width = width;
            rect.height = height;
            int h = OS.CGImageGetHeight(this.data.image.handle);
            int bpr = OS.CGImageGetBytesPerRow(this.data.image.handle);
            int provider = OS.CGDataProviderCreateWithData(0, this.data.image.data, bpr * h, 0);
            if (provider != 0) {
                int colorspace = this.device.colorspace;
                int img = OS.CGImageCreate(width, height, 8, 32, bpr, colorspace, 6, provider, null, true, 0);
                OS.CGDataProviderRelease(provider);
                OS.CGContextDrawImage(this.handle, rect, img);
                OS.CGImageRelease(img);
            }
            OS.CGContextRestoreGState(this.handle);
            return;
        }
        if (this.data.control != 0) {
            int port = this.data.port;
            int window = OS.GetControlOwner(this.data.control);
            if (port == 0) {
                port = OS.GetWindowPort(window);
            }
            Rect rect = new Rect();
            OS.GetControlBounds(this.data.control, rect);
            int convertX = 0;
            int convertY = 0;
            CGPoint pt = new CGPoint();
            int[] contentView = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
            OS.HIViewConvertPoint(pt, OS.HIViewGetSuperview(this.data.control), contentView[0]);
            convertX = rect.left + (int)pt.x;
            convertY = rect.top + (int)pt.y;
            rect.left = (short)(rect.left + (int)pt.x);
            rect.top = (short)(rect.top + (int)pt.y);
            rect.right = (short)(rect.right + (int)pt.x);
            rect.bottom = (short)(rect.bottom + (int)pt.y);
            Rect srcRect = new Rect();
            int left = rect.left + srcX;
            int top = rect.top + srcY;
            OS.SetRect(srcRect, (short)left, (short)top, (short)(left + width), (short)(top + height));
            int srcRgn = OS.NewRgn();
            OS.RectRgn(srcRgn, srcRect);
            OS.SectRect(rect, srcRect, srcRect);
            Rect destRect = new Rect();
            OS.SetRect(destRect, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom);
            OS.OffsetRect(destRect, (short)deltaX, (short)deltaY);
            int destRgn = OS.NewRgn();
            OS.RectRgn(destRgn, destRect);
            if (!OS.EmptyRect(srcRect) && (this.data.visibleRgn == 0 || OS.RectInRgn(srcRect, this.data.visibleRgn))) {
                int clipRgn = this.data.visibleRgn;
                if (this.data.clipRgn != 0) {
                    clipRgn = OS.NewRgn();
                    OS.SectRgn(this.data.clipRgn, this.data.visibleRgn, clipRgn);
                }
                if (!OS.EmptyRgn(clipRgn)) {
                    boolean disjoint;
                    boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                    if (!(disjoint || deltaX != 0 && deltaY != 0)) {
                        int[] currentPort = new int[1];
                        OS.GetPort(currentPort);
                        OS.SetPort(port);
                        int oldClip = OS.NewRgn();
                        OS.GetClip(oldClip);
                        OS.SetClip(clipRgn);
                        OS.UnionRect(srcRect, destRect, rect);
                        OS.ScrollRect(rect, (short)deltaX, (short)deltaY, 0);
                        OS.SetClip(oldClip);
                        OS.DisposeRgn(oldClip);
                        OS.SetPort(currentPort[0]);
                    } else {
                        int portBitMap = OS.GetPortBitMapForCopyBits(port);
                        OS.CopyBits(portBitMap, portBitMap, srcRect, destRect, (short)0, clipRgn);
                        OS.QDFlushPortBuffer(port, destRgn);
                    }
                }
                if (clipRgn != this.data.visibleRgn) {
                    OS.DisposeRgn(clipRgn);
                }
            }
            if (paint) {
                int invalRgn = OS.NewRgn();
                OS.DiffRgn(srcRgn, this.data.visibleRgn, invalRgn);
                OS.OffsetRgn(invalRgn, (short)deltaX, (short)deltaY);
                OS.DiffRgn(srcRgn, destRgn, srcRgn);
                OS.UnionRgn(srcRgn, invalRgn, invalRgn);
                OS.SectRgn(this.data.visibleRgn, invalRgn, invalRgn);
                OS.OffsetRgn(invalRgn, (short)(-convertX), (short)(-convertY));
                OS.HIViewSetNeedsDisplayInRegion(this.data.control, invalRgn, true);
                OS.DisposeRgn(invalRgn);
            }
            OS.DisposeRgn(destRgn);
            OS.DisposeRgn(srcRgn);
        }
    }

    void createLayout() {
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout(buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        this.data.layout = buffer[0];
        int ptr1 = OS.NewPtr(4);
        buffer[0] = this.handle;
        OS.memmove(ptr1, buffer, 4);
        int ptr2 = OS.NewPtr(4);
        buffer[0] = 0x1000000;
        OS.memmove(ptr2, buffer, 4);
        boolean lineDir = false;
        if ((this.data.style & 0x4000000) != 0) {
            lineDir = true;
        }
        int ptr3 = OS.NewPtr(1);
        OS.memmove(ptr3, new byte[]{(byte)(lineDir ? 1 : 0)}, 1);
        int[] tags = new int[]{Short.MAX_VALUE, 7, 3};
        int[] sizes = new int[]{4, 4, 1};
        int[] values = new int[]{ptr1, ptr2, ptr3};
        OS.ATSUSetLayoutControls(this.data.layout, tags.length, tags, sizes, values);
        OS.DisposePtr(ptr1);
        OS.DisposePtr(ptr2);
        OS.DisposePtr(ptr3);
    }

    void createTabs() {
        ATSUTab tabs = new ATSUTab();
        int tabWidth = this.getCharWidth(' ') * 8;
        int ptr = OS.NewPtr(192);
        int i = 0;
        int offset = ptr;
        while (i < 32) {
            tabs.tabPosition += OS.Long2Fix(tabWidth);
            OS.memmove(offset, tabs, 6);
            ++i;
            offset += 6;
        }
        this.data.tabs = ptr;
    }

    void destroy() {
        int backPattern;
        int forePattern;
        int tabs;
        int stringPtr;
        int atsuiStyle;
        int layout;
        Image image;
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.DisposeRgn(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            image.createAlpha();
        }
        if ((layout = this.data.layout) != 0) {
            OS.ATSUDisposeTextLayout(layout);
        }
        if ((atsuiStyle = this.data.atsuiStyle) != 0) {
            OS.ATSUDisposeStyle(atsuiStyle);
        }
        if ((stringPtr = this.data.stringPtr) != 0) {
            OS.DisposePtr(stringPtr);
        }
        if ((tabs = this.data.tabs) != 0) {
            OS.DisposePtr(tabs);
        }
        if ((forePattern = this.data.forePattern) != 0) {
            OS.CGPatternRelease(forePattern);
        }
        if ((backPattern = this.data.backPattern) != 0) {
            OS.CGPatternRelease(backPattern);
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.backPattern = 0;
        this.data.forePattern = 0;
        this.data.tabs = 0;
        this.data.layout = 0;
        this.data.stringPtr = 0;
        this.data.atsuiStyle = 0;
        this.data.clipRgn = 0;
        this.drawable = null;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
        this.handle = 0;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, (float)x + xOffset + (float)width / 2.0f, (float)y + yOffset + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        if (arcAngle < 0) {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, true);
        } else {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f, true);
        }
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        int[] metric = new int[1];
        OS.GetThemeMetric(7, metric);
        CGRect rect = new CGRect();
        rect.x = x + metric[0];
        rect.y = y + metric[0];
        rect.width = width - metric[0] * 2;
        rect.height = height - metric[0] * 2;
        OS.HIThemeDrawFocusRect(rect, true, this.handle, 0);
        this.flush();
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        int imageHandle = srcImage.handle;
        int imgWidth = OS.CGImageGetWidth(imageHandle);
        int imgHeight = OS.CGImageGetHeight(imageHandle);
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        if (srcImage.memGC != null) {
            srcImage.createAlpha();
        }
        OS.CGContextSaveGState(this.handle);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(this.handle, 0.0f, -(destHeight + 2 * destY));
        CGRect rect = new CGRect();
        rect.x = destX;
        rect.y = destY;
        rect.width = destWidth;
        rect.height = destHeight;
        if (simple) {
            OS.CGContextDrawImage(this.handle, rect, imageHandle);
        } else {
            int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
            int bpp = OS.CGImageGetBitsPerPixel(imageHandle);
            int bpr = OS.CGImageGetBytesPerRow(imageHandle);
            int colorspace = OS.CGImageGetColorSpace(imageHandle);
            int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
            int data = srcImage.data + srcY * bpr + srcX * 4;
            int provider = OS.CGDataProviderCreateWithData(0, data, srcHeight * bpr, 0);
            if (provider != 0) {
                int subImage = OS.CGImageCreate(srcWidth, srcHeight, bpc, bpp, bpr, colorspace, alphaInfo, provider, null, true, 0);
                OS.CGDataProviderRelease(provider);
                if (subImage != 0) {
                    OS.CGContextDrawImage(this.handle, rect, subImage);
                    OS.CGImageRelease(subImage);
                }
            }
        }
        OS.CGContextRestoreGState(this.handle);
        this.flush();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (x1 == x2 && y1 == y2 && this.data.lineWidth <= 1.0f) {
            this.drawPoint(x1, y1);
            return;
        }
        OS.CGContextBeginPath(this.handle);
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        OS.CGContextMoveToPoint(this.handle, (float)x1 + xOffset, (float)y1 + yOffset);
        OS.CGContextAddLineToPoint(this.handle, (float)x2 + xOffset, (float)y2 + yOffset);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, (float)x + xOffset + (float)width / 2.0f, (float)y + yOffset + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 1.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, 0.0f, (float)(2.0 * Compatibility.PI), true);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, xOffset, yOffset);
        OS.CGContextAddPath(this.handle, path.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(256);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = 1.0f;
        rect.height = 1.0f;
        OS.CGContextFillRect(this.handle, rect);
        this.flush();
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        float[] points = new float[pointArray.length / 2 * 2];
        int i = 0;
        while (i < points.length) {
            points[i] = (float)pointArray[i] + xOffset;
            points[i + 1] = (float)pointArray[i + 1] + yOffset;
            i += 2;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, points, points.length / 2);
        OS.CGContextClosePath(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        float[] points = new float[pointArray.length / 2 * 2];
        int i = 0;
        while (i < points.length) {
            points[i] = (float)pointArray[i] + xOffset;
            points[i + 1] = (float)pointArray[i + 1] + yOffset;
            i += 2;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, points, points.length / 2);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        CGRect rect = new CGRect();
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        rect.x = (float)x + xOffset;
        rect.y = (float)y + yOffset;
        rect.width = width;
        rect.height = height;
        OS.CGContextStrokeRect(this.handle, rect);
        this.flush();
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.drawRectangle(x, y, width, height);
            return;
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw > nw) {
            naw = nw;
        }
        if (nah > nh) {
            nah = nh;
        }
        float naw2 = (float)naw / 2.0f;
        float nah2 = (float)nah / 2.0f;
        float fw = (float)nw / naw2;
        float fh = (float)nh / nah2;
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float xOffset = this.data.drawXOffset;
        float yOffset = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, (float)nx + xOffset, (float)ny + yOffset);
        OS.CGContextScaleCTM(this.handle, naw2, nah2);
        OS.CGContextMoveToPoint(this.handle, fw - 1.0f, 0.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, fh, 1.0f, fh, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, fh, fw, fh - 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, 0.0f, fw - 1.0f, 0.0f, 1.0f);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(260);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if ((length = string.length()) == 0) {
            return;
        }
        OS.CGContextSaveGState(this.handle);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        boolean mode = true;
        switch (this.data.textAntialias) {
            case -1: {
                if (this.data.window != 0 || this.data.control != 0 || this.data.image != null) break;
                mode = false;
                break;
            }
            case 0: {
                mode = false;
            }
        }
        OS.CGContextSetShouldAntialias(this.handle, mode);
        length = this.setString(string, flags);
        if ((flags & 2) != 0) {
            int layout = this.data.layout;
            int[] breakCount = new int[1];
            OS.ATSUGetSoftLineBreaks(layout, 0, length, 0, null, breakCount);
            int[] breaks = new int[breakCount[0] + 1];
            OS.ATSUGetSoftLineBreaks(layout, 0, length, breakCount[0], breaks, breakCount);
            breaks[breakCount[0]] = length;
            int i = 0;
            int start = 0;
            while (i < breaks.length) {
                int lineBreak = breaks[i];
                this.drawText(x, y, start, lineBreak - start, flags);
                y += this.data.fontAscent + this.data.fontDescent;
                start = lineBreak;
                ++i;
            }
        } else {
            this.drawText(x, y, 0, length, flags);
        }
        OS.CGContextRestoreGState(this.handle);
        this.flush();
    }

    void drawText(int x, int y, int start, int length, int flags) {
        int layout = this.data.layout;
        if ((flags & 1) == 0) {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            OS.ATSUGetGlyphBounds(layout, 0, 0, start, length, (short)1, 1, trapezoid, null);
            int width = OS.Fix2Long(trapezoid.lowerRight_x) - OS.Fix2Long(trapezoid.lowerLeft_x);
            int height = OS.Fix2Long(trapezoid.lowerRight_y) - OS.Fix2Long(trapezoid.upperRight_y);
            CGRect rect = new CGRect();
            rect.x = x;
            rect.y = -(y + height);
            rect.width = width;
            rect.height = height;
            OS.CGContextSaveGState(this.handle);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                int colorspace = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetFillColorSpace(this.handle, colorspace);
                OS.CGColorSpaceRelease(colorspace);
                if (this.data.backPattern == 0) {
                    this.data.backPattern = pattern.createPattern(this.handle);
                }
                OS.CGContextSetFillPattern(this.handle, this.data.backPattern, this.data.background);
            } else {
                OS.CGContextSetFillColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetFillColor(this.handle, this.data.background);
            }
            OS.CGContextFillRect(this.handle, rect);
            OS.CGContextRestoreGState(this.handle);
        }
        OS.ATSUDrawText(layout, start, length, OS.Long2Fix(x), OS.Long2Fix(-(y + this.data.fontAscent)));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 0.0f, 0.0f);
        if (arcAngle < 0) {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, true);
        } else {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f, true);
        }
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)width / 2.0f, (float)height / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 1.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, 0.0f, (float)(Compatibility.PI * 2.0), false);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddPath(this.handle, path.handle);
        if (this.data.fillRule == 2) {
            OS.CGContextFillPath(this.handle);
        } else {
            OS.CGContextEOFillPath(this.handle);
        }
        this.flush();
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = pointArray[i];
            ++i;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, points, points.length / 2);
        OS.CGContextClosePath(this.handle);
        if (this.data.fillRule == 2) {
            OS.CGContextFillPath(this.handle);
        } else {
            OS.CGContextEOFillPath(this.handle);
        }
        this.flush();
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        Pattern pattern = this.data.backgroundPattern;
        if (pattern != null) {
            pattern.drawRect = rect;
        }
        OS.CGContextFillRect(this.handle, rect);
        if (pattern != null) {
            pattern.drawRect = null;
        }
        this.flush();
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw > nw) {
            naw = nw;
        }
        if (nah > nh) {
            nah = nh;
        }
        float naw2 = (float)naw / 2.0f;
        float nah2 = (float)nah / 2.0f;
        float fw = (float)nw / naw2;
        float fh = (float)nh / nah2;
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, nx, ny);
        OS.CGContextScaleCTM(this.handle, naw2, nah2);
        OS.CGContextMoveToPoint(this.handle, fw - 1.0f, 0.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, fh, 1.0f, fh, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, fh, fw, fh - 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, fw, 0.0f, fw - 1.0f, 0.0f, 1.0f);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    void flush() {
        if (this.data.control != 0 && this.data.paintEvent == 0) {
            if (this.data.thread != Thread.currentThread()) {
                OS.CGContextFlush(this.handle);
            } else {
                OS.CGContextSynchronize(this.handle);
            }
        }
        if (this.data.control == 0 && this.data.window != 0) {
            OS.CGContextSynchronize(this.handle);
        }
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.carbon_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data.backgroundPattern;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return true;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.antialias;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Rect rect = null;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (this.data.control != 0) {
            if (rect == null) {
                rect = new Rect();
            }
            OS.GetControlBounds(this.data.control, rect);
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        } else if (this.data.image != null) {
            int image = this.data.image.handle;
            width = OS.CGImageGetWidth(image);
            height = OS.CGImageGetHeight(image);
        } else if (this.data.portRect != null) {
            width = this.data.portRect.right - this.data.portRect.left;
            height = this.data.portRect.bottom - this.data.portRect.top;
        }
        int clipRgn = this.data.clipRgn;
        int visibleRgn = this.data.visibleRgn;
        if (clipRgn != 0 || visibleRgn != 0 || this.data.inverseTransform != null) {
            int rgn = OS.NewRgn();
            OS.SetRectRgn(rgn, (short)x, (short)y, (short)(x + width), (short)(y + height));
            if (visibleRgn != 0) {
                OS.SectRgn(rgn, visibleRgn, rgn);
            }
            if (clipRgn != 0) {
                if (this.data.clippingTransform != null) {
                    clipRgn = this.convertRgn(clipRgn, this.data.clippingTransform);
                    OS.SectRgn(rgn, clipRgn, rgn);
                    OS.DisposeRgn(clipRgn);
                } else {
                    OS.SectRgn(rgn, clipRgn, rgn);
                }
            }
            if (this.data.inverseTransform != null) {
                clipRgn = this.convertRgn(rgn, this.data.inverseTransform);
                OS.DisposeRgn(rgn);
                rgn = clipRgn;
            }
            if (rect == null) {
                rect = new Rect();
            }
            OS.GetRegionBounds(rgn, rect);
            OS.DisposeRgn(rgn);
            x = rect.left;
            y = rect.top;
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        }
        return new Rectangle(x, y, width, height);
    }

    public void getClipping(Region region) {
        int rgn;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Rect bounds = null;
        int clipping = region.handle;
        if (this.data.clipRgn == 0) {
            int width = 0;
            int height = 0;
            if (this.data.control != 0) {
                if (bounds == null) {
                    bounds = new Rect();
                }
                OS.GetControlBounds(this.data.control, bounds);
                width = bounds.right - bounds.left;
                height = bounds.bottom - bounds.top;
            } else if (this.data.image != null) {
                int image = this.data.image.handle;
                width = OS.CGImageGetWidth(image);
                height = OS.CGImageGetHeight(image);
            } else if (this.data.portRect != null) {
                width = this.data.portRect.right - this.data.portRect.left;
                height = this.data.portRect.bottom - this.data.portRect.top;
            }
            OS.SetRectRgn(clipping, (short)0, (short)0, (short)width, (short)height);
        } else if (this.data.clippingTransform != null) {
            rgn = this.convertRgn(this.data.clipRgn, this.data.clippingTransform);
            OS.CopyRgn(rgn, clipping);
            OS.DisposeRgn(rgn);
        } else {
            OS.CopyRgn(this.data.clipRgn, clipping);
        }
        if (this.data.paintEvent != 0 && this.data.visibleRgn != 0) {
            if (bounds == null) {
                bounds = new Rect();
            }
            OS.GetControlBounds(this.data.control, bounds);
            if (this.data.paintEvent == 0) {
                OS.OffsetRgn(this.data.visibleRgn, -bounds.left, -bounds.top);
            }
            OS.SectRgn(this.data.visibleRgn, clipping, clipping);
            if (this.data.paintEvent == 0) {
                OS.OffsetRgn(this.data.visibleRgn, bounds.left, bounds.top);
            }
        }
        if (this.data.inverseTransform != null) {
            rgn = this.convertRgn(clipping, this.data.inverseTransform);
            OS.CopyRgn(rgn, clipping);
            OS.DisposeRgn(rgn);
        }
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.fillRule;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        Font font = this.data.font;
        ATSFontMetrics metrics = new ATSFontMetrics();
        OS.ATSFontGetVerticalMetrics(font.handle, 0, metrics);
        OS.ATSFontGetHorizontalMetrics(font.handle, 0, metrics);
        int ascent = (int)(0.5f + metrics.ascent * font.size);
        int descent = (int)(0.5f + (-metrics.descent + metrics.leading) * font.size);
        String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int averageCharWidth = this.stringExtent((String)s).x / s.length();
        return FontMetrics.carbon_new(ascent, descent, averageCharWidth, 0, ascent + descent);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return Color.carbon_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int interpolation = OS.CGContextGetInterpolationQuality(this.handle);
        switch (interpolation) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        int i = 0;
        while (i < lineDashes.length) {
            lineDashes[i] = (int)this.data.lineDashes[i];
            ++i;
        }
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.textAntialias;
    }

    public void getTransform(Transform transform) {
        float[] cmt;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((cmt = this.data.transform) != null) {
            transform.setElements(cmt[0], cmt[1], cmt[2], cmt[3], cmt[4], cmt[5]);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int context) {
        if (data.foreground != null) {
            data.state &= 0xFFFFFEFE;
        }
        if (data.background != null) {
            data.state &= 0xFFFFFFFD;
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        data.state &= 0xFFFFFDFF;
        Image image = data.image;
        if (image != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = context;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(float[] transform) {
        return transform[0] == 1.0f && transform[1] == 0.0f && transform[2] == 0.0f && transform[3] == 1.0f && transform[4] == 0.0f && transform[5] == 0.0f;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!advanced) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping(0);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.alpha = alpha & 0xFF;
        OS.CGContextSetAlpha(this.handle, (float)this.data.alpha / 255.0f);
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        boolean mode = true;
        switch (antialias) {
            case -1: {
                if (this.data.window != 0 || this.data.control != 0 || this.data.image != null) break;
                mode = false;
                break;
            }
            case 0: {
                mode = false;
                break;
            }
            case 1: {
                mode = true;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = antialias;
        OS.CGContextSetShouldAntialias(this.handle, mode);
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
        }
        this.data.backPattern = 0;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
        }
        this.data.backPattern = 0;
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    void setClipping(int clipRgn) {
        if (clipRgn == 0) {
            if (this.data.clipRgn != 0) {
                OS.DisposeRgn(this.data.clipRgn);
                this.data.clipRgn = 0;
            }
            this.data.clippingTransform = null;
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.NewRgn();
            }
            OS.CopyRgn(clipRgn, this.data.clipRgn);
            if (this.data.transform != null) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new float[6];
                }
                System.arraycopy(this.data.transform, 0, this.data.clippingTransform, 0, this.data.transform.length);
            }
        }
        this.data.updateClip = true;
        this.setCGClipping();
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int clipRgn = OS.NewRgn();
        OS.SetRectRgn(clipRgn, (short)x, (short)y, (short)(x + width), (short)(y + height));
        this.setClipping(clipRgn);
        OS.DisposeRgn(clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            OS.CGContextAddPath(this.handle, path.handle);
            OS.CGContextEOClip(this.handle);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    void setCGClipping() {
        boolean isPaint;
        this.data.updateClip = false;
        if (this.data.control == 0) {
            if (this.data.window != 0 && !OS.IsWindowVisible(this.data.window)) {
                OS.ShowWindow(this.data.window);
            }
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            if (this.data.clipRgn != 0) {
                OS.ClipCGContextToRegion(this.handle, new Rect(), this.data.clipRgn);
            } else {
                int rgn = OS.NewRgn();
                OS.SetRectRgn(rgn, (short)Short.MIN_VALUE, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
                OS.ClipCGContextToRegion(this.handle, new Rect(), rgn);
                OS.DisposeRgn(rgn);
            }
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            return;
        }
        int port = this.data.port;
        int window = OS.GetControlOwner(this.data.control);
        if (port == 0) {
            port = OS.GetWindowPort(window);
        }
        Rect portRect = this.data.portRect;
        Rect rect = this.data.controlRect;
        OS.CGContextTranslateCTM(this.handle, -rect.left, portRect.bottom - portRect.top - rect.top);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.GetPortBounds(port, portRect);
        OS.GetControlBounds(this.data.control, rect);
        boolean bl = isPaint = this.data.paintEvent != 0;
        if (isPaint) {
            rect.right = (short)(rect.right + rect.left);
            rect.bottom = (short)(rect.bottom + rect.top);
            rect.top = 0;
            rect.left = 0;
        } else {
            int[] contentView = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
            CGPoint pt = new CGPoint();
            OS.HIViewConvertPoint(pt, OS.HIViewGetSuperview(this.data.control), contentView[0]);
            rect.left = (short)(rect.left + (int)pt.x);
            rect.top = (short)(rect.top + (int)pt.y);
            rect.right = (short)(rect.right + (int)pt.x);
            rect.bottom = (short)(rect.bottom + (int)pt.y);
        }
        if (this.data.clipRgn != 0) {
            int rgn = OS.NewRgn();
            OS.CopyRgn(this.data.clipRgn, rgn);
            OS.OffsetRgn(rgn, rect.left, rect.top);
            OS.SectRgn(this.data.visibleRgn, rgn, rgn);
            OS.ClipCGContextToRegion(this.handle, portRect, rgn);
            OS.DisposeRgn(rgn);
        } else {
            OS.ClipCGContextToRegion(this.handle, portRect, this.data.visibleRgn);
        }
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(this.handle, rect.left, -(portRect.bottom - portRect.top) + rect.top);
    }

    void setCGFont() {
        int tabs = this.data.tabs;
        if (tabs != 0) {
            OS.DisposePtr(tabs);
        }
        this.data.tabs = 0;
        Font font = this.data.font;
        ATSFontMetrics metrics = new ATSFontMetrics();
        OS.ATSFontGetVerticalMetrics(font.handle, 0, metrics);
        OS.ATSFontGetHorizontalMetrics(font.handle, 0, metrics);
        this.data.fontAscent = (int)(0.5f + metrics.ascent * font.size);
        this.data.fontDescent = (int)(0.5f + (-metrics.descent + metrics.leading) * font.size);
        if (font.atsuiStyle == 0) {
            if (this.data.atsuiStyle != 0) {
                OS.ATSUDisposeStyle(this.data.atsuiStyle);
            }
            this.data.atsuiStyle = font.createStyle();
        }
        this.data.string = null;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (rule) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.fillRule = rule;
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
        }
        this.data.forePattern = 0;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
        }
        this.data.forePattern = 0;
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int quality = 0;
        switch (interpolation) {
            case -1: {
                quality = 0;
                break;
            }
            case 0: {
                quality = 1;
                break;
            }
            case 1: {
                quality = 2;
                break;
            }
            case 2: {
                quality = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.CGContextSetInterpolationQuality(this.handle, quality);
    }

    public void setLineAttributes(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x240;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x20;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x10;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != dash) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != (float)dash) {
                    changed = true;
                }
                ++i;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            i = 0;
            while (i < dashes.length) {
                this.data.lineDashes[i] = dashes[i];
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFFDBF;
    }

    int setString(String string, int flags) {
        if (this.data.layout == 0) {
            this.createLayout();
        }
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return this.data.stringLength;
        }
        int layout = this.data.layout;
        int length = string.length();
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        int breakCount = 0;
        int[] breaks = null;
        if ((flags & 0xA) != 0) {
            int i = 0;
            int j = 0;
            block4: while (i < chars.length) {
                int n = j++;
                char c = chars[i++];
                chars[n] = c;
                char c2 = c;
                switch (c2) {
                    case '&': {
                        if ((flags & 8) == 0 || i == chars.length) continue block4;
                        if (chars[i] == '&') {
                            ++i;
                            break;
                        }
                        --j;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((flags & 2) == 0) break;
                        if (c2 == '\r' && i != chars.length && chars[i] == '\n') {
                            ++i;
                        }
                        --j;
                        if (breaks == null) {
                            breaks = new int[4];
                        } else if (breakCount == breaks.length) {
                            int[] newBreaks = new int[breaks.length + 4];
                            System.arraycopy(breaks, 0, newBreaks, 0, breaks.length);
                            breaks = newBreaks;
                        }
                        breaks[breakCount++] = j;
                    }
                }
            }
            length = j;
        }
        if ((flags & 4) != 0) {
            if (this.data.tabs == 0) {
                this.createTabs();
            }
            OS.ATSUSetTabArray(layout, this.data.tabs, 32);
        } else {
            OS.ATSUSetTabArray(layout, 0, 0);
        }
        int ptr = OS.NewPtr(length * 2);
        OS.memmove(ptr, chars, length * 2);
        OS.ATSUSetTextPointerLocation(layout, ptr, 0, length, length);
        if ((flags & 2) != 0 && breaks != null) {
            int i = 0;
            while (i < breakCount) {
                OS.ATSUSetSoftLineBreak(layout, breaks[i]);
                ++i;
            }
        }
        Font font = this.data.font;
        int atsuiStyle = font.atsuiStyle != 0 ? font.atsuiStyle : this.data.atsuiStyle;
        OS.ATSUSetRunStyle(layout, atsuiStyle, 0, length);
        OS.ATSUSetTransientFontMatching(layout, true);
        if (this.data.stringPtr != 0) {
            OS.DisposePtr(this.data.stringPtr);
        }
        this.data.stringPtr = ptr;
        this.data.string = string;
        this.data.stringLength = length;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
        return length;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.xorMode = xor;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.textAntialias = antialias;
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.inverseTransform != null) {
            OS.CGContextConcatCTM(this.handle, this.data.inverseTransform);
        }
        if (transform != null) {
            OS.CGContextConcatCTM(this.handle, transform.handle);
            if (this.data.transform == null) {
                this.data.transform = new float[6];
            }
            if (this.data.inverseTransform == null) {
                this.data.inverseTransform = new float[6];
            }
            System.arraycopy(transform.handle, 0, this.data.transform, 0, this.data.transform.length);
            System.arraycopy(transform.handle, 0, this.data.inverseTransform, 0, this.data.inverseTransform.length);
            OS.CGAffineTransformInvert(this.data.inverseTransform, this.data.inverseTransform);
        } else {
            this.data.inverseTransform = null;
            this.data.transform = null;
        }
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
            this.data.forePattern = 0;
            this.data.state &= 0xFFFFFEFE;
        }
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
            this.data.backPattern = 0;
            this.data.state &= 0xFFFFFFFD;
        }
        this.data.state &= 0xFFFFFDFF;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        int height;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(4);
        int length = this.setString(string, flags);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int width = 0;
        if (length == 0) {
            height = this.data.fontAscent + this.data.fontDescent;
        } else {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            if ((flags & 2) != 0) {
                height = 0;
                int layout = this.data.layout;
                int[] breakCount = new int[1];
                OS.ATSUGetSoftLineBreaks(layout, 0, length, 0, null, breakCount);
                int[] breaks = new int[breakCount[0] + 1];
                OS.ATSUGetSoftLineBreaks(layout, 0, length, breakCount[0], breaks, breakCount);
                breaks[breakCount[0]] = length;
                int i = 0;
                int start = 0;
                while (i < breaks.length) {
                    int lineBreak = breaks[i];
                    OS.ATSUGetGlyphBounds(layout, 0, 0, start, lineBreak - start, (short)1, 1, trapezoid, null);
                    width = Math.max(width, OS.Fix2Long(trapezoid.lowerRight_x) - OS.Fix2Long(trapezoid.lowerLeft_x));
                    height += OS.Fix2Long(trapezoid.lowerRight_y) - OS.Fix2Long(trapezoid.upperRight_y);
                    start = lineBreak;
                    ++i;
                }
            } else {
                OS.ATSUGetGlyphBounds(this.data.layout, 0, 0, 0, length, (short)1, 1, trapezoid, null);
                width = OS.Fix2Long(trapezoid.lowerRight_x) - OS.Fix2Long(trapezoid.lowerLeft_x);
                height = OS.Fix2Long(trapezoid.lowerRight_y) - OS.Fix2Long(trapezoid.upperRight_y);
            }
        }
        this.data.stringWidth = width;
        this.data.stringHeight = height;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

