/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.exportreference.preferences.BibTeX;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.BibTeX.BibTeXMappingData;
import jp.sourceforge.concierge.plugin.BibTeX.BibTeXMappingDataDomImpl;
import jp.sourceforge.concierge.plugin.BibTeX.BibTeXMappingDataList;
import jp.sourceforge.concierge.plugin.MappingField;
import jp.sourceforge.concierge.plugin.exportreference.preferences.BibTeX.EditBibTeXDatasetListDialog;
import jp.sourceforge.concierge.plugin.exportreference.preferences.MappingTablePreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BibTeXPreferencePage
extends MappingTablePreferencePage {
    private Text citationKeyText = null;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.shell = parent.getShell();
        Control control = this.createSettingControl(parent);
        this.initialize();
        return control;
    }

    protected Control createSettingControl(Composite parent) {
        SashForm sf = new SashForm(parent, 256);
        sf.setLayout((Layout)new FillLayout());
        this.createTypeTableViewer((Composite)sf);
        Composite composite = new Composite((Composite)sf, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDatasetControls(composite);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite upperComposite = new Composite((Composite)group, 0);
        upperComposite.setLayoutData((Object)new GridData(768));
        upperComposite.setLayout((Layout)new GridLayout(2, false));
        this.createDataNameControls(upperComposite);
        this.createDstTypeNameControls(upperComposite, "Entry Type:");
        Label separator = new Label(upperComposite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        Label citationKeyLabel = new Label(upperComposite, 131072);
        citationKeyLabel.setText("Citation Key:");
        this.citationKeyText = new Text(upperComposite, 2048);
        this.citationKeyText.setLayoutData((Object)new GridData(768));
        this.createMappingTableViewer((Composite)group, "BibTeX", "Concierge");
        sf.setWeights(new int[]{25, 75});
        return sf;
    }

    private BibTeXMappingDataList getSelectionTypeTableView() {
        Object obj;
        ISelection selection = this.typeTableView.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof BibTeXMappingDataList) {
            return (BibTeXMappingDataList)obj;
        }
        return null;
    }

    protected void setMappingDataToControls(BibTeXMappingData data) {
        super.setMappingDataToControls(data);
        if (data != null) {
            this.citationKeyText.setData(null);
            this.citationKeyText.setText(data.getCitationKey());
            this.citationKeyText.setData((Object)data);
        } else {
            this.citationKeyText.setText("");
            this.citationKeyText.setData(null);
        }
    }

    protected void initialize() {
        this.typeTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof BibTeXMappingDataList) {
                    BibTeXMappingDataList mappingDataList = (BibTeXMappingDataList)obj;
                    BibTeXPreferencePage.this.comboBoxCellEditor.setItems(mappingDataList.getSrcElementNamesPlusSpace());
                    ArrayList<BibTeXMappingData> mappingDataAL = mappingDataList.getList();
                    BibTeXPreferencePage.this.datasetListCombo.setInput(mappingDataAL);
                    BibTeXPreferencePage.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                    BibTeXMappingData mappingData = null;
                    if (mappingDataList.getCurrentIndex() >= 0) {
                        mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
                    }
                    BibTeXPreferencePage.this.setMappingDataToControls(mappingData);
                    return;
                }
                BibTeXPreferencePage.this.comboBoxCellEditor.setItems(null);
                BibTeXPreferencePage.this.datasetListCombo.setInput(null);
            }
        });
        this.datasetListCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof BibTeXMappingData) {
                    BibTeXMappingData data = (BibTeXMappingData)obj;
                    BibTeXMappingDataList mappingDataList = BibTeXPreferencePage.this.getSelectionTypeTableView();
                    mappingDataList.setCurrentIndex(data);
                    BibTeXPreferencePage.this.setMappingDataToControls(data);
                    return;
                }
                BibTeXPreferencePage.this.mappingTableViewer.setInput(null);
            }
        });
        this.datasetEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                BibTeXMappingDataList mappingDataList = BibTeXPreferencePage.this.getSelectionTypeTableView();
                ArrayList<BibTeXMappingData> mappingDataAL = mappingDataList.getList();
                EditBibTeXDatasetListDialog dlg = new EditBibTeXDatasetListDialog(button.getShell(), mappingDataList.getSrcDoc(), mappingDataAL);
                if (dlg.open() == 0) {
                    ArrayList<BibTeXMappingData> al = dlg.getMappingDataList();
                    int i = mappingDataAL.size() - 1;
                    while (i >= 0) {
                        BibTeXMappingData srcObj = mappingDataAL.get(i);
                        if (!al.remove(srcObj)) {
                            mappingDataAL.remove(i);
                        }
                        --i;
                    }
                    if (al.size() > 0) {
                        mappingDataAL.addAll(al);
                        mappingDataList.setCurrentIndex(mappingDataAL.size() - 1);
                        BibTeXPreferencePage.this.datasetListCombo.refresh();
                        BibTeXPreferencePage.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                        BibTeXPreferencePage.this.setMappingDataToControls(mappingDataAL.get(mappingDataList.getCurrentIndex()));
                    }
                }
            }
        });
        this.citationKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                BibTeXMappingData data = (BibTeXMappingData)text.getData();
                if (data != null) {
                    data.setCitationKey(new String(text.getText()));
                }
            }
        });
        this.mappingTableViewer.setLabelProvider((IBaseLabelProvider)new MappingViewLabelProvider());
        ArrayList typedocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < typedocs.size()) {
            BibTeXMappingDataList mappingDataList = new BibTeXMappingDataList((Document)typedocs.get(i));
            this.typeTableView.add((Object)mappingDataList);
            this.readDoc(mappingDataList);
            ArrayList<BibTeXMappingData> mappingDataAL = mappingDataList.getList();
            if (mappingDataAL.size() == 0) {
                BibTeXMappingData mappingData = new BibTeXMappingData((Document)typedocs.get(i));
                mappingDataAL.add(mappingData);
                mappingDataList.setCurrentIndex(0);
            }
            ++i;
        }
        if (this.typeTableView.getTable().getItemCount() > 0) {
            this.typeTableView.getTable().select(0);
            BibTeXMappingDataList mappingDataList = (BibTeXMappingDataList)this.typeTableView.getElementAt(0);
            this.comboBoxCellEditor.setItems(mappingDataList.getSrcElementNamesPlusSpace());
            ArrayList<BibTeXMappingData> mappingDataAL = mappingDataList.getList();
            this.datasetListCombo.setInput(mappingDataAL);
            this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
            BibTeXMappingData mappingData = null;
            if (mappingDataList.getCurrentIndex() >= 0) {
                mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
            }
            this.setMappingDataToControls(mappingData);
        }
    }

    protected void DoSave() {
        this.citationKeyText.setFocus();
        this.deleteMappingDataFromDB();
        this.saveMappingDataToDB();
        int i = 0;
        while (i < this.typeTableView.getTable().getItemCount()) {
            BibTeXMappingDataList mappingDataList = (BibTeXMappingDataList)this.typeTableView.getElementAt(i);
            ArrayList<BibTeXMappingData> mappingDataAL = mappingDataList.getList();
            BibTeXMappingData mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
            BibTeXMappingDataDomImpl.setCurrentMappingData(mappingDataList.getSrcTypeName(), mappingData);
            ++i;
        }
    }

    private void deleteMappingDataFromDB() {
        String xpath = new String();
        xpath = String.valueOf(xpath) + "/";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(2, (Object)docs, "exportmappingdata"));
            FrameworkPlugin.updateDocuments(reqs, (boolean)true, (Object)"jp.sourceforge.concierge.plugin.bibtexexporter.preferences.BibTeX.BibTeXPreferencePage");
            reqs = null;
        }
        docs = null;
    }

    private void saveMappingDataToDB() {
        ArrayList<Document> docs = new ArrayList<Document>();
        int i = 0;
        while (i < this.typeTableView.getTable().getItemCount()) {
            BibTeXMappingDataList mappingDataList = (BibTeXMappingDataList)this.typeTableView.getElementAt(i);
            Document doc = this.newDoc(mappingDataList);
            if (doc != null) {
                docs.add(doc);
            }
            ++i;
        }
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(1, docs, "exportmappingdata"));
            FrameworkPlugin.updateDocuments(reqs, (boolean)true, (Object)"jp.sourceforge.concierge.plugin.bibtexexporter.preferences.BibTeX.BibTeXPreferencePage");
            Object var2_3 = null;
        }
        docs = null;
    }

    private Document newDoc(BibTeXMappingDataList mappingDataList) {
        Document doc = null;
        try {
            doc = DomImpl.createDocument((String)"bibtexmappingdata");
            Element rootElem = doc.getDocumentElement();
            rootElem.setAttribute("typeid", mappingDataList.getSrcID());
            rootElem.setAttribute("select", String.valueOf(mappingDataList.getCurrentIndex()));
            ArrayList<BibTeXMappingData> mappingDataAL = mappingDataList.getList();
            int j = 0;
            while (j < mappingDataAL.size()) {
                BibTeXMappingData mappingData = mappingDataAL.get(j);
                Element dataElem = doc.createElement("data");
                rootElem.appendChild(dataElem);
                dataElem.setAttribute("dataname", mappingData.getDataName());
                dataElem.setAttribute("bibtexentrytype", mappingData.getDstTypeName());
                dataElem.setAttribute("citationkey", mappingData.getCitationKey());
                ArrayList<MappingField> fields = mappingData.getFields();
                int k = 0;
                while (k < fields.size()) {
                    MappingField field = fields.get(k);
                    Element fieldElem = doc.createElement("field");
                    dataElem.appendChild(fieldElem);
                    fieldElem.setAttribute("bibtex", field.getDst());
                    fieldElem.setAttribute("ccg", field.getSrc());
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            doc = null;
        }
        return doc;
    }

    private void readDoc(BibTeXMappingDataList mappingDataList) {
        String xpath = "/bibtexmappingdata[@typeid='" + mappingDataList.getSrcID() + "']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element rootElem = doc.getDocumentElement();
            String selectString = rootElem.getAttribute("select");
            if (selectString != null && selectString.length() > 0) {
                mappingDataList.setCurrentIndex(Integer.valueOf(selectString));
            } else {
                mappingDataList.setCurrentIndex(-1);
            }
            Node dataNode = rootElem.getFirstChild();
            while (dataNode != null) {
                if (dataNode.getNodeType() == 1) {
                    ArrayList<MappingField> fieldsAL = new ArrayList<MappingField>();
                    Node fieldNode = dataNode.getFirstChild();
                    while (fieldNode != null) {
                        if (fieldNode.getNodeType() == 1) {
                            String bibtexValue = ((Element)fieldNode).getAttribute("bibtex");
                            String ccgValue = ((Element)fieldNode).getAttribute("ccg");
                            fieldsAL.add(new MappingField(bibtexValue, ccgValue));
                        }
                        fieldNode = fieldNode.getNextSibling();
                    }
                    String dataName = ((Element)dataNode).getAttribute("dataname");
                    String bibtexEntryType = ((Element)dataNode).getAttribute("bibtexentrytype");
                    String citationkey = ((Element)dataNode).getAttribute("citationkey");
                    BibTeXMappingData mappingData = new BibTeXMappingData(dataName, bibtexEntryType, citationkey, fieldsAL);
                    mappingDataList.addMappingData(mappingData);
                }
                dataNode = dataNode.getNextSibling();
            }
        }
    }

    class MappingViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MappingViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof MappingField) {
                MappingField field = (MappingField)obj;
                if (index == 0) {
                    return field.getDst();
                }
                if (index == 1) {
                    return field.getSrc();
                }
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

