/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.labnote.LabNoteDocumentImpl;
import jp.sourceforge.concierge.plugin.labnote.preferences.LabNotePreferencePage;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;

public class LabNoteToolTip
extends ToolTip {
    Composite body = null;
    CLabel titlelabel = null;
    Browser browser = null;
    Document document = null;

    public LabNoteToolTip(Control control, int style, boolean manualActivation) {
        super(control, style, manualActivation);
        this.setRespectDisplayBounds(false);
        this.setRespectMonitorBounds(false);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        boolean visible = LabNotePreferencePage.isTooltipContentVisible();
        int width = 0;
        int height = 0;
        if (visible) {
            width = 306;
            height = 346;
        } else {
            width = 200;
            height = 51;
        }
        Composite base = new Composite(parent, 4);
        base.setBounds(0, 0, width, height);
        this.body = new Composite(base, 0);
        this.body.setBounds(3, 3, width - 6, height - 6);
        this.titlelabel = new CLabel(this.body, 16384);
        this.titlelabel.setBounds(0, 0, width - 6, 20);
        GraphicUtil.setBackground((Control)this.titlelabel, (int)29);
        if (visible) {
            this.browser = new Browser(this.body, 0);
            this.browser.setBounds(0, 21, width - 6, height - 6 - 21);
        }
        if (this.document != null) {
            this.titlelabel.setText("Title:\t" + LabNoteDocumentImpl.getTitle(this.document));
            if (visible) {
                this.browser.setUrl(DataDomImpl.getFilePath((Document)this.document));
            }
        }
        this.setHideOnMouseDown(false);
        return parent;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }
}

