/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialogListener;
import jp.sourceforge.concierge.plugin.footprint.FootprintDrawer;
import jp.sourceforge.concierge.plugin.footprint.text.ConciergeEditor;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedDocument;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedObject;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;

public class FootprintDialog
extends ConciergeDialog {
    Label datelabel;
    Label datevalue;
    Label titlelabel;
    Text titlevalue;
    Label catlabel;
    Combo catvalue;
    ConciergeEditor commentvalue;
    Document document;
    FootprintDrawer drawer;
    Object sender;
    FootprintDialogListener listener;
    ModifyListener editormodlistener;
    ModifyListener titlemodlistener;
    static final int ID_EXPORT = 200;
    static final String dialogtitle = "Footprint Editor";
    boolean isclosed = true;
    boolean ismodified = false;
    boolean issaved = false;
    boolean isrejected = false;

    public FootprintDialog(Shell parent, int style) {
        super(new Shell(parent), style);
        if ((style & 0x4F0) != 0) {
            this.setShellStyle(1264);
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(parent, 0);
        GridLayout cgl = new GridLayout(1, false);
        cgl.marginWidth = 0;
        comp.setLayout((Layout)cgl);
        comp.setLayoutData((Object)new GridData(1808));
        GraphicUtil.setBackground((Control)comp, (int)1);
        Composite header = new Composite(comp, 0);
        header.setLayout((Layout)new GridLayout(3, false));
        header.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)header, (int)1);
        this.catlabel = new Label(header, 0);
        this.catlabel.setLayoutData((Object)new GridData(0));
        this.catlabel.setText("Category:");
        GraphicUtil.setBackground((Control)this.catlabel, (int)1);
        this.catvalue = new Combo(header, 8);
        this.catvalue.setLayoutData((Object)new GridData(768));
        ImageHyperlink llink = new ImageHyperlink(header, 0x800000);
        llink.setLayoutData((Object)new GridData(0));
        GraphicUtil.setBackground((Control)llink, (int)1);
        llink.setImage(FootprintPlugin.getImageDescriptor("icons/openlist.png").createImage());
        llink.setToolTipText("Show other items which have the same lastmodified date.");
        llink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (!FootprintDialog.this.drawer.isOpened()) {
                    ArrayList docs = FootprintPlugin.getDocumentsByTheSameLastMod(FootprintDialog.this.document);
                    FootprintDialog.this.drawer.setDocuments(docs);
                    FootprintDialog.this.drawer.open();
                    ((ImageHyperlink)e.widget).setImage(FootprintPlugin.getImageDescriptor("icons/closelist.png").createImage());
                } else {
                    FootprintDialog.this.drawer.close();
                    ((ImageHyperlink)e.widget).setImage(FootprintPlugin.getImageDescriptor("icons/openlist.png").createImage());
                }
            }
        });
        Composite headgrp = new Composite(header, 2048);
        headgrp.setLayout((Layout)new GridLayout(2, false));
        GridData hggd = new GridData(1808);
        hggd.horizontalSpan = 3;
        headgrp.setLayoutData((Object)hggd);
        GraphicUtil.setBackground((Control)headgrp, (int)1);
        this.titlelabel = new Label(headgrp, 0);
        this.titlelabel.setLayoutData((Object)new GridData(0));
        this.titlelabel.setText("Title:");
        GraphicUtil.setBackground((Control)this.titlelabel, (int)1);
        this.titlevalue = new Text(headgrp, 4);
        this.titlevalue.setLayoutData((Object)new GridData(768));
        this.titlemodlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FootprintDialog.this.ismodified = true;
                FootprintDialog.this.getShell().setText("Footprint Editor *");
            }
        };
        this.titlevalue.addModifyListener(this.titlemodlistener);
        this.datelabel = new Label(headgrp, 0);
        this.datelabel.setLayoutData((Object)new GridData(0));
        this.datelabel.setText("Date:");
        GraphicUtil.setBackground((Control)this.datelabel, (int)1);
        this.datevalue = new Label(headgrp, 4);
        this.datevalue.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.datevalue, (int)1);
        FootprintPlugin fp = FootprintPlugin.getDefault();
        ArrayList l = fp.getCategories();
        Collections.sort(l);
        int i = 0;
        while (i < l.size()) {
            this.catvalue.add((String)l.get(i));
            ++i;
        }
        if (this.catvalue.getItemCount() > 0) {
            this.catvalue.select(0);
        }
        this.catvalue.pack();
        Composite body = new Composite(comp, 2048);
        GridLayout bgl = new GridLayout(2, false);
        bgl.marginWidth = 2;
        bgl.marginHeight = 2;
        body.setLayout((Layout)bgl);
        body.setLayoutData((Object)new GridData(1808));
        GraphicUtil.setBackground((Control)body, (int)1);
        this.commentvalue = new ConciergeEditor(body);
        GridData cgd = new GridData(1808);
        cgd.minimumWidth = 200;
        cgd.minimumHeight = 200;
        cgd.horizontalSpan = 2;
        this.commentvalue.setLayoutData(cgd);
        this.editormodlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FootprintDialog.this.ismodified = true;
                FootprintDialog.this.getShell().setText("Footprint Editor *");
            }
        };
        this.commentvalue.getTextWidget().addModifyListener(this.editormodlistener);
        this.drawer = new FootprintDrawer(this.getShell(), 200);
        if (this.document != null) {
            this.update();
        }
        this.getShell().setText(dialogtitle);
        return comp;
    }

    protected void initializeBounds() {
        this.getShell().setSize(480, 640);
        this.titlevalue.setFocus();
    }

    protected void handleShellCloseEvent() {
        if (this.ismodified && MessageDialog.openQuestion((Shell)this.getShell(), (String)"Save", (String)"The metadata was modified. Save before leaving?")) {
            this.setValuesToDocument();
            this.saveDocument();
        }
        this.setReturnCode(this.issaved ? 0 : 1);
        this.document = null;
        if (this.listener != null && this.document != null) {
            this.listener.closeClicked(this.document);
        }
        super.handleShellCloseEvent();
        this.isclosed = true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 200, "Export", false);
        this.createButton(parent, 0, "Save", true);
        this.createButton(parent, 12, "Close", false);
        this.getButton(200).setToolTipText("Export to HTML");
        this.getButton(0).setToolTipText("Save and no close");
        this.getButton(12).setToolTipText("close");
    }

    private void updateEmbeddedObjects(ArrayList objs) {
        int i = 0;
        while (i < objs.size()) {
            EmbeddedObject eo = (EmbeddedObject)objs.get(i);
            Document mdoc = eo.getDocument();
            if (eo.getUpdate() && mdoc != null) {
                if (!(eo instanceof EmbeddedDocument)) {
                    String newname = String.valueOf(String.valueOf(DomImpl.getID((Document)mdoc))) + "." + FilenameUtils.getExtension((String)eo.getFileName());
                    FrameworkPlugin.importRelatedFile((String)eo.getFileName(), (String)newname);
                }
                eo.setUpdate(false);
                FootprintPlugin.getDefault().updateDocument(mdoc, this.sender);
            }
            ++i;
        }
    }

    private void setValuesToDocument() {
        if (this.document == null) {
            return;
        }
        FootprintPlugin.setTitle(this.document, this.titlevalue.getText());
        FootprintPlugin.setComment(this.document, this.commentvalue.getDocument());
        FootprintPlugin.setCategory(this.document, this.catvalue.getText());
    }

    private void saveDocument() {
        FootprintPlugin fp = FootprintPlugin.getDefault();
        fp.updateDocument(this.document, this.sender);
        ArrayList list = this.commentvalue.getEmbeddedObject();
        if (list != null) {
            this.updateEmbeddedObjects(list);
        }
        this.issaved = true;
    }

    protected void buttonPressed(int buttonId) {
        this.titlevalue.removeModifyListener(this.titlemodlistener);
        this.commentvalue.getTextWidget().removeModifyListener(this.editormodlistener);
        if (buttonId == 0) {
            this.getShell().setText(dialogtitle);
            this.setValuesToDocument();
            this.saveDocument();
            if (this.listener != null && this.document != null) {
                this.listener.saveClicked(this.document);
            }
            this.ismodified = false;
            this.titlevalue.addModifyListener(this.titlemodlistener);
            this.commentvalue.getTextWidget().addModifyListener(this.editormodlistener);
        } else {
            if (buttonId == 12) {
                if (this.ismodified && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"Save", (String)"The metadata was modified. Save before leaving?")) {
                    this.setReturnCode(this.issaved ? 0 : 1);
                    this.isclosed = true;
                    this.document = null;
                    super.close();
                    return;
                }
                this.setValuesToDocument();
                this.saveDocument();
                if (this.listener != null && this.document != null) {
                    this.listener.closeClicked(this.document);
                }
                this.setReturnCode(0);
                this.isclosed = true;
                this.document = null;
                super.close();
                return;
            }
            if (buttonId == 200) {
                this.commentvalue.exportToHtml();
            }
        }
        this.titlevalue.addModifyListener(this.titlemodlistener);
        this.commentvalue.getTextWidget().addModifyListener(this.editormodlistener);
    }

    public int open() {
        if (this.isrejected) {
            MessageDialog.openWarning((Shell)FootprintPlugin.getDefault().getWorkbench().getDisplay().getActiveShell(), (String)"Warning", (String)"Drag and drop operation is NOT permitted for this resource type.");
            this.isrejected = false;
            return -1;
        }
        if (!this.isclosed) {
            return -1;
        }
        this.isclosed = false;
        return super.open();
    }

    public boolean close() {
        if (this.isclosed) {
            return false;
        }
        this.isclosed = true;
        return super.close();
    }

    public void setDocument(Document doc) {
        this.setDocument(doc, null);
    }

    public void setDocument(Document doc, Object sender) {
        String path;
        if (sender != null && !sender.equals(FootprintPlugin.getDefault().getBundle().getSymbolicName()) && (path = DataDomImpl.getFilePath((Document)doc)) != null && path.length() > 0) {
            this.isrejected = true;
            return;
        }
        if (this.document != null && this.ismodified && MessageDialog.openQuestion((Shell)this.getShell(), (String)"Save", (String)"The metadata was modified. Save it?")) {
            this.setValuesToDocument();
            this.saveDocument();
        }
        if (!this.isclosed) {
            this.getShell().setText(dialogtitle);
        }
        this.issaved = false;
        this.ismodified = false;
        this.document = doc;
        this.sender = sender;
        this.update();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setTitle(String title) {
        if (this.isclosed) {
            return;
        }
        this.titlevalue.setText(title);
    }

    public void setListener(FootprintDialogListener l) {
        this.listener = l;
    }

    public void update() {
        Document comment;
        String title;
        if (this.isclosed) {
            return;
        }
        this.titlevalue.removeModifyListener(this.titlemodlistener);
        this.commentvalue.getTextWidget().removeModifyListener(this.editormodlistener);
        String datestr = FootprintPlugin.getDate(this.document);
        try {
            DateFormat df;
            Date d;
            if (datestr != null && (d = (df = DateFormat.getDateInstance()).parse(datestr)) != null) {
                this.datevalue.setText(CalendarUtil.getDateString((Date)d));
            }
        }
        catch (Exception exception) {}
        if ((title = FootprintPlugin.getTitle(this.document)) != null) {
            this.titlevalue.setText(title);
        }
        if ((comment = FootprintPlugin.getComment(this.document)) != null) {
            this.commentvalue.setDocument(comment);
        }
        this.titlevalue.addModifyListener(this.titlemodlistener);
        this.commentvalue.getTextWidget().addModifyListener(this.editormodlistener);
        String category = FootprintPlugin.getCategory(this.document);
        if (this.catvalue.getItemCount() == 0) {
            return;
        }
        int idx = this.catvalue.indexOf(category);
        if (idx >= 0) {
            this.catvalue.select(idx);
        } else {
            this.catvalue.select(0);
        }
        String date = FootprintPlugin.getDate(this.document);
        this.datevalue.setText(date);
        if (this.drawer.isOpened()) {
            ArrayList docs = FootprintPlugin.getDocumentsByTheSameLastMod(this.document);
            this.drawer.setDocuments(docs);
        }
    }

    public void updateCategory() {
        if (this.isclosed) {
            return;
        }
        this.catvalue.removeAll();
        FootprintPlugin fp = FootprintPlugin.getDefault();
        ArrayList l = fp.getCategories();
        Collections.sort(l);
        int i = 0;
        while (i < l.size()) {
            this.catvalue.add((String)l.get(i));
            ++i;
        }
        this.update();
        this.catvalue.pack();
    }
}

