/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class FontWeight extends Enum {
    static final private int _NORMAL = 0;

    static final public FontWeight NORMAL = new FontWeight(_NORMAL);

    static final private int _BOLD = 1;

    static final public FontWeight BOLD = new FontWeight(_BOLD);

    static final private FontWeight[] theInterned = new FontWeight[] { NORMAL,
            BOLD };

    static private java.util.Hashtable theInternedExtras;

    static final private FontWeight theSacrificialOne = new FontWeight(0);

    static public FontWeight intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        FontWeight already = (FontWeight) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new FontWeight(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private FontWeight(int value) {
        value_ = value;
    }

    public boolean test(FontWeight other) {
        return (value_ & other.value_) == other.value_;
    }

}
