/*
 * names.h - name of directories, files, commands.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#if !defined(_SAM_NAMES_H)
#define	_SAM_NAMES_H

#ifdef sun
#pragma ident "$Revision$"
#endif

#define	SAM_CONFIG_PATH		"/etc/opt/SUNWsamfs"		/* configuration data */
#define	SAM_SCRIPT_PATH		SAM_CONFIG_PATH"/scripts"	/* customized scripts */
#define	SAM_VARIABLE_PATH	"/var/opt/SUNWsamfs"		/* variable data */
#define	SAM_EXECUTE_PATH	"/opt/SUNWsamfs/sbin"		/* executables */
#define	SAM_LIBRARY_PATH	"/opt/SUNWsamfs/lib"		/* libraries */
#define	SAM_SAMFS_PATH		"/usr/lib/fs/samfs"		/* samfs programs */

#ifdef linux
#define	MNTTABLK		"/etc/mtab~"			/* the mtab lock file */
#endif /* linux */
#ifdef sun
#define	MNTTAB			"/etc/mnttab"			/* mnttab file */
#define	MOUNTED			MNTTAB				/* mnttab file (generic def) */
#define	MNTTABLK		"/etc/.mnttab.lock"		/* the mnttab lock file */
#endif /* sun */

#define	SAM_AMLD		"sam-amld"			/* automated media library daemon */
#define	SAM_ARCHIVER 		"sam-archiverd"			/* archiver daemon */
#define	SAM_CATSERVER 		"sam-catserverd"		/* catalog server daemon */
#define	SAM_FSD			"sam-fsd"			/* file system daemon */
#define	SAM_RELEASER 		"sam-releaser"			/* releaser daemon */
#define	SAM_RECYCLER 		"sam-recycler"			/* recycler daemon */
#define	SAM_NRECYCLER 		"sam-nrecycler"			/* nrecycler daemon */
#define	SAM_SHAREFSD 		"sam-sharefsd"			/* shared filesystem daemon */
#define	SAM_STAGEALL 		"sam-stagealld"			/* stageall daemon */
#define	SAM_STAGER  		"sam-stagerd"			/* stage daemon */
#define	SAM_RFT			"sam-rftd"			/* file transfer daemon */
#define	SAM_RMTSERVER 		"sam-serverd"			/* remote server daemon */
#define	SAM_RMTCLIENT 		"sam-clientd"			/* remote client daemon */
#define	SAM_MGMTAPI   		"fsmgmt"			/* mgmt api */

#define	CONFIG			"mcf"				/* configuration file name */

/*
 * Sam daemons home or datadirectories.
 */
#define	SAM_AMLD_HOME 		SAM_VARIABLE_PATH"/amld"
#define	SAM_ARCHIVERD_HOME 	SAM_VARIABLE_PATH"/archiver"
#define	SAM_STAGERD_HOME 	SAM_VARIABLE_PATH"/stager"
#define	SAM_CATALOG_DIR 	SAM_VARIABLE_PATH"/catalog"

#define	DEV_NOTIFY_PATH 	SAM_SCRIPT_PATH			/* take action when a dev. is */
								/* down'ed or off'ed */
#define	DEV_NOTIFY_DEFAULT 	"/dev_down.sh"
#define	DISK_VOLUME_TAB   	"diskvolume.tab"		/* disk volume table */

#define	SAVE_CORE_SH  		SAM_SCRIPT_PATH"/save_core.sh"  /* script to save core files */

/*
 * Paths and filenames involved in locating the GUI resource files
 */
#define	SAM_OPT_PATH 		"/opt/SUNWsamfs"
#define	SAM_RESFILE 		"sam-defaults"
#define	SAM_DOTFILE 		".samfs"

#endif   /* _SAM_NAMES_H */
