/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxRichTextObjectPtrArray_append, "append(self, obj: Optional[RichTextObject])");

extern "C" {static PyObject *meth_wxRichTextObjectPtrArray_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectPtrArray_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextObject* obj;
        ::wxRichTextObjectPtrArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextObjectPtrArray, &sipCpp, sipType_wxRichTextObject, &obj))
        {
        sipCpp->Add(obj);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName_append, doc_wxRichTextObjectPtrArray_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextObjectPtrArray_index, "index(self, obj: Optional[RichTextObject]) -> int");

extern "C" {static PyObject *meth_wxRichTextObjectPtrArray_index(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectPtrArray_index(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextObject* obj;
        ::wxRichTextObjectPtrArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextObjectPtrArray, &sipCpp, sipType_wxRichTextObject, &obj))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;
        int idx = sipCpp->Index(obj, false);
        if (idx == wxNOT_FOUND) {
            sipError = sipErrorFail;
            wxPyErr_SetString(PyExc_ValueError,
                              "sequence.index(x): x not in sequence");
            }
        sipRes = idx;

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName_index, doc_wxRichTextObjectPtrArray_index);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxRichTextObjectPtrArray___contains__(PyObject *, PyObject *);}
static int slot_wxRichTextObjectPtrArray___contains__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextObjectPtrArray *sipCpp = reinterpret_cast<::wxRichTextObjectPtrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextObjectPtrArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextObject* obj;

        if (sipParseArgs(&sipParseErr, sipArg, "1J8", sipType_wxRichTextObject, &obj))
        {
            int sipRes = 0;
        int idx = sipCpp->Index(obj, false);
        sipRes = idx != wxNOT_FOUND;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_wxRichTextObjectPtrArray___getitem__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextObjectPtrArray___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextObjectPtrArray *sipCpp = reinterpret_cast<::wxRichTextObjectPtrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextObjectPtrArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long index;

        if (sipParseArgs(&sipParseErr, sipArg, "1l", &index))
        {
            ::wxRichTextObject*sipRes = 0;
            sipErrorState sipError = sipErrorNone;
        if (0 > index)
            index += sipCpp->GetCount();

        if ((index < sipCpp->GetCount()) && (0 <= index)) {
            sipRes = sipCpp->Item(index);
        }
        else {
            wxPyErr_SetString(PyExc_IndexError, "sequence index out of range");
            sipError = sipErrorFail;
        }

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes, sipType_wxRichTextObject, SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectPtrArray, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_wxRichTextObjectPtrArray___len__(PyObject *);}
static Py_ssize_t slot_wxRichTextObjectPtrArray___len__(PyObject *sipSelf)
{
    ::wxRichTextObjectPtrArray *sipCpp = reinterpret_cast<::wxRichTextObjectPtrArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextObjectPtrArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;
        sipRes = sipCpp->GetCount();

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextObjectPtrArray(void *, int);}
static void release_wxRichTextObjectPtrArray(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxRichTextObjectPtrArray *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextObjectPtrArray(Py_ssize_t);}
static void *array_wxRichTextObjectPtrArray(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextObjectPtrArray[sipNrElem];
}


extern "C" {static void assign_wxRichTextObjectPtrArray(void *, Py_ssize_t, void *);}
static void assign_wxRichTextObjectPtrArray(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxRichTextObjectPtrArray *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxRichTextObjectPtrArray *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextObjectPtrArray(const void *, Py_ssize_t);}
static void *copy_wxRichTextObjectPtrArray(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRichTextObjectPtrArray(reinterpret_cast<const ::wxRichTextObjectPtrArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextObjectPtrArray(sipSimpleWrapper *);}
static void dealloc_wxRichTextObjectPtrArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextObjectPtrArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextObjectPtrArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextObjectPtrArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxRichTextObjectPtrArray *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextObjectPtrArray();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::wxRichTextObjectPtrArray* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxRichTextObjectPtrArray, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextObjectPtrArray(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextObjectPtrArray[] = {
    {(void *)slot_wxRichTextObjectPtrArray___contains__, contains_slot},
    {(void *)slot_wxRichTextObjectPtrArray___getitem__, getitem_slot},
    {(void *)slot_wxRichTextObjectPtrArray___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextObjectPtrArray[] = {
    {sipName_append, SIP_MLMETH_CAST(meth_wxRichTextObjectPtrArray_append), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextObjectPtrArray_append},
    {sipName_index, SIP_MLMETH_CAST(meth_wxRichTextObjectPtrArray_index), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextObjectPtrArray_index}
};

PyDoc_STRVAR(doc_wxRichTextObjectPtrArray, "\1RichTextObjectPtrArray()\n"
"RichTextObjectPtrArray(a0: RichTextObjectPtrArray)");


sipClassTypeDef sipTypeDef__richtext_wxRichTextObjectPtrArray = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextObjectPtrArray,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextObjectPtrArray,
        {0, 0, 1},
        2, methods_wxRichTextObjectPtrArray,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextObjectPtrArray,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxRichTextObjectPtrArray,
    init_type_wxRichTextObjectPtrArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextObjectPtrArray,
    assign_wxRichTextObjectPtrArray,
    array_wxRichTextObjectPtrArray,
    copy_wxRichTextObjectPtrArray,
    release_wxRichTextObjectPtrArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
