/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_grid.h"
        #include <wx/grid.h>
        #include <wx/grid.h>
        #include <wx/grid.h>
    int _wxGridBlockCoords___bool__(wxGridBlockCoords* self)
    {
        return self->operator!();
    }
    PyObject* _wxGridBlockCoords_Get(wxGridBlockCoords* self)
    {
        wxPyThreadBlocker blocker;
        return sipBuildResult(0, "(iiii)", self->GetTopRow(), self->GetLeftCol(), self->GetBottomRow(), self->GetRightCol());
    }


PyDoc_STRVAR(doc_wxGridBlockCoords_GetTopRow, "GetTopRow() -> int\n"
"\n"
"Return the row of the left top corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_GetTopRow(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_GetTopRow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTopRow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_GetTopRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_SetTopRow, "SetTopRow(row)\n"
"\n"
"Set the row of the left top corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_SetTopRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_SetTopRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int row;
        ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, &row))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTopRow(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_SetTopRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_GetLeftCol, "GetLeftCol() -> int\n"
"\n"
"Return the column of the left top corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_GetLeftCol(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_GetLeftCol(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLeftCol();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_GetLeftCol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_SetLeftCol, "SetLeftCol(col)\n"
"\n"
"Set the column of the left top corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_SetLeftCol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_SetLeftCol(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int col;
        ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, &col))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLeftCol(col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_SetLeftCol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_GetBottomRow, "GetBottomRow() -> int\n"
"\n"
"Return the row of the bottom right corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_GetBottomRow(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_GetBottomRow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBottomRow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_GetBottomRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_SetBottomRow, "SetBottomRow(row)\n"
"\n"
"Set the row of the bottom right corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_SetBottomRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_SetBottomRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int row;
        ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, &row))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBottomRow(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_SetBottomRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_GetRightCol, "GetRightCol() -> int\n"
"\n"
"Return the column of the bottom right corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_GetRightCol(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_GetRightCol(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRightCol();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_GetRightCol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_SetRightCol, "SetRightCol(col)\n"
"\n"
"Set the column of the bottom right corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_SetRightCol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_SetRightCol(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int col;
        ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, &col))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRightCol(col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_SetRightCol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_GetTopLeft, "GetTopLeft() -> GridCellCoords\n"
"\n"
"Return the coordinates of the top left corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_GetTopLeft(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_GetTopLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            ::wxGridCellCoords*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridCellCoords(sipCpp->GetTopLeft());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridCellCoords, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_GetTopLeft, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_GetBottomRight, "GetBottomRight() -> GridCellCoords\n"
"\n"
"Return the coordinates of the bottom right corner.");

extern "C" {static PyObject *meth_wxGridBlockCoords_GetBottomRight(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_GetBottomRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            ::wxGridCellCoords*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridCellCoords(sipCpp->GetBottomRight());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridCellCoords, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_GetBottomRight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_Canonicalize, "Canonicalize() -> GridBlockCoords\n"
"\n"
"Return the canonicalized block where top left coordinates is less then\n"
"bottom right coordinates.");

extern "C" {static PyObject *meth_wxGridBlockCoords_Canonicalize(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_Canonicalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            ::wxGridBlockCoords*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridBlockCoords(sipCpp->Canonicalize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridBlockCoords, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_Canonicalize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_Intersects, "Intersects(other) -> bool\n"
"\n"
"Whether the blocks intersect.");

extern "C" {static PyObject *meth_wxGridBlockCoords_Intersects(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_Intersects(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords* other;
        const ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, sipType_wxGridBlockCoords, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersects(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_Intersects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_Contains, "Contains(cell) -> bool\n"
"Contains(other) -> bool\n"
"\n"
"Check whether this block contains the given cell.\n"
"");

extern "C" {static PyObject *meth_wxGridBlockCoords_Contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_Contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridCellCoords* cell;
        int cellState = 0;
        const ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cell,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, sipType_wxGridCellCoords, &cell, &cellState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*cell);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxGridCellCoords *>(cell), sipType_wxGridCellCoords, cellState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxGridBlockCoords* other;
        const ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, sipType_wxGridBlockCoords, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_Contains, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_Difference, "Difference(other, splitOrientation) -> GridBlockDiffResult\n"
"\n"
"Calculates the result blocks by subtracting the other block from this\n"
"block.");

extern "C" {static PyObject *meth_wxGridBlockCoords_Difference(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_Difference(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords* other;
        int splitOrientation;
        const ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
            sipName_splitOrientation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9i", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, sipType_wxGridBlockCoords, &other, &splitOrientation))
        {
            ::wxGridBlockDiffResult*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridBlockDiffResult(sipCpp->Difference(*other, splitOrientation));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridBlockDiffResult, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_Difference, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_SymDifference, "SymDifference(other) -> GridBlockDiffResult\n"
"\n"
"Calculates the symmetric difference of the blocks.");

extern "C" {static PyObject *meth_wxGridBlockCoords_SymDifference(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_SymDifference(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords* other;
        const ::wxGridBlockCoords *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxGridBlockCoords, &sipCpp, sipType_wxGridBlockCoords, &other))
        {
            ::wxGridBlockDiffResult*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridBlockDiffResult(sipCpp->SymDifference(*other));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridBlockDiffResult, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_SymDifference, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridBlockCoords_Get, "Get() -> (topRow, leftCol, bottomRow, rightCol)\n"
"\n"
"Return the block coordinants as a tuple.");

extern "C" {static PyObject *meth_wxGridBlockCoords_Get(PyObject *, PyObject *);}
static PyObject *meth_wxGridBlockCoords_Get(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGridBlockCoords *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridBlockCoords, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxGridBlockCoords_Get(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_GridBlockCoords, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxGridBlockCoords___bool__(PyObject *);}
static int slot_wxGridBlockCoords___bool__(PyObject *sipSelf)
{
    ::wxGridBlockCoords *sipCpp = reinterpret_cast<::wxGridBlockCoords *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxGridBlockCoords));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxGridBlockCoords___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxGridBlockCoords___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxGridBlockCoords___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxGridBlockCoords *sipCpp = reinterpret_cast<::wxGridBlockCoords *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxGridBlockCoords));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords* other;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxGridBlockCoords, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxGridBlockCoords::operator!=(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__grid, ne_slot, sipType_wxGridBlockCoords, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxGridBlockCoords___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxGridBlockCoords___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxGridBlockCoords *sipCpp = reinterpret_cast<::wxGridBlockCoords *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxGridBlockCoords));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridBlockCoords* other;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxGridBlockCoords, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxGridBlockCoords::operator==(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__grid, eq_slot, sipType_wxGridBlockCoords, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGridBlockCoords(void *, int);}
static void release_wxGridBlockCoords(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxGridBlockCoords *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGridBlockCoords(Py_ssize_t);}
static void *array_wxGridBlockCoords(Py_ssize_t sipNrElem)
{
    return new ::wxGridBlockCoords[sipNrElem];
}


extern "C" {static void assign_wxGridBlockCoords(void *, Py_ssize_t, void *);}
static void assign_wxGridBlockCoords(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxGridBlockCoords *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxGridBlockCoords *>(sipSrc);
}


extern "C" {static void *copy_wxGridBlockCoords(const void *, Py_ssize_t);}
static void *copy_wxGridBlockCoords(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxGridBlockCoords(reinterpret_cast<const ::wxGridBlockCoords *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGridBlockCoords(sipSimpleWrapper *);}
static void dealloc_wxGridBlockCoords(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGridBlockCoords(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGridBlockCoords(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGridBlockCoords(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxGridBlockCoords *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGridBlockCoords();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int topRow;
        int leftCol;
        int bottomRow;
        int rightCol;

        static const char *sipKwdList[] = {
            sipName_topRow,
            sipName_leftCol,
            sipName_bottomRow,
            sipName_rightCol,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiii", &topRow, &leftCol, &bottomRow, &rightCol))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGridBlockCoords(topRow, leftCol, bottomRow, rightCol);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxGridBlockCoords* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxGridBlockCoords, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGridBlockCoords(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxGridBlockCoords[] = {
    {(void *)slot_wxGridBlockCoords___bool__, bool_slot},
    {(void *)slot_wxGridBlockCoords___ne__, ne_slot},
    {(void *)slot_wxGridBlockCoords___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxGridBlockCoords[] = {
    {sipName_Canonicalize, meth_wxGridBlockCoords_Canonicalize, METH_VARARGS, doc_wxGridBlockCoords_Canonicalize},
    {sipName_Contains, SIP_MLMETH_CAST(meth_wxGridBlockCoords_Contains), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_Contains},
    {sipName_Difference, SIP_MLMETH_CAST(meth_wxGridBlockCoords_Difference), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_Difference},
    {sipName_Get, meth_wxGridBlockCoords_Get, METH_VARARGS, doc_wxGridBlockCoords_Get},
    {sipName_GetBottomRight, meth_wxGridBlockCoords_GetBottomRight, METH_VARARGS, doc_wxGridBlockCoords_GetBottomRight},
    {sipName_GetBottomRow, meth_wxGridBlockCoords_GetBottomRow, METH_VARARGS, doc_wxGridBlockCoords_GetBottomRow},
    {sipName_GetLeftCol, meth_wxGridBlockCoords_GetLeftCol, METH_VARARGS, doc_wxGridBlockCoords_GetLeftCol},
    {sipName_GetRightCol, meth_wxGridBlockCoords_GetRightCol, METH_VARARGS, doc_wxGridBlockCoords_GetRightCol},
    {sipName_GetTopLeft, meth_wxGridBlockCoords_GetTopLeft, METH_VARARGS, doc_wxGridBlockCoords_GetTopLeft},
    {sipName_GetTopRow, meth_wxGridBlockCoords_GetTopRow, METH_VARARGS, doc_wxGridBlockCoords_GetTopRow},
    {sipName_Intersects, SIP_MLMETH_CAST(meth_wxGridBlockCoords_Intersects), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_Intersects},
    {sipName_SetBottomRow, SIP_MLMETH_CAST(meth_wxGridBlockCoords_SetBottomRow), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_SetBottomRow},
    {sipName_SetLeftCol, SIP_MLMETH_CAST(meth_wxGridBlockCoords_SetLeftCol), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_SetLeftCol},
    {sipName_SetRightCol, SIP_MLMETH_CAST(meth_wxGridBlockCoords_SetRightCol), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_SetRightCol},
    {sipName_SetTopRow, SIP_MLMETH_CAST(meth_wxGridBlockCoords_SetTopRow), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_SetTopRow},
    {sipName_SymDifference, SIP_MLMETH_CAST(meth_wxGridBlockCoords_SymDifference), METH_VARARGS|METH_KEYWORDS, doc_wxGridBlockCoords_SymDifference}
};

sipVariableDef variables_wxGridBlockCoords[] = {
    {PropertyVariable, sipName_TopRow, &methods_wxGridBlockCoords[9], &methods_wxGridBlockCoords[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TopLeft, &methods_wxGridBlockCoords[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RightCol, &methods_wxGridBlockCoords[7], &methods_wxGridBlockCoords[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LeftCol, &methods_wxGridBlockCoords[6], &methods_wxGridBlockCoords[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BottomRow, &methods_wxGridBlockCoords[5], &methods_wxGridBlockCoords[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BottomRight, &methods_wxGridBlockCoords[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxGridBlockCoords, "GridBlockCoords()\n"
"GridBlockCoords(topRow, leftCol, bottomRow, rightCol)\n"
"\n"
"Represents coordinates of a block of cells in the grid.");


sipClassTypeDef sipTypeDef__grid_wxGridBlockCoords = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxGridBlockCoords,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_GridBlockCoords,
        {0, 0, 1},
        16, methods_wxGridBlockCoords,
        0, SIP_NULLPTR,
        6, variables_wxGridBlockCoords,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGridBlockCoords,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxGridBlockCoords,
    init_type_wxGridBlockCoords,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGridBlockCoords,
    assign_wxGridBlockCoords,
    array_wxGridBlockCoords,
    copy_wxGridBlockCoords,
    release_wxGridBlockCoords,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
