/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/vscroll.h>
        #include <wx/window.h>


class sipwxVarHScrollHelper : public ::wxVarHScrollHelper
{
public:
    sipwxVarHScrollHelper(::wxWindow*);
    sipwxVarHScrollHelper(const ::wxVarHScrollHelper&);
    virtual ~sipwxVarHScrollHelper();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    ::wxCoord sipProtectVirt_EstimateTotalWidth(bool) const;
    void sipProtectVirt_OnGetColumnsWidthHint(bool, size_t, size_t) const;
    ::wxCoord sipProtect_OnGetColumnWidth(size_t) const;
    void sipProtectVirt_OnGetUnitsSizeHint(bool, size_t, size_t) const;
    ::wxCoord sipProtectVirt_EstimateTotalSize(bool) const;
    int sipProtectVirt_GetNonOrientationTargetSize(bool) const;
    ::wxOrientation sipProtectVirt_GetOrientation(bool) const;
    int sipProtectVirt_GetOrientationTargetSize(bool) const;
    ::wxCoord sipProtectVirt_OnGetUnitSize(bool, size_t) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxCoord OnGetColumnWidth(size_t) const SIP_OVERRIDE;
    void OnGetColumnsWidthHint(size_t, size_t) const SIP_OVERRIDE;
    ::wxCoord EstimateTotalWidth() const SIP_OVERRIDE;
    bool ScrollColumns(int) SIP_OVERRIDE;
    bool ScrollColumnPages(int) SIP_OVERRIDE;
    void RefreshColumns(size_t, size_t) SIP_OVERRIDE;
    void RefreshColumn(size_t) SIP_OVERRIDE;
    int GetNonOrientationTargetSize() const SIP_OVERRIDE;
    ::wxOrientation GetOrientation() const SIP_OVERRIDE;
    int GetOrientationTargetSize() const SIP_OVERRIDE;
    void OnGetUnitsSizeHint(size_t, size_t) const SIP_OVERRIDE;
    ::wxCoord EstimateTotalSize() const SIP_OVERRIDE;
    ::wxCoord OnGetUnitSize(size_t) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxVarHScrollHelper(const sipwxVarHScrollHelper &);
    sipwxVarHScrollHelper &operator = (const sipwxVarHScrollHelper &);

    char sipPyMethods[13];
};

sipwxVarHScrollHelper::sipwxVarHScrollHelper(::wxWindow*winToScroll): ::wxVarHScrollHelper(winToScroll), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarHScrollHelper::sipwxVarHScrollHelper(const ::wxVarHScrollHelper& a0): ::wxVarHScrollHelper(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarHScrollHelper::~sipwxVarHScrollHelper()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxCoord sipwxVarHScrollHelper::OnGetColumnWidth(size_t column) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_VarHScrollHelper, sipName_OnGetColumnWidth);

    if (!sipMeth)
        return 0;

    extern ::wxCoord sipVH__core_145(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    return sipVH__core_145(sipGILState, 0, sipPySelf, sipMeth, column);
}

void sipwxVarHScrollHelper::OnGetColumnsWidthHint(size_t columnMin, size_t columnMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetColumnsWidthHint);

    if (!sipMeth)
    {
        ::wxVarHScrollHelper::OnGetColumnsWidthHint(columnMin, columnMax);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, columnMin, columnMax);
}

::wxCoord sipwxVarHScrollHelper::EstimateTotalWidth() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[2]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_EstimateTotalWidth);

    if (!sipMeth)
        return ::wxVarHScrollHelper::EstimateTotalWidth();

    extern ::wxCoord sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxVarHScrollHelper::ScrollColumns(int columns)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_ScrollColumns);

    if (!sipMeth)
        return ::wxVarHScrollHelper::ScrollColumns(columns);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, columns);
}

bool sipwxVarHScrollHelper::ScrollColumnPages(int pages)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_ScrollColumnPages);

    if (!sipMeth)
        return ::wxVarHScrollHelper::ScrollColumnPages(pages);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, pages);
}

void sipwxVarHScrollHelper::RefreshColumns(size_t from_, size_t to_)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_RefreshColumns);

    if (!sipMeth)
    {
        ::wxVarHScrollHelper::RefreshColumns(from_, to_);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, from_, to_);
}

void sipwxVarHScrollHelper::RefreshColumn(size_t column)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_RefreshColumn);

    if (!sipMeth)
    {
        ::wxVarHScrollHelper::RefreshColumn(column);
        return;
    }

    extern void sipVH__core_146(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    sipVH__core_146(sipGILState, 0, sipPySelf, sipMeth, column);
}

int sipwxVarHScrollHelper::GetNonOrientationTargetSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[7]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetNonOrientationTargetSize);

    if (!sipMeth)
        return ::wxVarHScrollHelper::GetNonOrientationTargetSize();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

::wxOrientation sipwxVarHScrollHelper::GetOrientation() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetOrientation);

    if (!sipMeth)
        return ::wxVarHScrollHelper::GetOrientation();

    extern ::wxOrientation sipVH__core_143(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_143(sipGILState, 0, sipPySelf, sipMeth);
}

int sipwxVarHScrollHelper::GetOrientationTargetSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetOrientationTargetSize);

    if (!sipMeth)
        return ::wxVarHScrollHelper::GetOrientationTargetSize();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxVarHScrollHelper::OnGetUnitsSizeHint(size_t unitMin, size_t unitMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[10]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetUnitsSizeHint);

    if (!sipMeth)
    {
        ::wxVarHScrollHelper::OnGetUnitsSizeHint(unitMin, unitMax);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, unitMin, unitMax);
}

::wxCoord sipwxVarHScrollHelper::EstimateTotalSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_EstimateTotalSize);

    if (!sipMeth)
        return ::wxVarHScrollHelper::EstimateTotalSize();

    extern ::wxCoord sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

::wxCoord sipwxVarHScrollHelper::OnGetUnitSize(size_t unit) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetUnitSize);

    if (!sipMeth)
        return ::wxVarHScrollHelper::OnGetUnitSize(unit);

    extern ::wxCoord sipVH__core_145(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    return sipVH__core_145(sipGILState, 0, sipPySelf, sipMeth, unit);
}

::wxCoord sipwxVarHScrollHelper::sipProtectVirt_EstimateTotalWidth(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::EstimateTotalWidth() : EstimateTotalWidth());
}

void sipwxVarHScrollHelper::sipProtectVirt_OnGetColumnsWidthHint(bool sipSelfWasArg, size_t columnMin, size_t columnMax) const
{
    (sipSelfWasArg ? ::wxVarHScrollHelper::OnGetColumnsWidthHint(columnMin, columnMax) : OnGetColumnsWidthHint(columnMin, columnMax));
}

::wxCoord sipwxVarHScrollHelper::sipProtect_OnGetColumnWidth(size_t column) const
{
    return OnGetColumnWidth(column);
}

void sipwxVarHScrollHelper::sipProtectVirt_OnGetUnitsSizeHint(bool sipSelfWasArg, size_t unitMin, size_t unitMax) const
{
    (sipSelfWasArg ? ::wxVarHScrollHelper::OnGetUnitsSizeHint(unitMin, unitMax) : OnGetUnitsSizeHint(unitMin, unitMax));
}

::wxCoord sipwxVarHScrollHelper::sipProtectVirt_EstimateTotalSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::EstimateTotalSize() : EstimateTotalSize());
}

int sipwxVarHScrollHelper::sipProtectVirt_GetNonOrientationTargetSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::GetNonOrientationTargetSize() : GetNonOrientationTargetSize());
}

::wxOrientation sipwxVarHScrollHelper::sipProtectVirt_GetOrientation(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::GetOrientation() : GetOrientation());
}

int sipwxVarHScrollHelper::sipProtectVirt_GetOrientationTargetSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::GetOrientationTargetSize() : GetOrientationTargetSize());
}

::wxCoord sipwxVarHScrollHelper::sipProtectVirt_OnGetUnitSize(bool sipSelfWasArg, size_t unit) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::OnGetUnitSize(unit) : OnGetUnitSize(unit));
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_GetColumnCount, "GetColumnCount() -> size_t\n"
"\n"
"Returns the number of columns the target window contains.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_GetColumnCount(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_GetColumnCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumnCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_GetColumnCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_GetVisibleColumnsBegin, "GetVisibleColumnsBegin() -> size_t\n"
"\n"
"Returns the index of the first visible column based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_GetVisibleColumnsBegin(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_GetVisibleColumnsBegin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVisibleColumnsBegin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_GetVisibleColumnsBegin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_GetVisibleColumnsEnd, "GetVisibleColumnsEnd() -> size_t\n"
"\n"
"Returns the index of the last visible column based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_GetVisibleColumnsEnd(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_GetVisibleColumnsEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVisibleColumnsEnd();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_GetVisibleColumnsEnd, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_IsColumnVisible, "IsColumnVisible(column) -> bool\n"
"\n"
"Returns true if the given column is currently visible (even if only\n"
"partially visible) or false otherwise.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_IsColumnVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_IsColumnVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t column;
        const ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &column))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsColumnVisible(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_IsColumnVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_RefreshColumn, "RefreshColumn(column)\n"
"\n"
"Triggers a refresh for just the given column's area of the window if\n"
"it's visible.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_RefreshColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_RefreshColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t column;
        ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &column))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarHScrollHelper::RefreshColumn(column) : sipCpp->RefreshColumn(column));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_RefreshColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_RefreshColumns, "RefreshColumns(from_, to_)\n"
"\n"
"Triggers a refresh for the area between the specified range of columns\n"
"given (inclusively).");

extern "C" {static PyObject *meth_wxVarHScrollHelper_RefreshColumns(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_RefreshColumns(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t from_;
        size_t to_;
        ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &from_, &to_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarHScrollHelper::RefreshColumns(from_, to_) : sipCpp->RefreshColumns(from_, to_));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_RefreshColumns, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_ScrollColumnPages, "ScrollColumnPages(pages) -> bool\n"
"\n"
"Scroll by the specified number of pages which may be positive (to\n"
"scroll right) or negative (to scroll left).");

extern "C" {static PyObject *meth_wxVarHScrollHelper_ScrollColumnPages(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_ScrollColumnPages(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int pages;
        ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pages,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &pages))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxVarHScrollHelper::ScrollColumnPages(pages) : sipCpp->ScrollColumnPages(pages));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_ScrollColumnPages, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_ScrollColumns, "ScrollColumns(columns) -> bool\n"
"\n"
"Scroll by the specified number of columns which may be positive (to\n"
"scroll right) or negative (to scroll left).");

extern "C" {static PyObject *meth_wxVarHScrollHelper_ScrollColumns(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_ScrollColumns(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int columns;
        ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_columns,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &columns))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxVarHScrollHelper::ScrollColumns(columns) : sipCpp->ScrollColumns(columns));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_ScrollColumns, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_ScrollToColumn, "ScrollToColumn(column) -> bool\n"
"\n"
"Scroll to the specified column.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_ScrollToColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_ScrollToColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t column;
        ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &column))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ScrollToColumn(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_ScrollToColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_SetColumnCount, "SetColumnCount(columnCount)\n"
"\n"
"Set the number of columns the window contains.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_SetColumnCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_SetColumnCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t columnCount;
        ::wxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_columnCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &columnCount))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColumnCount(columnCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_SetColumnCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_EstimateTotalWidth, "EstimateTotalWidth() -> Coord\n"
"\n"
"This class forwards calls from EstimateTotalSize() to this function so\n"
"derived classes can override either just the height or the width\n"
"estimation, or just estimate both differently if desired in any\n"
"wxHVScrolledWindow derived class.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_EstimateTotalWidth(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_EstimateTotalWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalWidth(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_EstimateTotalWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_OnGetColumnsWidthHint, "OnGetColumnsWidthHint(columnMin, columnMax)\n"
"\n"
"This function doesn't have to be overridden but it may be useful to do\n"
"so if calculating the columns' sizes is a relatively expensive\n"
"operation as it gives your code a chance to calculate several of them\n"
"at once and cache the result if necessary.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_OnGetColumnsWidthHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_OnGetColumnsWidthHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t columnMin;
        size_t columnMax;
        const sipwxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_columnMin,
            sipName_columnMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &columnMin, &columnMax))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetColumnsWidthHint(sipSelfWasArg, columnMin, columnMax);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_OnGetColumnsWidthHint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_OnGetColumnWidth, "OnGetColumnWidth(column) -> Coord\n"
"\n"
"This function must be overridden in the derived class, and should\n"
"return the width of the given column in pixels.");

extern "C" {static PyObject *meth_wxVarHScrollHelper_OnGetColumnWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_OnGetColumnWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        size_t column;
        const sipwxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &column))
        {
            ::wxCoord sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarHScrollHelper, sipName_OnGetColumnWidth);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_OnGetColumnWidth(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_OnGetColumnWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_OnGetUnitsSizeHint, "OnGetUnitsSizeHint(self, unitMin: int, unitMax: int)");

extern "C" {static PyObject *meth_wxVarHScrollHelper_OnGetUnitsSizeHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_OnGetUnitsSizeHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t unitMin;
        size_t unitMax;
        const sipwxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unitMin,
            sipName_unitMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &unitMin, &unitMax))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetUnitsSizeHint(sipSelfWasArg, unitMin, unitMax);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_OnGetUnitsSizeHint, doc_wxVarHScrollHelper_OnGetUnitsSizeHint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_EstimateTotalSize, "EstimateTotalSize(self) -> int");

extern "C" {static PyObject *meth_wxVarHScrollHelper_EstimateTotalSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_EstimateTotalSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_EstimateTotalSize, doc_wxVarHScrollHelper_EstimateTotalSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_GetNonOrientationTargetSize, "GetNonOrientationTargetSize(self) -> int");

extern "C" {static PyObject *meth_wxVarHScrollHelper_GetNonOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_GetNonOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetNonOrientationTargetSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_GetNonOrientationTargetSize, doc_wxVarHScrollHelper_GetNonOrientationTargetSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_GetOrientation, "GetOrientation(self) -> Orientation");

extern "C" {static PyObject *meth_wxVarHScrollHelper_GetOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_GetOrientation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            ::wxOrientation sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetOrientation(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxOrientation);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_GetOrientation, doc_wxVarHScrollHelper_GetOrientation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_GetOrientationTargetSize, "GetOrientationTargetSize(self) -> int");

extern "C" {static PyObject *meth_wxVarHScrollHelper_GetOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_GetOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetOrientationTargetSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_GetOrientationTargetSize, doc_wxVarHScrollHelper_GetOrientationTargetSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHScrollHelper_OnGetUnitSize, "OnGetUnitSize(self, unit: int) -> int");

extern "C" {static PyObject *meth_wxVarHScrollHelper_OnGetUnitSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHScrollHelper_OnGetUnitSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t unit;
        const sipwxVarHScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHScrollHelper, &sipCpp, &unit))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_OnGetUnitSize(sipSelfWasArg, unit);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHScrollHelper, sipName_OnGetUnitSize, doc_wxVarHScrollHelper_OnGetUnitSize);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxVarHScrollHelper(void *, const sipTypeDef *);}
static void *cast_wxVarHScrollHelper(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxVarHScrollHelper *sipCpp = reinterpret_cast<::wxVarHScrollHelper *>(sipCppV);

    if (targetType == sipType_wxVarHScrollHelper)
        return sipCppV;

    if (targetType == sipType_wxVarScrollHelperBase)
        return static_cast<::wxVarScrollHelperBase *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVarHScrollHelper(void *, int);}
static void release_wxVarHScrollHelper(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxVarHScrollHelper *>(sipCppV);
    else
        delete reinterpret_cast<::wxVarHScrollHelper *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxVarHScrollHelper(sipSimpleWrapper *);}
static void dealloc_wxVarHScrollHelper(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxVarHScrollHelper *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVarHScrollHelper(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxVarHScrollHelper(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxVarHScrollHelper(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxVarHScrollHelper *sipCpp = SIP_NULLPTR;

    {
        ::wxWindow* winToScroll;

        static const char *sipKwdList[] = {
            sipName_winToScroll,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_wxWindow, &winToScroll))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarHScrollHelper(winToScroll);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxVarHScrollHelper* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxVarHScrollHelper, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarHScrollHelper(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxVarHScrollHelper[] = {{622, 255, 1}};


static PyMethodDef methods_wxVarHScrollHelper[] = {
    {sipName_EstimateTotalSize, meth_wxVarHScrollHelper_EstimateTotalSize, METH_VARARGS, doc_wxVarHScrollHelper_EstimateTotalSize},
    {sipName_EstimateTotalWidth, meth_wxVarHScrollHelper_EstimateTotalWidth, METH_VARARGS, doc_wxVarHScrollHelper_EstimateTotalWidth},
    {sipName_GetColumnCount, meth_wxVarHScrollHelper_GetColumnCount, METH_VARARGS, doc_wxVarHScrollHelper_GetColumnCount},
    {sipName_GetNonOrientationTargetSize, meth_wxVarHScrollHelper_GetNonOrientationTargetSize, METH_VARARGS, doc_wxVarHScrollHelper_GetNonOrientationTargetSize},
    {sipName_GetOrientation, meth_wxVarHScrollHelper_GetOrientation, METH_VARARGS, doc_wxVarHScrollHelper_GetOrientation},
    {sipName_GetOrientationTargetSize, meth_wxVarHScrollHelper_GetOrientationTargetSize, METH_VARARGS, doc_wxVarHScrollHelper_GetOrientationTargetSize},
    {sipName_GetVisibleColumnsBegin, meth_wxVarHScrollHelper_GetVisibleColumnsBegin, METH_VARARGS, doc_wxVarHScrollHelper_GetVisibleColumnsBegin},
    {sipName_GetVisibleColumnsEnd, meth_wxVarHScrollHelper_GetVisibleColumnsEnd, METH_VARARGS, doc_wxVarHScrollHelper_GetVisibleColumnsEnd},
    {sipName_IsColumnVisible, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_IsColumnVisible), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_IsColumnVisible},
    {sipName_OnGetColumnWidth, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_OnGetColumnWidth), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_OnGetColumnWidth},
    {sipName_OnGetColumnsWidthHint, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_OnGetColumnsWidthHint), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_OnGetColumnsWidthHint},
    {sipName_OnGetUnitSize, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_OnGetUnitSize), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_OnGetUnitSize},
    {sipName_OnGetUnitsSizeHint, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_OnGetUnitsSizeHint), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_OnGetUnitsSizeHint},
    {sipName_RefreshColumn, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_RefreshColumn), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_RefreshColumn},
    {sipName_RefreshColumns, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_RefreshColumns), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_RefreshColumns},
    {sipName_ScrollColumnPages, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_ScrollColumnPages), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_ScrollColumnPages},
    {sipName_ScrollColumns, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_ScrollColumns), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_ScrollColumns},
    {sipName_ScrollToColumn, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_ScrollToColumn), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_ScrollToColumn},
    {sipName_SetColumnCount, SIP_MLMETH_CAST(meth_wxVarHScrollHelper_SetColumnCount), METH_VARARGS|METH_KEYWORDS, doc_wxVarHScrollHelper_SetColumnCount}
};

sipVariableDef variables_wxVarHScrollHelper[] = {
    {PropertyVariable, sipName_VisibleColumnsEnd, &methods_wxVarHScrollHelper[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VisibleColumnsBegin, &methods_wxVarHScrollHelper[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ColumnCount, &methods_wxVarHScrollHelper[2], &methods_wxVarHScrollHelper[18], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxVarHScrollHelper, "VarHScrollHelper(winToScroll)\n"
"\n"
"This class provides functions wrapping the wxVarScrollHelperBase\n"
"class, targeted for horizontal-specific scrolling.");


sipClassTypeDef sipTypeDef__core_wxVarHScrollHelper = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxVarHScrollHelper,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_VarHScrollHelper,
        {0, 0, 1},
        19, methods_wxVarHScrollHelper,
        0, SIP_NULLPTR,
        3, variables_wxVarHScrollHelper,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxVarHScrollHelper,
    -1,
    -1,
    supers_wxVarHScrollHelper,
    SIP_NULLPTR,
    init_type_wxVarHScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxVarHScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxVarHScrollHelper,
    cast_wxVarHScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
