/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/cmndata.h>
        #include <wx/cmndata.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    int _wxPageSetupDialogData___nonzero__(wxPageSetupDialogData* self)
    {
        return self->IsOk();
    }
    int _wxPageSetupDialogData___bool__(wxPageSetupDialogData* self)
    {
        return self->IsOk();
    }


PyDoc_STRVAR(doc_wxPageSetupDialogData_EnableHelp, "EnableHelp(flag)\n"
"\n"
"Enables or disables the \"Help\" button (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_EnableHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_EnableHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableHelp(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_EnableHelp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_EnableMargins, "EnableMargins(flag)\n"
"\n"
"Enables or disables the margin controls (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_EnableMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_EnableMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableMargins(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_EnableMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_EnableOrientation, "EnableOrientation(flag)\n"
"\n"
"Enables or disables the orientation control (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_EnableOrientation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_EnableOrientation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableOrientation(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_EnableOrientation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_EnablePaper, "EnablePaper(flag)\n"
"\n"
"Enables or disables the paper size control (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_EnablePaper(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_EnablePaper(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnablePaper(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_EnablePaper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_EnablePrinter, "EnablePrinter(flag)\n"
"\n"
"Enables or disables the \"Printer\" button, which invokes a printer\n"
"setup dialog.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_EnablePrinter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_EnablePrinter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnablePrinter(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_EnablePrinter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetDefaultInfo, "GetDefaultInfo() -> bool\n"
"\n"
"Returns true if the dialog will simply return default printer\n"
"information (such as orientation) instead of showing a dialog (Windows\n"
"only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetDefaultInfo(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetDefaultInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDefaultInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetDefaultInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetDefaultMinMargins, "GetDefaultMinMargins() -> bool\n"
"\n"
"Returns true if the page setup dialog will take its minimum margin\n"
"values from the currently selected printer properties (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetDefaultMinMargins(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetDefaultMinMargins(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDefaultMinMargins();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetDefaultMinMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetEnableHelp, "GetEnableHelp() -> bool\n"
"\n"
"Returns true if the printer setup button is enabled.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetEnableHelp(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetEnableHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnableHelp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetEnableHelp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetEnableMargins, "GetEnableMargins() -> bool\n"
"\n"
"Returns true if the margin controls are enabled (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetEnableMargins(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetEnableMargins(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnableMargins();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetEnableMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetEnableOrientation, "GetEnableOrientation() -> bool\n"
"\n"
"Returns true if the orientation control is enabled (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetEnableOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetEnableOrientation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnableOrientation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetEnableOrientation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetEnablePaper, "GetEnablePaper() -> bool\n"
"\n"
"Returns true if the paper size control is enabled (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetEnablePaper(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetEnablePaper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnablePaper();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetEnablePaper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetEnablePrinter, "GetEnablePrinter() -> bool\n"
"\n"
"Returns true if the printer setup button is enabled.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetEnablePrinter(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetEnablePrinter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnablePrinter();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetEnablePrinter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetMarginBottomRight, "GetMarginBottomRight() -> Point\n"
"\n"
"Returns the right (x) and bottom (y) margins in millimetres.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetMarginBottomRight(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetMarginBottomRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetMarginBottomRight());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetMarginBottomRight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetMarginTopLeft, "GetMarginTopLeft() -> Point\n"
"\n"
"Returns the left (x) and top (y) margins in millimetres.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetMarginTopLeft(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetMarginTopLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetMarginTopLeft());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetMarginTopLeft, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetMinMarginBottomRight, "GetMinMarginBottomRight() -> Point\n"
"\n"
"Returns the right (x) and bottom (y) minimum margins the user can\n"
"enter (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetMinMarginBottomRight(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetMinMarginBottomRight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetMinMarginBottomRight());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetMinMarginBottomRight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetMinMarginTopLeft, "GetMinMarginTopLeft() -> Point\n"
"\n"
"Returns the left (x) and top (y) minimum margins the user can enter\n"
"(Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetMinMarginTopLeft(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetMinMarginTopLeft(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetMinMarginTopLeft());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetMinMarginTopLeft, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetPaperId, "GetPaperId() -> PaperSize\n"
"\n"
"Returns the paper id (stored in the internal wxPrintData object).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetPaperId(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetPaperId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxPaperSize sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPaperId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxPaperSize);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetPaperId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetPaperSize, "GetPaperSize() -> Size\n"
"\n"
"Returns the paper size in millimetres.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetPaperSize(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetPaperSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetPaperSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetPaperSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_GetPrintData, "GetPrintData() -> PrintData\n"
"\n"
"Returns a reference to the print data associated with this object.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_GetPrintData(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_GetPrintData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            ::wxPrintData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetPrintData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPrintData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_GetPrintData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the print data associated with the dialog data is\n"
"valid.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetDefaultInfo, "SetDefaultInfo(flag)\n"
"\n"
"Pass true if the dialog will simply return default printer information\n"
"(such as orientation) instead of showing a dialog (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetDefaultInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetDefaultInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDefaultInfo(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetDefaultInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetDefaultMinMargins, "SetDefaultMinMargins(flag)\n"
"\n"
"Pass true if the page setup dialog will take its minimum margin values\n"
"from the currently selected printer properties (Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetDefaultMinMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetDefaultMinMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDefaultMinMargins(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetDefaultMinMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetMarginBottomRight, "SetMarginBottomRight(pt)\n"
"\n"
"Sets the right (x) and bottom (y) margins in millimetres.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetMarginBottomRight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetMarginBottomRight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMarginBottomRight(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetMarginBottomRight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetMarginTopLeft, "SetMarginTopLeft(pt)\n"
"\n"
"Sets the left (x) and top (y) margins in millimetres.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetMarginTopLeft(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetMarginTopLeft(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMarginTopLeft(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetMarginTopLeft, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetMinMarginBottomRight, "SetMinMarginBottomRight(pt)\n"
"\n"
"Sets the right (x) and bottom (y) minimum margins the user can enter\n"
"(Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetMinMarginBottomRight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetMinMarginBottomRight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMinMarginBottomRight(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetMinMarginBottomRight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetMinMarginTopLeft, "SetMinMarginTopLeft(pt)\n"
"\n"
"Sets the left (x) and top (y) minimum margins the user can enter\n"
"(Windows only).");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetMinMarginTopLeft(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetMinMarginTopLeft(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMinMarginTopLeft(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetMinMarginTopLeft, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetPaperId, "SetPaperId(id)\n"
"\n"
"Sets the paper size id.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetPaperId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetPaperId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPaperSize id;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxPaperSize, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPaperId(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetPaperId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetPaperSize, "SetPaperSize(size)\n"
"\n"
"Sets the paper size in millimetres.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetPaperSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetPaperSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* size;
        int sizeState = 0;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPaperSize(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxSize *>(size), sipType_wxSize, sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetPaperSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData_SetPrintData, "SetPrintData(printData)\n"
"\n"
"Sets the print data associated with this object.");

extern "C" {static PyObject *meth_wxPageSetupDialogData_SetPrintData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData_SetPrintData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPrintData* printData;
        ::wxPageSetupDialogData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_printData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp, sipType_wxPrintData, &printData))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPrintData(*printData);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName_SetPrintData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPageSetupDialogData___nonzero__, "__nonzero__() -> int");

extern "C" {static PyObject *meth_wxPageSetupDialogData___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxPageSetupDialogData___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPageSetupDialogData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPageSetupDialogData, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPageSetupDialogData___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PageSetupDialogData, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxPageSetupDialogData___bool__(PyObject *);}
static int slot_wxPageSetupDialogData___bool__(PyObject *sipSelf)
{
    ::wxPageSetupDialogData *sipCpp = reinterpret_cast<::wxPageSetupDialogData *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxPageSetupDialogData));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPageSetupDialogData___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPageSetupDialogData(void *, const sipTypeDef *);}
static void *cast_wxPageSetupDialogData(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxPageSetupDialogData *sipCpp = reinterpret_cast<::wxPageSetupDialogData *>(sipCppV);

    if (targetType == sipType_wxPageSetupDialogData)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast<::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPageSetupDialogData(void *, int);}
static void release_wxPageSetupDialogData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxPageSetupDialogData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxPageSetupDialogData(Py_ssize_t);}
static void *array_wxPageSetupDialogData(Py_ssize_t sipNrElem)
{
    return new ::wxPageSetupDialogData[sipNrElem];
}


extern "C" {static void assign_wxPageSetupDialogData(void *, Py_ssize_t, void *);}
static void assign_wxPageSetupDialogData(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxPageSetupDialogData *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxPageSetupDialogData *>(sipSrc);
}


extern "C" {static void *copy_wxPageSetupDialogData(const void *, Py_ssize_t);}
static void *copy_wxPageSetupDialogData(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxPageSetupDialogData(reinterpret_cast<const ::wxPageSetupDialogData *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPageSetupDialogData(sipSimpleWrapper *);}
static void dealloc_wxPageSetupDialogData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPageSetupDialogData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPageSetupDialogData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPageSetupDialogData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxPageSetupDialogData *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPageSetupDialogData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxPageSetupDialogData* data;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxPageSetupDialogData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPageSetupDialogData(*data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxPrintData* printData;

        static const char *sipKwdList[] = {
            sipName_printData,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxPrintData, &printData))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPageSetupDialogData(*printData);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPageSetupDialogData[] = {{392, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxPageSetupDialogData[] = {
    {(void *)slot_wxPageSetupDialogData___bool__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxPageSetupDialogData[] = {
    {sipName_EnableHelp, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_EnableHelp), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_EnableHelp},
    {sipName_EnableMargins, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_EnableMargins), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_EnableMargins},
    {sipName_EnableOrientation, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_EnableOrientation), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_EnableOrientation},
    {sipName_EnablePaper, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_EnablePaper), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_EnablePaper},
    {sipName_EnablePrinter, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_EnablePrinter), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_EnablePrinter},
    {sipName_GetDefaultInfo, meth_wxPageSetupDialogData_GetDefaultInfo, METH_VARARGS, doc_wxPageSetupDialogData_GetDefaultInfo},
    {sipName_GetDefaultMinMargins, meth_wxPageSetupDialogData_GetDefaultMinMargins, METH_VARARGS, doc_wxPageSetupDialogData_GetDefaultMinMargins},
    {sipName_GetEnableHelp, meth_wxPageSetupDialogData_GetEnableHelp, METH_VARARGS, doc_wxPageSetupDialogData_GetEnableHelp},
    {sipName_GetEnableMargins, meth_wxPageSetupDialogData_GetEnableMargins, METH_VARARGS, doc_wxPageSetupDialogData_GetEnableMargins},
    {sipName_GetEnableOrientation, meth_wxPageSetupDialogData_GetEnableOrientation, METH_VARARGS, doc_wxPageSetupDialogData_GetEnableOrientation},
    {sipName_GetEnablePaper, meth_wxPageSetupDialogData_GetEnablePaper, METH_VARARGS, doc_wxPageSetupDialogData_GetEnablePaper},
    {sipName_GetEnablePrinter, meth_wxPageSetupDialogData_GetEnablePrinter, METH_VARARGS, doc_wxPageSetupDialogData_GetEnablePrinter},
    {sipName_GetMarginBottomRight, meth_wxPageSetupDialogData_GetMarginBottomRight, METH_VARARGS, doc_wxPageSetupDialogData_GetMarginBottomRight},
    {sipName_GetMarginTopLeft, meth_wxPageSetupDialogData_GetMarginTopLeft, METH_VARARGS, doc_wxPageSetupDialogData_GetMarginTopLeft},
    {sipName_GetMinMarginBottomRight, meth_wxPageSetupDialogData_GetMinMarginBottomRight, METH_VARARGS, doc_wxPageSetupDialogData_GetMinMarginBottomRight},
    {sipName_GetMinMarginTopLeft, meth_wxPageSetupDialogData_GetMinMarginTopLeft, METH_VARARGS, doc_wxPageSetupDialogData_GetMinMarginTopLeft},
    {sipName_GetPaperId, meth_wxPageSetupDialogData_GetPaperId, METH_VARARGS, doc_wxPageSetupDialogData_GetPaperId},
    {sipName_GetPaperSize, meth_wxPageSetupDialogData_GetPaperSize, METH_VARARGS, doc_wxPageSetupDialogData_GetPaperSize},
    {sipName_GetPrintData, meth_wxPageSetupDialogData_GetPrintData, METH_VARARGS, doc_wxPageSetupDialogData_GetPrintData},
    {sipName_IsOk, meth_wxPageSetupDialogData_IsOk, METH_VARARGS, doc_wxPageSetupDialogData_IsOk},
    {sipName_SetDefaultInfo, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetDefaultInfo), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetDefaultInfo},
    {sipName_SetDefaultMinMargins, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetDefaultMinMargins), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetDefaultMinMargins},
    {sipName_SetMarginBottomRight, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetMarginBottomRight), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetMarginBottomRight},
    {sipName_SetMarginTopLeft, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetMarginTopLeft), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetMarginTopLeft},
    {sipName_SetMinMarginBottomRight, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetMinMarginBottomRight), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetMinMarginBottomRight},
    {sipName_SetMinMarginTopLeft, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetMinMarginTopLeft), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetMinMarginTopLeft},
    {sipName_SetPaperId, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetPaperId), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetPaperId},
    {sipName_SetPaperSize, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetPaperSize), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetPaperSize},
    {sipName_SetPrintData, SIP_MLMETH_CAST(meth_wxPageSetupDialogData_SetPrintData), METH_VARARGS|METH_KEYWORDS, doc_wxPageSetupDialogData_SetPrintData},
    {sipName___nonzero__, meth_wxPageSetupDialogData___nonzero__, METH_VARARGS, doc_wxPageSetupDialogData___nonzero__}
};

sipVariableDef variables_wxPageSetupDialogData[] = {
    {PropertyVariable, sipName_PrintData, &methods_wxPageSetupDialogData[18], &methods_wxPageSetupDialogData[28], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PaperSize, &methods_wxPageSetupDialogData[17], &methods_wxPageSetupDialogData[27], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PaperId, &methods_wxPageSetupDialogData[16], &methods_wxPageSetupDialogData[26], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MinMarginTopLeft, &methods_wxPageSetupDialogData[15], &methods_wxPageSetupDialogData[25], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MinMarginBottomRight, &methods_wxPageSetupDialogData[14], &methods_wxPageSetupDialogData[24], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MarginTopLeft, &methods_wxPageSetupDialogData[13], &methods_wxPageSetupDialogData[23], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MarginBottomRight, &methods_wxPageSetupDialogData[12], &methods_wxPageSetupDialogData[22], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPageSetupDialogData, "PageSetupDialogData()\n"
"PageSetupDialogData(data)\n"
"PageSetupDialogData(printData)\n"
"\n"
"This class holds a variety of information related to\n"
"wxPageSetupDialog.");


sipClassTypeDef sipTypeDef__core_wxPageSetupDialogData = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPageSetupDialogData,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_PageSetupDialogData,
        {0, 0, 1},
        30, methods_wxPageSetupDialogData,
        0, SIP_NULLPTR,
        7, variables_wxPageSetupDialogData,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPageSetupDialogData,
    -1,
    -1,
    supers_wxPageSetupDialogData,
    slots_wxPageSetupDialogData,
    init_type_wxPageSetupDialogData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxPageSetupDialogData,
    assign_wxPageSetupDialogData,
    array_wxPageSetupDialogData,
    copy_wxPageSetupDialogData,
    release_wxPageSetupDialogData,
    cast_wxPageSetupDialogData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
