/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxRichTextProperties_Copy, "Copy(props)\n"
"\n"
"Copies from props.");

extern "C" {static PyObject *meth_wxRichTextProperties_Copy(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_Copy(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties* props;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_props,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxRichTextProperties, &props))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Copy(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_Copy, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_Clear, "Clear()\n"
"\n"
"Clears the properties.");

extern "C" {static PyObject *meth_wxRichTextProperties_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextProperties, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetProperties, "GetProperties() -> RichTextVariantArray\n"
"\n"
"Returns the array of variants implementing the properties.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetProperties(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetProperties(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextProperties, &sipCpp))
        {
             ::wxRichTextVariantArray*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetProperties();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextVariantArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_SetProperties, "SetProperties(props)\n"
"\n"
"Sets the array of variants.");

extern "C" {static PyObject *meth_wxRichTextProperties_SetProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_SetProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextVariantArray* props;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_props,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxRichTextVariantArray, &props))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperties(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_SetProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetPropertyNames, "GetPropertyNames() -> ArrayString\n"
"\n"
"Returns all the property names.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetPropertyNames(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetPropertyNames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextProperties, &sipCpp))
        {
             ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxArrayString(sipCpp->GetPropertyNames());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxArrayString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetPropertyNames, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetCount, "GetCount() -> size_t\n"
"\n"
"Returns a count of the properties.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetCount(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextProperties, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_HasProperty, "HasProperty(name) -> bool\n"
"\n"
"Returns true if the given property is found.");

extern "C" {static PyObject *meth_wxRichTextProperties_HasProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_HasProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasProperty(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_HasProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_Find, "Find(name) -> int\n"
"\n"
"Finds the given property.");

extern "C" {static PyObject *meth_wxRichTextProperties_Find(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_Find(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Find(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_Find, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_Remove, "Remove(name) -> bool\n"
"\n"
"Removes the given property.");

extern "C" {static PyObject *meth_wxRichTextProperties_Remove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_Remove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Remove(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_Remove, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetProperty, "GetProperty(name) -> Variant\n"
"\n"
"Gets the property variant by name.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
             ::wxVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxVariant(sipCpp->GetProperty(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxVariant,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_FindOrCreateProperty, "FindOrCreateProperty(name) -> Variant\n"
"\n"
"Finds or creates a property with the given name, returning a pointer\n"
"to the variant.");

extern "C" {static PyObject *meth_wxRichTextProperties_FindOrCreateProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_FindOrCreateProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
             ::wxVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindOrCreateProperty(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxVariant,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_FindOrCreateProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetPropertyString, "GetPropertyString(name) -> String\n"
"\n"
"Gets the value of the named property as a string.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetPropertyString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetPropertyString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPropertyString(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetPropertyString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetPropertyLong, "GetPropertyLong(name) -> long\n"
"\n"
"Gets the value of the named property as a long integer.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetPropertyLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetPropertyLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyLong(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetPropertyLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetPropertyBool, "GetPropertyBool(name) -> bool\n"
"\n"
"Gets the value of the named property as a boolean.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetPropertyBool(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetPropertyBool(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyBool(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetPropertyBool, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_GetPropertyDouble, "GetPropertyDouble(name) -> double\n"
"\n"
"Gets the value of the named property as a double.");

extern "C" {static PyObject *meth_wxRichTextProperties_GetPropertyDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_GetPropertyDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyDouble(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_GetPropertyDouble, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_SetProperty, "SetProperty(variant)\n"
"SetProperty(name, variant)\n"
"SetProperty(name, value)\n"
"SetProperty(name, value)\n"
"SetProperty(name, value)\n"
"SetProperty(name, value)\n"
"\n"
"Sets the property by passing a variant which contains a name and\n"
"value.\n"
"\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRichTextProperties_SetProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_SetProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVariant* variant;
        int variantState = 0;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_variant,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxVariant, &variant, &variantState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(*variant);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxVariant *>(variant), sipType_wxVariant, variantState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxVariant* variant;
        int variantState = 0;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_variant,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxVariant, &variant, &variantState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(*name,*variant);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxVariant *>(variant), sipType_wxVariant, variantState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* value;
        int valueState = 0;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxString, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(*name,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxString *>(value), sipType_wxString, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxChar* value;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1x", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(*name,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipFree(const_cast<wchar_t *>(value));

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        long value;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1l", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(*name,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        double value;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1d", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxString, &name, &nameState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetProperty(*name,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_SetProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_RemoveProperties, "RemoveProperties(properties)\n"
"\n"
"Removes the given properties from these properties.");

extern "C" {static PyObject *meth_wxRichTextProperties_RemoveProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_RemoveProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties* properties;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_properties,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxRichTextProperties, &properties))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveProperties(*properties);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_RemoveProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextProperties_MergeProperties, "MergeProperties(properties)\n"
"\n"
"Merges the given properties with these properties.");

extern "C" {static PyObject *meth_wxRichTextProperties_MergeProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextProperties_MergeProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties* properties;
         ::wxRichTextProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_properties,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextProperties, &sipCpp, sipType_wxRichTextProperties, &properties))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->MergeProperties(*properties);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextProperties, sipName_MergeProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxRichTextProperties___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxRichTextProperties___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxRichTextProperties *sipCpp = reinterpret_cast< ::wxRichTextProperties *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextProperties));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties* props;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextProperties, &props))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp-> ::wxRichTextProperties::operator==(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxRichTextProperties, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxRichTextProperties___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxRichTextProperties___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxRichTextProperties *sipCpp = reinterpret_cast< ::wxRichTextProperties *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxRichTextProperties));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextProperties* props;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextProperties, &props))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxRichTextProperties::operator==(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxRichTextProperties, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextProperties(void *, const sipTypeDef *);}
static void *cast_wxRichTextProperties(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextProperties *sipCpp = reinterpret_cast< ::wxRichTextProperties *>(sipCppV);

    if (targetType == sipType_wxRichTextProperties)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextProperties(void *, int);}
static void release_wxRichTextProperties(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextProperties *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextProperties(Py_ssize_t);}
static void *array_wxRichTextProperties(Py_ssize_t sipNrElem)
{
    return new  ::wxRichTextProperties[sipNrElem];
}


extern "C" {static void assign_wxRichTextProperties(void *, Py_ssize_t, void *);}
static void assign_wxRichTextProperties(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextProperties *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextProperties *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextProperties(const void *, Py_ssize_t);}
static void *copy_wxRichTextProperties(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxRichTextProperties(reinterpret_cast<const  ::wxRichTextProperties *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextProperties(sipSimpleWrapper *);}
static void dealloc_wxRichTextProperties(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextProperties(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextProperties(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextProperties(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRichTextProperties *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextProperties();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextProperties* props;

        static const char *sipKwdList[] = {
            sipName_props,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRichTextProperties, &props))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextProperties(*props);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextProperties[] = {{42, 0, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextProperties[] = {
    {(void *)slot_wxRichTextProperties___ne__, ne_slot},
    {(void *)slot_wxRichTextProperties___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextProperties[] = {
    {sipName_Clear, meth_wxRichTextProperties_Clear, METH_VARARGS, doc_wxRichTextProperties_Clear},
    {sipName_Copy, SIP_MLMETH_CAST(meth_wxRichTextProperties_Copy), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_Copy},
    {sipName_Find, SIP_MLMETH_CAST(meth_wxRichTextProperties_Find), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_Find},
    {sipName_FindOrCreateProperty, SIP_MLMETH_CAST(meth_wxRichTextProperties_FindOrCreateProperty), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_FindOrCreateProperty},
    {sipName_GetCount, meth_wxRichTextProperties_GetCount, METH_VARARGS, doc_wxRichTextProperties_GetCount},
    {sipName_GetProperties, meth_wxRichTextProperties_GetProperties, METH_VARARGS, doc_wxRichTextProperties_GetProperties},
    {sipName_GetProperty, SIP_MLMETH_CAST(meth_wxRichTextProperties_GetProperty), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_GetProperty},
    {sipName_GetPropertyBool, SIP_MLMETH_CAST(meth_wxRichTextProperties_GetPropertyBool), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_GetPropertyBool},
    {sipName_GetPropertyDouble, SIP_MLMETH_CAST(meth_wxRichTextProperties_GetPropertyDouble), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_GetPropertyDouble},
    {sipName_GetPropertyLong, SIP_MLMETH_CAST(meth_wxRichTextProperties_GetPropertyLong), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_GetPropertyLong},
    {sipName_GetPropertyNames, meth_wxRichTextProperties_GetPropertyNames, METH_VARARGS, doc_wxRichTextProperties_GetPropertyNames},
    {sipName_GetPropertyString, SIP_MLMETH_CAST(meth_wxRichTextProperties_GetPropertyString), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_GetPropertyString},
    {sipName_HasProperty, SIP_MLMETH_CAST(meth_wxRichTextProperties_HasProperty), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_HasProperty},
    {sipName_MergeProperties, SIP_MLMETH_CAST(meth_wxRichTextProperties_MergeProperties), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_MergeProperties},
    {sipName_Remove, SIP_MLMETH_CAST(meth_wxRichTextProperties_Remove), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_Remove},
    {sipName_RemoveProperties, SIP_MLMETH_CAST(meth_wxRichTextProperties_RemoveProperties), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_RemoveProperties},
    {sipName_SetProperties, SIP_MLMETH_CAST(meth_wxRichTextProperties_SetProperties), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_SetProperties},
    {sipName_SetProperty, SIP_MLMETH_CAST(meth_wxRichTextProperties_SetProperty), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextProperties_SetProperty}
};

sipVariableDef variables_wxRichTextProperties[] = {
    {PropertyVariable, sipName_PropertyNames, &methods_wxRichTextProperties[10], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Properties, &methods_wxRichTextProperties[5], &methods_wxRichTextProperties[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Count, &methods_wxRichTextProperties[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextProperties, "RichTextProperties()\n"
"RichTextProperties(props)\n"
"\n"
"A simple property class using wxVariants.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextProperties = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextProperties,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_RichTextProperties,
        {0, 0, 1},
        18, methods_wxRichTextProperties,
        0, SIP_NULLPTR,
        3, variables_wxRichTextProperties,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextProperties,
    -1,
    -1,
    supers_wxRichTextProperties,
    slots_wxRichTextProperties,
    init_type_wxRichTextProperties,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextProperties,
    assign_wxRichTextProperties,
    array_wxRichTextProperties,
    copy_wxRichTextProperties,
    release_wxRichTextProperties,
    cast_wxRichTextProperties,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
